<?php

/**
  * SquirrelMail Yubikey Plugin
  *
  * Copyright (c) 2011-2014 Paul Lesniewski <paul@squirrelmail.org>
  * Copyright (c) 2009 Richard Ferguson <yubikey@fergusnet.com>
  *
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage yubikey
  *
  */

global $yubico_client_id, $yubico_server_key, 
       $yubico_server_url, $yubikey_input_mode,
       $yubico_debug;


// Client ID as obtained from Yubico at
// the following address:
//
// https://upgrade.yubico.com/getapikey/
//
// For example:
//    $yubico_client_id = 4831;
//
$yubico_client_id = 1;



// Yubico API secret (private) key as obtained
// from Yubico at the following address:
//
// https://upgrade.yubico.com/getapikey/
//
// Leave empty to use unisgned validation requests
// (not recommended)
//
// For example:
//    $yubico_server_key = 'vjhFxZrNHB5CjI6vhuSeF2n46a8=';
//
$yubico_server_key = '';



// Yubikey input mode
//
// 1 = Combine with regular password field
//     (user password should be entered first)
// 2 = Separate input field for Yubikey OTP
//
$yubikey_input_mode = 1;



// Address of your Yubikey validation server
//
// Leave empty to use public Yubico validation server
//
// This value should be in the format:
//    http[s]://host/page?
//
// For example:
//    $yubico_server_url = 'https://api.yubico.com/wsapi/verify?'
//
$yubico_server_url = '';



// Enable this to see validation requests and results
//
$yubico_debug = 0;



