<?php

/**
  * SquirrelMail Yubikey Plugin
  *
  * Copyright (c) 2011-2014 Paul Lesniewski <paul@squirrelmail.org>
  * Copyright (c) 2009 Richard Ferguson <yubikey@fergusnet.com>
  *
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage yubikey
  *
  */

/* add hooks into squirrelmail */
function squirrelmail_plugin_init_yubikey() 
{
   global $squirrelmail_plugin_hooks;
   $squirrelmail_plugin_hooks['optpage_loadhook_personal']['yubikey'] = 'yubikey_options';
   $squirrelmail_plugin_hooks['login_form']['yubikey'] = 'yubikey_form';
   $squirrelmail_plugin_hooks['login_before']['yubikey'] = 'yubikey_login';
   $squirrelmail_plugin_hooks['login_verified']['yubikey'] = 'yubikey_verify';
   $squirrelmail_plugin_hooks['loading_constants']['yubikey'] = 'yubikey_reorder_hooks';
}

/* return plugin information */
function yubikey_info()
{
   return array(
             'english_name' => 'Yubikey',
             'authors' => array(
                'Richard Ferguson' => array (
                   'email' => 'yubikey@fergusnet.com',
                ),
                'Paul Lesniewski' => array(
                   'email' => 'paul@squirrelmail.org',
                   'sm_site_username' => 'pdontthink',
                ),
             ),                
             'version' => '1.0',
             'required_sm_version' => '1.4.0',
             'per_version_requirements' => array('1.5.0' => SQ_INCOMPATIBLE),
             'required_php_version' => '5.0',
             'required_php_modules' => array('curl'),
             'required_php_functions' => array('array_search', 'urlencode', 
                                               'base64_encode', 'base64_decode', 
                                               'hash_hmac', 'parse_url'),
             'summary' => 'Provide One-Time-Password authentication with a Yubikey hardware token.',
             'details' => 'This plugin enables One-Time-Password authentication with a Yubikey hardware token.  This provides multi-factor authentication in form of something you know and something you have.', 
             'requires_configuration' => 1,
             'requires_source_patch' => 0,
             'external_project_uri' => 'http://code.google.com/p/yubico-squirrelmail-plugin/',
          );
}

/* return plugin version */
function yubikey_version()
{
   $info = yubikey_info();
   return $info['version'];
}

/* ensure Yubikey plugin comes *after* Password Forget plugin */
function yubikey_reorder_hooks() 
{
   include_once(SM_PATH . 'plugins/yubikey/functions.php');
   yubikey_reorder_hooks_do();
}

/* insert yubikey options into personal preferences page */
function yubikey_options() 
{
   include_once(SM_PATH . 'plugins/yubikey/functions.php');
   yubikey_options_do();
}

/* add yubikey input box */
function yubikey_form() 
{
   include_once(SM_PATH . 'plugins/yubikey/functions.php');
   yubikey_form_do();
}

/* process yubikey otp from login form */
function yubikey_login() 
{
   include_once(SM_PATH . 'plugins/yubikey/functions.php');
   yubikey_login_do();
}

/* verify yubikey otp */
function yubikey_verify() 
{
   include_once(SM_PATH . 'plugins/yubikey/functions.php');
   yubikey_verify_do();
}

// vim: ts=4: expandtab
