<?php
//
// $Id: wind.inc,v 1.1 2003/06/12 01:27:41 mysigp226 Exp $
//
// Copyright (C) 2003 Tyler Allison <tyler@allisonhouse.com>
//
// (see the files README and COPYING for more details)
//
//
// Wind functions for the wx200d
//
//

function wind_parse($array) {
//
// Take the array that was passed into the wind function
// and turn the values into human readable and return an array
// for use in the display section
//
// Uncomment the values you need for your display section. You
// could uncomment everything but why have your webserver 'parse'
// stuff your display section wont be using. It's here in case you need it.
//

global $degree_type; // pull in the type F or C
global $wind_type; // pull in the wind unit type. 0=mph, 1=knots, 2=m/s, 3=kph 

  $wind_speed = sprintf('%d',100 * LO($array[2]) + NUM($array[1]));
  // need to convert wind_speed=69 to 6.9 m/s
  $wind_speed = sprintf('%3d.%d',substr($wind_speed,0,-1),substr($wind_speed,-1,1));
  $wind_dir = sprintf('%03d',10 * NUM($array[3]) + HI($array[2]));
  $wind_comp = CONVCOMP($wind_dir);
  $avg_speed = sprintf('%d',100 * LO($array[5]) + NUM($array[4]));
  $avg_speed = sprintf('%3d.%d',substr($avg_speed,0,-1),substr($avg_speed,-1,1));
  $avg_dir = sprintf('%03d',10 * NUM($array[6]) + HI($array[5]));
  $avg_comp = CONVCOMP($avg_dir);
  $hi_val = sprintf('%d',100 * LO($array[8]) + NUM($array[7]));
  // need to convert hi_val=69 to 6.9 m/s
  $hi_val = sprintf('%3d.%d',substr($hi_val,0,-1),substr($hi_val,-1,1));
  $hi_dir = sprintf('%d',10 * NUM($array[9]) + HI($array[8]));
  $hi_comp = CONVCOMP($hi_dir);
  $hi_min = sprintf('%02d',NUM($array[10]));
  $hi_hour = sprintf('%02d',NUM($array[11]));
  $hi_day = sprintf('%2d',NUM($array[12]));
  $hi_mon = sprintf('%2d',LO($array[13]));
  //wind.a.hi
  //unused
  //unused
  // wind.format : 0=mph, 1=knots, 2=m/s, 3=kph
  $wind_format = sprintf('%d',($array[15] & 0xc0) >> 6);
  $wind_chill = sprintf('%3d.0',($array[21] & 0x20 ? -1 : 1) * NUM($array[16]));
  $chill_low = sprintf('%3d.0',($array[21] & 0x10 ? -1 : 1) * NUM($array[17]));
  $chill_low_min = sprintf('%02d',NUM($array[18]));
  $chill_low_hour = sprintf('%02d',NUM($array[19]));
  $chill_low_day = sprintf('%02d',NUM($array[20]));
  $chill_low_mon = sprintf('%2d',LO($array[21]));


// convert bearings into directionals
   $hi_bear = $hi_dir;
   $wind_bear = $wind_dir;
   $avg_bear = $avg_dir;

  if ($degree_type == "F") {
    $chill_low = CONVF($chill_low);
    $wind_chill = CONVF($wind_chill);
  }

// we are going to assume we get the speed in type 2 (m/s) if not just error.
// we could base our conversion on the wind_format context but too much work
// for now.
    if ($wind_format != '2') {
      echo "<b>Wind format from wx200d is not m/s so conversion is broken!! wind_format should be 2 but is actually $wind_format</b><br>";
    }

//
// Use the variables you uncommented above to build the array here.
// This should be self explanitory.
//
  $wind_array=array(
                        'WindSpeed'    => $wind_speed,
			'WindDir'	=> $wind_dir,
			'WindBear'	=> $wind_bear,
			'AvgSpeed'	=> $avg_speed,
			'AvgDir'	=> $avg_dir,
			'AvgBear'	=> $avg_bear,
			'WindHi'	=> $hi_val,
			'WindHiDir'	=> $hi_dir,
			'WindHiMin'	=> $hi_min,
			'WindHiHour'	=> $hi_hour,
			'WindHiDay'	=> $hi_day,
			'WindHiMon'	=> $hi_mon,
			'WindHiBear'	=> $hi_bear,

			'WindChill'	=> $wind_chill,
			'ChillLow'	=> $chill_low,
			'ChillLowMin'	=> $chill_low_min,
			'ChillLowHour'	=> $chill_low_hour,
			'ChillLowDay'	=> $chill_low_day,
			'ChillLowMon'	=> $chill_low_mon,

			'WindCompass' 	=> $wind_comp,
			'HighCompass'	=> $hi_comp,
			'AvgCompass'	=> $avg_comp,

                        );

    if ($wind_format == '2') {
        $wind_array['WindType']='m/s';
        //convert from m/s to mph
    } else {
        // do nothing until we support more conversions
        $wind_array['WindType']='m/s';
    }

  return ($wind_array);
}

function wx200_wind2($Speed) {
   // Convert from meters/sec to miles/hour = 1609.3 / 3600
  $rest = substr($Speed,-1);
  $start = substr($Speed,0,-1);
  $Speed = "$start.$rest";
  $Speed = sprintf('%3.1f', $Speed * 2.237);
  return $Speed;
}

function wx200_wind($array) {

   $wind_array = wind_parse($array);

   return($wind_array);
}
?>
