<?php
//
// Copyright (C) 2003 Tyler Allison <tyler@allisonhouse.com>
//
// (see the files README and COPYING for more details)
//
//
// Temperature functions for the wx200d
//
//

function temp_parse($array) {
//
// Take the array that was passed into the temp function
// and turn the values into human readable and return an array
// for use in the display section
//
// Uncomment the values you need for your display section. You
// could uncomment everything but why have your webserver 'parse'
// stuff your display section wont be using. It's here in case you need it.
//

global $degree_type; // pull in the type F or C

//  $clock_sec  = sprintf('%x',$array[1]);

  $temp_in = sprintf('%d',($array[2] & 0x08 ? -1 : 1) * (100 * ($array[2] & 0x07) + NUM($array[1])));
  $temp_in = sprintf('%3d.%d',substr($temp_in,0,-1),substr($temp_in,-1,1));

  $inhi_val = sprintf('%d',($array[3] & 0x80 ? -1 : 1) * (10 * NUM($array[3] & 0x7f) + HI($array[2])));
  $inhi_val = sprintf('%3d.%d',substr($inhi_val,0,-1),substr($inhi_val,-1,1));

  $inhi_min = sprintf('%02x',$array[4]);
  $inhi_hour = sprintf('%02x',$array[5]);
  $inhi_day = sprintf('%2x',$array[6]);
  $inhi_mon = sprintf('%2x',LO($array[7]));

  $inlo_val = sprintf('%d',($array[8] & 0x80 ? -1 : 1) * (10 * NUM($array[8] & 0x7f) + HI($array[7])));
  $inlo_val = sprintf('%3d.%d',substr($inlo_val,0,-1),substr($inlo_val,-1,1));

  $inlo_min = sprintf('%02x',$array[9]);
  $inlo_hour = sprintf('%02x',$array[10]);
  $inlo_day = sprintf('%2x',$array[11]);
  $inlo_mon = sprintf('%2x',LO($array[12]));

  // 13 alarm high
  // 14 alarm low
  // 15 format
  
  $temp_out = sprintf('%d',($array[17] & 0x08 ? -1 : 1) * (100 * ($array[17] & 0x07) + NUM($array[16])));
  $temp_out = sprintf('%3d.%d',substr($temp_out,0,-1),substr($temp_out,-1,1));

  $outhi_val = sprintf('%d',($array[18] & 0x80 ? -1 : 1) * (10 * NUM($array[18] & 0x7f) + HI($array[17])));
  $outhi_val = sprintf('%3d.%d',substr($outhi_val,0,-1),substr($outhi_val,-1,1));

  $outhi_min = sprintf('%02x',$array[19]);
  $outhi_hour = sprintf('%02x',$array[20]);
  $outhi_day = sprintf('%2x',$array[21]);
  $outhi_mon = sprintf('%2x',LO($array[22]));

  $outlo_val = sprintf('%d',($array[23] & 0x80 ? -1 : 1) * (10 * NUM($array[23] & 0x7f) + HI($array[22])));
  $outlo_val = sprintf('%3d.%d',substr($outlo_val,0,-1),substr($outlo_val,-1,1));

  $outlo_min = sprintf('%02x',$array[24]);
  $outlo_hour = sprintf('%02x',$array[25]);
  $outlo_day = sprintf('%2x',$array[26]);
  $outlo_mon = sprintf('%2x',$array[27]);

  // 28 alarm out high
  // 29 alarm out low

  if ($degree_type == "F") {
    $temp_out = CONVF($temp_out);
    $temp_in = CONVF($temp_in);
    $inhi_val = CONVF($inhi_val);
    $outhi_val = CONVF($outhi_val);
    $inlo_val = CONVF($inlo_val);
    $outlo_val = CONVF($outlo_val); 
  }

//
// Use the variables you uncommented above to build the array here.
// This should be self explanitory.
//
  $temp_array=array(
                        'TempIndoor'    => $temp_in,
                        'TempOutdoor'    => $temp_out,
                        'TempIndoorHi'    => $inhi_val,
                        'TempOutdoorHi'    => $outhi_val,
                        'TempIndoorLo'    => $inlo_val,
                        'TempOutdoorLo'    => $outlo_val,

                        'TempOutHiDay'    => $outhi_day,
                        'TempOutHiMon'    => $outhi_mon,
                        'TempOutHiHour'    => $outhi_hour,
                        'TempOutHiMin'    => $outhi_min,

                        'TempOutLoDay'    => $outlo_day,
                        'TempOutLoMon'    => $outlo_mon,
                        'TempOutLoHour'    => $outlo_hour,
                        'TempOutLoMin'    => $outlo_min,

                        'TempInHiDay'    => $inhi_day,
                        'TempInHiMon'    => $inhi_mon,
                        'TempInHiHour'    => $inhi_hour,
                        'TempInHiMin'    => $inhi_min,

                        'TempInLoDay'    => $inlo_day,
                        'TempInLoMon'    => $inlo_mon,
                        'TempInLoHour'    => $inlo_hour,
                        'TempInLoMin'    => $inlo_min,
                        );

  return ($temp_array);
}

function wx200_temp2($n1,$n2) {
  $temp = sprintf('%x%02x',0x07 & $n2,$n1);
  $rest = substr($temp,-1);
  $start = substr($temp,0,-1);
  $temp = "$start.$rest";
  return $temp;
}

function wx200_temp($array) {
  $TempIndoor = wx200_temp2($array[2],$array[1]);
  $TempIndoorF = ($TempIndoor*1.8) +32;
  $TempOutdoor = wx200_temp2($array[16],$array[17]); 
  $TempOutdoorF = ($TempOutdoor*1.8) +32;

  $temp_array = temp_parse($array);
  return $temp_array;

}

?>
