<?php
//
// $Id: rain.inc,v 1.1 2003/06/12 01:27:41 mysigp226 Exp $
//
// Copyright (C) 2003 Tyler Allison <tyler@allisonhouse.com>
//
// (see the files README and COPYING for more details)
//
//
// Rain functions for the wx200d
//
//

function rain_parse($array) {
//
// Take the array that was passed into the rain function
// and turn the values into human readable and return an array
// for use in the display section
//
// Uncomment the values you need for your display section. You
// could uncomment everything but why have your webserver 'parse'
// stuff your display section wont be using. It's here in case you need it.
//

global $rain_type; // pull in the wind unit type. 


  $rain_rate = sprintf('%2d',100 * LO($array[2]) + NUM($array[1]));
  $rain_yest = sprintf('%2d',100 * NUM($array[4]) + NUM($array[3]));
  $rain_total = sprintf('%2d',100 * NUM($array[6]) + NUM($array[5]));
  $total_min = sprintf('%02d',NUM($array[7]));
  $total_hour = sprintf('%02d',NUM($array[8]));
  $total_day = sprintf('%2d',NUM($array[9]));
  $total_mon = sprintf('%2d',LO($array[10]));
  $rain_format = sprintf('%d',BIT($array[10], 5));

// we are going to assume we get the rain rate in type 0 (mm/h) if not  error.
// we could base our conversion on the rain_format context but too much work
// for now.
    if ($rain_format != '0') {
      echo "<b>Rain format from wx200d is not mm so conversion is broken!! rain_format should be 0 but is actually $rain_format</b><br>";
    }

//
// Use the variables you uncommented above to build the array here.
// This should be self explanitory.
//
  $rain_array=array(
			'RainRate' 	=> $rain_rate,
			'RainYest'	=> $rain_yest,
			'RainTotal'	=> $rain_total,
			'TotalMin'	=> $total_min,
			'TotalHour'	=> $total_hour,
			'TotalDay'	=> $total_day,
			'TotalMon'	=> $total_mon,

                        );

    if ($rain_format == '0') {
        $rain_array['RainType']='mm/h';
        //convert from mm to in/h
    } else {
        // do nothing until we support more conversions
        $rain_array['RainType']='mm/h';
    }

  return ($rain_array);
}

function wx200_rain($array) {

  $temp_array = rain_parse($array);
  return($temp_array);

}
?>
