<?php
   /*
    *  Windows Plugin v.1.3
    *  By Shawn South <shawn@ratbert.org>
    *  (c) 2000 (GNU GPL - see ../../COPYING)
    *
    *  This plugin opens a fresh browser window when you click on a message,
    *  allowing you to easily read email with leaving the message list.  
    *  Note that because of the frames-based nature of squirrelmail, this may
    *  result in some minor side-effects (message list without a folder list, 
    *  message list not updating which messages have been read, etc.)  It might 
    *  seem a bit annoying at first, but I've found it grows on you quite 
    *  quickly.
    *  
    *  The ability to compose a message in a new window has been integrated into
    *  the 1.2.5 core and so has been removed from this plugin.  If you are running
    *  1.2.4, download the 1.0 ver for this functionality.  If you are running 
    *  pre-1.2.4, you've got bigger problems than controling when windows open 
    *  (namely security holes that can let a cracker own your box.)  Upgrade to at 
    *  least 1.2.4 (and hey, why not 1.2.5 in that case) immeadiately!
    *
    *  Configuration options to turn this on/off on a per-user basis can be 
    *  found under the 'Display' options page.
    *
    *  If you need help with this, or see improvements that can be made, please
    *  email me directly at the address above.  I definately welcome suggestions
    *  and comments.  This plugin, as is the case with all SquirrelMail plugins,
    *  is not directly supported by the developers.  Please come to me off the
    *  mailing list if you have trouble with it.
    *
    *  View the ../README.plugins document for information on installing this.  
    *
    */



function squirrelmail_plugin_init_windows() {
	global $squirrelmail_plugin_hooks;

	$squirrelmail_plugin_hooks['subject_link']['windows'] = 'windows_read';
        $squirrelmail_plugin_hooks['right_main_after_header']['windows'] = 'windows_close';
	$squirrelmail_plugin_hooks['options_display_inside']['windows'] = 'windows_options';
	$squirrelmail_plugin_hooks['options_display_save']['windows'] = 'windows_save_prefs';
}


function windows_read () {

  if (defined('SM_PATH'))
     include_once(SM_PATH . 'plugins/windows/functions.php');
  else
     include_once('../plugins/windows/functions.php');

  return windows_read_do();

}


function windows_close () {

  if (defined('SM_PATH'))
     include_once(SM_PATH . 'plugins/windows/functions.php');
  else
     include_once('../plugins/windows/functions.php');

  windows_close_do();

}


function windows_options () {

  if (defined('SM_PATH'))
     include_once(SM_PATH . 'plugins/windows/functions.php');
  else
     include_once('../plugins/windows/functions.php');

  windows_options_do();

}

function windows_save_prefs () {

  if (defined('SM_PATH'))
     include_once(SM_PATH . 'plugins/windows/functions.php');
  else
     include_once('../plugins/windows/functions.php');

  windows_save_prefs_do();

}


function windows_version () {

   return '1.3';

}


?>
