<?php
function squirrelmail_plugin_init_weather_uk() {
  global $squirrelmail_plugin_hooks;

  $squirrelmail_plugin_hooks['menuline']['weather_uk'] = 'weather_uk_link';
  $squirrelmail_plugin_hooks['options_display_inside']['weather_uk'] = 'weather_uk_options';
  $squirrelmail_plugin_hooks['options_display_save']['weather_uk'] = 'weather_uk_save';
  $squirrelmail_plugin_hooks['loading_prefs']['weather_uk'] = 'weather_uk_load';

}


function weather_uk_link() {

  global $color, $weather_uk_visible;

    if (! $weather_uk_visible) {
        return;
    }


displayInternalLink('plugins/weather_uk/weather-uk.php', 'Weather', '');

echo "&nbsp;&nbsp;\n";
}

function weather_uk_save() {
    global $username,$data_dir;
    global $weather_weather_uk_visible;

    if (isset($weather_weather_uk_visible)) {
        setPref($data_dir, $username, 'weather_uk_visible', '1');
    } else {
        setPref($data_dir, $username, 'weather_uk_visible', '');
    }
}


function weather_uk_load() {
    global $username, $data_dir;
    global $weather_uk_visible;

    $weather_uk_visible = getPref($data_dir, $username, 'weather_uk_visible');
}


function weather_uk_options() {
    global $weather_uk_visible;

    echo '<tr><td align=right nowrap>' . _("UK weather forecast:") . "</td>\n" .
         '<td><input name="weather_weather_uk_visible" type=CHECKBOX';
    if ($weather_uk_visible) {
        echo ' CHECKED';
    }
    echo '> ' . _("Show weather link in toolbar") . "</td></tr>\n";
}


?>