<?php

/*******************************************************************************

	Author  .......  Daniel B. Hemmerich
	Contact  ......  dan@spot.org
	Home Site  ....  http://www.spot.org/
	Program  ......  SquirrelMail Plugin - Weather
	Version  ......  4.0.2

*******************************************************************************/

chdir('..');
define('SM_PATH','../');



// include compatibility plugin
//
if (defined('SM_PATH'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('../plugins/compatibility/functions.php'))
   include_once('../plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
   include_once('./plugins/compatibility/functions.php');



if (compatibility_check_sm_version(1, 3))
{
   include_once (SM_PATH . 'include/validate.php');
   include_once (SM_PATH . 'functions/page_header.php');
   include_once (SM_PATH . 'include/load_prefs.php');
   include_once (SM_PATH . 'plugins/weather/config.php');
   include_once (SM_PATH . 'plugins/weather/weather.php');
}
else
{
   include_once ('../src/validate.php');
   include_once ('../functions/page_header.php');
   include_once ('../src/load_prefs.php');
   include_once ('../plugins/weather/config.php');
   include_once ('../plugins/weather/weather.php');
}



// get global variables for versions of PHP < 4.1
//
if ( !compatibility_check_php_version(4,1) ) {
   global $HTTP_POST_VARS, $HTTP_GET_VARS;
   $_POST = $HTTP_POST_VARS;
   $_GET = $HTTP_GET_VARS;
}



// get variables submitted from HTTP request
//
if (isset($_POST['weather_submit'])) $weather_submit = $_POST['weather_submit'];
if (isset($_POST['weather_code'])) $weather_code = $_POST['weather_code'];
if (isset($_POST['weather_place'])) $weather_place = $_POST['weather_place'];
if (isset($_POST['weather_position'])) $weather_position = $_POST['weather_position'];
if (isset($_POST['weather_view_place'])) $weather_view_place = $_POST['weather_view_place'];
if (isset($_POST['weather_view_temp'])) $weather_view_temp = $_POST['weather_view_temp'];
if (isset($_POST['weather_view_feels'])) $weather_view_feels = $_POST['weather_view_feels'];
if (isset($_POST['weather_view_conditions'])) $weather_view_conditions = $_POST['weather_view_conditions'];
if (isset($_POST['weather_view_uv'])) $weather_view_uv = $_POST['weather_view_uv'];
if (isset($_POST['weather_view_wind'])) $weather_view_wind = $_POST['weather_view_wind'];
if (isset($_POST['weather_view_dew'])) $weather_view_dew = $_POST['weather_view_dew'];
if (isset($_POST['weather_view_humidity'])) $weather_view_humidity = $_POST['weather_view_humidity'];
if (isset($_POST['weather_view_visibility'])) $weather_view_visibility = $_POST['weather_view_visibility'];
if (isset($_POST['weather_view_barometer'])) $weather_view_barometer = $_POST['weather_view_barometer'];
if (isset($_POST['weather_country'])) $weather_country = $_POST['weather_country'];
if (isset($_POST['weather_cachetime'])) $weather_cachetime = $_POST['weather_cachetime'] * 60;
if (isset($_POST['weather_viewable'])) $weather_viewable = $_POST['weather_viewable'];
if (isset($_POST['weather_width'])) $weather_width = $_POST['weather_width'];
if (isset($_POST['weather_margin_right'])) $weather_margin_right = $_POST['weather_margin_right'];
if (isset($_POST['weather_margin_left'])) $weather_margin_left = $_POST['weather_margin_left'];
if (isset($_POST['weather_margin_top'])) $weather_margin_top = $_POST['weather_margin_top'];
if (isset($_POST['weather_margin_bottom'])) $weather_margin_bottom = $_POST['weather_margin_bottom'];
if (isset($_POST['weather_color_background'])) $weather_color_background = $_POST['weather_color_background'];
if (isset($_POST['weather_color_foreground'])) $weather_color_foreground = $_POST['weather_color_foreground'];
if (isset($_POST['weather_color_label'])) $weather_color_label = $_POST['weather_color_label'];
if (isset($_POST['weather_color_value'])) $weather_color_value = $_POST['weather_color_value'];
if (isset($_POST['weather_url'])) $weather_url = $_POST['weather_url'];

if (isset($_POST['theid'])) 
	$theid = $_POST['theid'];
else if (isset($_GET['theid'])) 
	$theid = $_GET['theid'];

if (isset($_POST['action'])) 
	$action = $_POST['action'];
else if (isset($_GET['action'])) 
	$action = $_GET['action'];



$dontSaveLocation = 0;
$socketError = 0;
$weatherListHasChanged = 0;



if (isset ($weather_submit))
{

	if (!isset ($theid))
		$theid = 0;


	// older versions of PHP can't handle trim with 2nd parameter...
	//
	if ( !compatibility_check_php_version(4,1) ) 
	{
		$temp_code = trim($weather_code);
		if (strpos($temp_code, '"') === 0)
			$temp_code = substr($temp_code, 1);
		if (strpos($temp_code, '"') === strlen($temp_code) - 1)
			$temp_code = substr($temp_code, 0, strlen($temp_code) - 1);
		$weather_code = ucwords (strtolower($temp_code));
	}

	// newer php versions...
	//
	else
	{
		$weather_code = ucwords (strtolower ( trim($weather_code, '"')));
	}

	if (!isset ($weather_view_place))
		$weather_view_place = 0;

	if (!isset ($weather_view_temp))
		$weather_view_temp = 0;

	if (!isset ($weather_view_feels))
		$weather_view_feels = 0;

	if (!isset ($weather_view_conditions))
		$weather_view_conditions = 0;

	if (!isset ($weather_view_uv))
		$weather_view_uv = 0;

	if (!isset ($weather_view_wind))
		$weather_view_wind = 0;

	if (!isset ($weather_view_dew))
		$weather_view_dew = 0;

	if (!isset ($weather_view_humidity))
		$weather_view_humidity = 0;

	if (!isset ($weather_view_visibility))
		$weather_view_visibility = 0;

	if (!isset ($weather_view_barometer))
		$weather_view_barometer = 0;


                if (!empty($weather_country)) 
                {

                    $request = "GET /cgi-bin/cc_sel_cntry.pl?country=" . $weather_country;
                    $host = 'weather.noaa.gov'; 
                    $the_server = $host; 


                } 
                else 
                {

		    $request  = "GET http://www.srh.noaa.gov/zipcity.php?inputstring=" . urlencode($weather_code);
                    $host = 'www.srh.noaa.gov';
                    $the_server = $host;

                }

                $request .= " HTTP/1.0\r\n";

		$request .= "Host: $host\r\n";
		$request .= "Accept: */*\r\n";
		$request .= "Connection: close\r\n";
		$request .= "\r\n\r\n";

		$httpsock = @fsockopen ($the_server, 80);

		if ($httpsock)
		{
			fwrite ($httpsock, $request);
			$data = "";

			while (!feof($httpsock))
			{
				$data .= fread ($httpsock, 1024);
			}
			fclose($httpsock);
			$explode = explode('Location: ',$data);
		}
		else
		{
			$socketError = 1;
		}
		

		// check if the expected data is there - otherwise, no
		// weather info was available for this location
		//
		if (!$socketError && !isset($explode[1]))
		{
			$dontSaveLocation = 1;
		}
		elseif (!$socketError) 
		{

			$explode = explode("\n",$explode[1]);
			$data = $explode[0];
                	preg_match("/http:\/\/.*?\/(.*)/", $data, $matches);
                	$data = '/' . trim($matches[1]);

			$request  = "GET " . $data . " HTTP/1.0\r\n";
	
			$request .= "Host: $host\r\n";
			$request .= "Accept: */*\r\n";
			$request .= "Connection: close\r\n";
			$request .= "\r\n\r\n";

		
			$httpsock = @fsockopen ($the_server, 80);
	

                	if ($httpsock)
                	{
				fwrite ($httpsock, $request);
				$data = "";

				while (!feof($httpsock))
				{
					$data .= fread ($httpsock, 1024);
				}
    				fclose($httpsock);
			}
			else
			{
				$socketError = 1;
			}



			// catch 302 redirects
			//
			if (!$socketError && strpos($data, 'Location: ') !== FALSE)
			{

				$explode = explode('Location: ',$data);
				$explode = explode('Via:',$explode[1]);
				$data = $explode[0];
				preg_match("/http:\/\/(.*?)\/(.*)/",$data,$matches);
				$host = $matches[1];
				$the_server = $host;
				$data = '/' . $matches[2];
				$request  = "GET " . $data . " HTTP/1.0\r\n";
				$request .= "Host: $host\r\n";
				$request .= "Accept: */*\r\n";
				$request .= "Connection: close\r\n";
				$request .= "\r\n\r\n";

				if ($httpsock = fsockopen ($the_server, 80)) {

					fwrite ($httpsock, $request);
					$data = "";

					while (!feof($httpsock))
					{
						$data .= fread ($httpsock, 1024);
					}
					fclose($httpsock);
				}
				else
				{
					$socketError = 1;
				}

			}


        		// US locations
        		//
        		if (!$socketError && empty($weather_country)) 
        		{

	    			$explode = explode('<td background="/weather/images/fcicons/forecast_blank.jpg" height="57" class="white1">',$data,2);
	    			$explode = explode('<',$explode[1],2);
	    			$weather_place = trim($explode[0]);
            			$weather_url = '';


        		// international locations
        		//
        		} elseif (!$socketError) {


            			// parse out city info...
            			//
            			preg_match("/OPTION VALUE=\"(.*)\">.*$weather_code\b/i", $data, $matches);


	    			// check if the expected data is there - otherwise, no
	    			// weather info was available for this location
	    			//
	    			if (!isset($matches[1]))
	    			{
					$dontSaveLocation = 1;
	    			}
				else
				{


            				$city_code = $matches[1];
            				$request = "GET /cgi-bin/call_currwx.pl?cccc=$city_code";
			
            				$request .= " HTTP/1.0\r\n";
	
            				$request .= "Host: $host\r\n";
            				$request .= "Accept: */*\r\n";
            				$request .= "Connection: close\r\n";
            				$request .= "\r\n\r\n";
	
			
            				$httpsock = @fsockopen ($the_server, 80);
	
					if ($httpsock)
					{

	            				fwrite ($httpsock, $request);
		            			$data = "";
	
           					while (!feof($httpsock))
            					{
                					$data .= fread ($httpsock, 1024);
            					}
            					fclose($httpsock);

					}
					else
					{
						$socketError = 1;
					}
	
			
					if (!$socketError) 
					{

	            				$explode = explode('Location: ',$data);
            					$explode = explode("\n",$explode[1]);
            					$data = $explode[0];
            					preg_match("/http:\/\/.*?\/(.*)/", $data, $matches);
            					$data = '/' . trim($matches[1]);
	
            					$request  = "GET " . $data . " HTTP/1.0\r\n";
	
            					$request .= "Host: $host\r\n";
            					$request .= "Accept: */*\r\n";
            					$request .= "Connection: close\r\n";
            					$request .= "\r\n\r\n";
           	 
	
            					$weather_url = 'http://' . $host . $data;
	
			
            					$httpsock = @fsockopen ($the_server, 80);
	
						if ($httpsock)
						{

	            					fwrite ($httpsock, $request);
            						$data = "";
	
            						while (!feof($httpsock))
            						{
                						$data .= fread ($httpsock, 1024);
            						}
            						fclose($httpsock);

						}
						else
						{
							$socketError = 1;
						}
	
						if (!$socketError)
						{
	    						$explode = explode('Current Weather Conditions:<BR>', $data, 2);
	    						$explode = explode('</B></FONT>', $explode[1], 2);
	    						$weather_place = trim($explode[0]);

						}
					}
				}
        		}
		}


    		if ($dontSaveLocation || $socketError)
    		{
			// do nothing
    		}
		else
		{


			setPref ($data_dir, $username, "weather".$theid,
			$weather_code."\\".
			$weather_place."\\".
			$weather_position."\\".
			$weather_view_temp."\\".
			$weather_view_feels."\\".
			$weather_view_conditions."\\".
			$weather_view_uv."\\".
			$weather_view_wind."\\".
			$weather_view_dew."\\".
			$weather_view_humidity."\\".
			$weather_view_visibility."\\".
			$weather_view_barometer."\\".
			"0\\\\\\\\\\\\\\\\\\\\\\".
			$weather_cachetime."\\".
			$weather_viewable."\\".
			$weather_width."\\".
			$weather_margin_right."\\".
			$weather_margin_left."\\".
			$weather_margin_top."\\".
			$weather_margin_bottom."\\".
			$weather_color_background."\\".
			$weather_color_foreground."\\".
			$weather_color_label."\\".
			$weather_color_value."\\".
			$weather_view_place."\\".
			$weather_url."\\".
                	$weather_country);

		$locations[$theid]['code'] = $weather_code;
		$locations[$theid]['url'] = $weather_url;
		$locations[$theid]['country'] = $weather_country;
		$locations[$theid]['place'] = $weather_place;
		$locations[$theid]['position'] = $weather_position;
		$locations[$theid]['view-temp'] = $weather_view_temp;
		$locations[$theid]['view-feels'] = $weather_view_feels;
		$locations[$theid]['view-conditions'] = $weather_view_conditions;
		$locations[$theid]['view-uv'] = $weather_view_uv;
		$locations[$theid]['view-wind'] = $weather_view_wind;
		$locations[$theid]['view-dew'] = $weather_view_dew;
		$locations[$theid]['view-humidity'] = $weather_view_humidity;
		$locations[$theid]['view-visibility'] = $weather_view_visibility;
		$locations[$theid]['view-barometer'] = $weather_view_barometer;
		$locations[$theid]['view-place'] = $weather_view_place;

		$weatherListHasChanged = 1;

	}

}
elseif (isset ($action) && $action == 'delete')
{
	remove_location ($theid);
	$weatherListHasChanged = 1;
}
elseif (isset ($action) && ($action == 'visible' || $action == 'hidden'))
{
	$locations = load_locations ();

	if ($action == 'visible')
	{
		$locations[$theid]['viewable'] = 1;
	}
	else
	{
		$locations[$theid]['viewable'] = 0;
	}

	setPref ($data_dir, $username, "weather".$theid,
                $locations[$theid]['code']."\\".
                $locations[$theid]['place']."\\".
                $locations[$theid]['position']."\\".
                $locations[$theid]['view-temp']."\\".
                $locations[$theid]['view-feels']."\\".
                $locations[$theid]['view-conditions']."\\".
                $locations[$theid]['view-uv']."\\".
                $locations[$theid]['view-wind']."\\".
                $locations[$theid]['view-dew']."\\".
                $locations[$theid]['view-humidity']."\\".
                $locations[$theid]['view-visibility']."\\".
                $locations[$theid]['view-barometer']."\\".

		"0\\\\\\\\\\\\\\\\\\\\\\".
                $locations[$theid]['cachetime']."\\".

                $locations[$theid]['viewable']."\\".
                $locations[$theid]['width']."\\".
                $locations[$theid]['margin-right']."\\".
                $locations[$theid]['margin-left']."\\".
                $locations[$theid]['margin-top']."\\".
                $locations[$theid]['margin-bottom']."\\".
                $locations[$theid]['color-background']."\\".
                $locations[$theid]['color-foreground']."\\".
                $locations[$theid]['color-label']."\\".
                $locations[$theid]['color-value']."\\".

                $locations[$theid]['view-place']."\\".
                $locations[$theid]['url']."\\".
                $locations[$theid]['country']);

		$weatherListHasChanged = 1;

}

$locations = load_locations ();
$emptyLocationNumber = -1;

displayPageHeader($color, 'None');

echo	'<br>' .
	'<table width=95% align=center border=0 cellpadding=2 cellspacing=0>'.
	"<tr><td bgcolor=\"$color[0]\">".
	'<center><b>' . _("Options") . ' -  ' . _("Weather") . '</b></center>'.
	"<table WIDTH=\"100%\" BORDER=\"0\" CELLPADDING=\"5\" CELLSPACING=\"0\" BGCOLOR=\"" . $color[4] . "\">";
if ($dontSaveLocation)
{
	echo '<tr><td colspan=2 align="center"><br><b>' . _("Sorry, no weather information available for ") . $weather_code . '</b></td></tr>';
// could put link "for more info" to http://weather.noaa.gov/index.html
}
elseif ($socketError)
{
	echo '<tr><td colspan=2 align="center"><br><b>' . _("Sorry, there was a problem connecting to the weather server.") . '</b></td></tr>';
}
elseif ($weatherListHasChanged)
{
	echo '<tr><td colspan=2 align="center"><br><b>' . _("Weather Options Successfully Updated") . '</b><br><br><a href="../../src/left_main.php" target="left">' . _("Refresh Folder List") . '</a></td></tr>';
}

echo
	"<TR><td ALIGN=\"CENTER\">".
	'<br><center>[<a href="options.php?action=add">' . _("New") .
	'</a>] - [<a href="../../src/options.php">' . _("Done") . '</a>]</center><br>'.
	'</TD></TR></TABLE>';

if (isset ($action) && ($action == 'add' || $action == 'edit'))
{
	if ( !isset($theid) )
	{
		$theid = count ($locations);
	}


	// check if this is a new location
	//
	if (sizeof($locations) <= $theid)
	{
		$emptyLocationNumber = $theid;
		$locations[$theid] = array();
	}



echo    "<table WIDTH=\"100%\" BORDER=\"0\" CELLPADDING=\"5\" CELLSPACING=\"0\" BGCOLOR=\"" . $color[4] . "\"><TR><td ALIGN=\"LEFT\" style=\"padding-left: 10px; padding-bottom: 10px;\">".
        _("For the location, you may either enter a USA zip code (prefered for large cities with more than one ZIP code), or a city and state name.  For international locations, enter only a city name and make sure to select the correct country from the pull-down list.  For example you could use either: \"60622\" or \"Chicago, IL\" for US locations, or \"Paris\" (while selecting France from the pull-down) for a non-US location.") .
        '</TD></TR></TABLE>';


	echo	"<table cellpadding=2 cellspacing=0 border=0 WIDTH=\"100%\" BGCOLOR=\"" . $color[4] . "\">".
		'<tr>'.
		'<td align=left width="20%" style="padding-left: 20px;"><form action="options.php" method=post>'.
		_("Location:").
		'</td>'.
		'<td width="6%">&nbsp;</td><td align=left width="74%">'.
		'<input type=text size=32 maxlen=32 name=weather_code value="';

	if (isset ($locations[$theid]['code']))
	{
		echo $locations[$theid]["code"];
	}

	echo	'">'.
		'</td>'.
		'</tr>'.

		'<tr>'.
		'<td align=left width="20%" style="padding-left: 20px;">'.
		_("Country:").
		'</td>'.
		'<td width="6%">&nbsp;</td><td align=left width="74%">';

        echo    '<SELECT NAME="weather_country" ONCHANGE="internationalpage();"> 
						  <OPTION VALUE=""> United States</OPTION> 
						  <OPTION VALUE="AL"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'AL') echo ' SELECTED';
echo '> Albania</OPTION> 
						  <OPTION VALUE="DZ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'DZ') echo ' SELECTED';
echo '> Algeria</OPTION> 
						  <OPTION VALUE="AO"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'AO') echo ' SELECTED';
echo '> Angola</OPTION> 
						  <OPTION VALUE="AQ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'AQ') echo ' SELECTED';
echo '> Antarctic</OPTION> 
						  <OPTION VALUE="AG"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'AG') echo ' SELECTED';
echo '> Antigua and Barbuda</OPTION> 
						  <OPTION VALUE="AR"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'AR') echo ' SELECTED';
echo '> Argentina</OPTION> 
						  <OPTION VALUE="AM"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'AM') echo ' SELECTED';
echo '> Armenia</OPTION> 
						  <OPTION VALUE="AW"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'AW') echo ' SELECTED';
echo '> Aruba</OPTION> 
						  <OPTION VALUE="AU"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'AU') echo ' SELECTED';
echo '> Australia</OPTION> 
						  <OPTION VALUE="AT"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'AT') echo ' SELECTED';
echo '> Austria</OPTION> 
						  <OPTION VALUE="AZ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'AZ') echo ' SELECTED';
echo '> Azerbaijan</OPTION> 
						  <OPTION VALUE="BS"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BS') echo ' SELECTED';
echo '> Bahamas</OPTION> 
						  <OPTION VALUE="BH"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BH') echo ' SELECTED';
echo '> Bahrain</OPTION> 
						  <OPTION VALUE="BD"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BD') echo ' SELECTED';
echo '> Bangladesh</OPTION> 
						  <OPTION VALUE="BB"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BB') echo ' SELECTED';
echo '> Barbados</OPTION> 
						  <OPTION VALUE="BY"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BY') echo ' SELECTED';
echo '> Belarus</OPTION> 
						  <OPTION VALUE="BE"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BE') echo ' SELECTED';
echo '> Belgium</OPTION> 
						  <OPTION VALUE="BZ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BZ') echo ' SELECTED';
echo '> Belize</OPTION> 
						  <OPTION VALUE="BJ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BJ') echo ' SELECTED';
echo '> Benin</OPTION> 
						  <OPTION VALUE="BM"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BM') echo ' SELECTED';
echo '> Bermuda</OPTION> 
						  <OPTION VALUE="BO"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BO') echo ' SELECTED';
echo '> Bolivia</OPTION> 
						  <OPTION VALUE="BW"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BW') echo ' SELECTED';
echo '> Botswana</OPTION> 
						  <OPTION VALUE="BR"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BR') echo ' SELECTED';
echo '> Brazil</OPTION> 
						  <OPTION VALUE="IO"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'IO') echo ' SELECTED';
echo '> British Indian Ocean Territory</OPTION>
						  <OPTION VALUE="BN"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BN') echo ' SELECTED';
echo '> Brunei Darussalam</OPTION> 
						  <OPTION VALUE="BG"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BG') echo ' SELECTED';
echo '> Bulgaria</OPTION> 
						  <OPTION VALUE="BI"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'BI') echo ' SELECTED';
echo '> Burundi</OPTION> 
						  <OPTION VALUE="KH"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'KH') echo ' SELECTED';
echo '> Cambodia</OPTION> 
						  <OPTION VALUE="CM"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CM') echo ' SELECTED';
echo '> Cameroon</OPTION> 
						  <OPTION VALUE="CA"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CA') echo ' SELECTED';
echo '> Canada</OPTION> 
						  <OPTION VALUE="CV"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CV') echo ' SELECTED';
echo '> Cape Verde</OPTION> 
						  <OPTION VALUE="KY"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'KY') echo ' SELECTED';
echo '> Cayman Islands</OPTION> 
						  <OPTION VALUE="CF"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CF') echo ' SELECTED';
echo '> Central African Republic</OPTION> 
						  <OPTION VALUE="TD"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'TD') echo ' SELECTED';
echo '> Chad</OPTION> 
						  <OPTION VALUE="CL"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CL') echo ' SELECTED';
echo '> Chile</OPTION> 
						  <OPTION VALUE="CN"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CN') echo ' SELECTED';
echo '> China</OPTION> 
						  <OPTION VALUE="CX"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CX') echo ' SELECTED';
echo '> Christmas Island</OPTION> 
						  <OPTION VALUE="CO"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CO') echo ' SELECTED';
echo '> Colombia</OPTION> 
						  <OPTION VALUE="KM"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'KM') echo ' SELECTED';
echo '> Comoros</OPTION> 
						  <OPTION VALUE="CG"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CG') echo ' SELECTED';
echo '> Congo</OPTION> 
						  <OPTION VALUE="CK"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CK') echo ' SELECTED';
echo '> Cook Islands</OPTION> 
						  <OPTION VALUE="CR"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CR') echo ' SELECTED';
echo '> Costa Rica</OPTION> 
						  <OPTION VALUE="CI"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CI') echo ' SELECTED';
echo '> Cote D\'Ivoire</OPTION> 
						  <OPTION VALUE="HR"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'HR') echo ' SELECTED';
echo '> Croatia</OPTION> 
						  <OPTION VALUE="CU"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CU') echo ' SELECTED';
echo '> Cuba</OPTION> 
						  <OPTION VALUE="CY"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CY') echo ' SELECTED';
echo '> Cyprus</OPTION> 
						  <OPTION VALUE="CZ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CZ') echo ' SELECTED';
echo '> Czech Republic</OPTION> 
						  <OPTION VALUE="DK"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'DK') echo ' SELECTED';
echo '> Denmark</OPTION> 
						  <OPTION VALUE="DJ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'DJ') echo ' SELECTED';
echo '> Djibouti</OPTION> 
						  <OPTION VALUE="DM"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'DM') echo ' SELECTED';
echo '> Dominica</OPTION> 
						  <OPTION VALUE="DO"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'DO') echo ' SELECTED';
echo '> Dominican Republic</OPTION> 
						  <OPTION VALUE="EC"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'EC') echo ' SELECTED';
echo '> Ecuador</OPTION> 
						  <OPTION VALUE="EG"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'EG') echo ' SELECTED';
echo '> Egypt</OPTION> 
						  <OPTION VALUE="SV"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SV') echo ' SELECTED';
echo '> El Salvador</OPTION> 
						  <OPTION VALUE="ET"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'ET') echo ' SELECTED';
echo '> Ethiopia</OPTION> 
						  <OPTION VALUE="FJ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'FJ') echo ' SELECTED';
echo '> Fiji</OPTION> 
						  <OPTION VALUE="FI"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'FI') echo ' SELECTED';
echo '> Finland</OPTION> 
						  <OPTION VALUE="FR"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'FR') echo ' SELECTED';
echo '> France</OPTION> 
						  <OPTION VALUE="GF"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GF') echo ' SELECTED';
echo '> French Guiana</OPTION> 
						  <OPTION VALUE="PF"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'PF') echo ' SELECTED';
echo '> French Polynesia</OPTION> 
						  <OPTION VALUE="GA"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GA') echo ' SELECTED';
echo '> Gabon</OPTION> 
						  <OPTION VALUE="GM"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GM') echo ' SELECTED';
echo '> Gambia</OPTION> 
						  <OPTION VALUE="GE"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GE') echo ' SELECTED';
echo '> Georgia</OPTION> 
						  <OPTION VALUE="DE"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'DE') echo ' SELECTED';
echo '> Germany</OPTION> 
						  <OPTION VALUE="GH"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GH') echo ' SELECTED';
echo '> Ghana</OPTION> 
						  <OPTION VALUE="GI"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GI') echo ' SELECTED';
echo '> Gibraltar</OPTION> 
						  <OPTION VALUE="GR"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GR') echo ' SELECTED';
echo '> Greece</OPTION> 
						  <OPTION VALUE="GL"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GL') echo ' SELECTED';
echo '> Greenland</OPTION> 
						  <OPTION VALUE="GD"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GD') echo ' SELECTED';
echo '> Grenada</OPTION> 
						  <OPTION VALUE="GP"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GP') echo ' SELECTED';
echo '> Guadeloupe</OPTION> 
						  <OPTION VALUE="GT"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GT') echo ' SELECTED';
echo '> Guatemala</OPTION> 
						  <OPTION VALUE="GN"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GN') echo ' SELECTED';
echo '> Guinea</OPTION> 
						  <OPTION VALUE="GW"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GW') echo ' SELECTED';
echo '> Guinea-Bissau</OPTION> 
						  <OPTION VALUE="GY"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GY') echo ' SELECTED';
echo '> Guyana</OPTION> 
						  <OPTION VALUE="HT"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'HT') echo ' SELECTED';
echo '> Haiti</OPTION> 
						  <OPTION VALUE="HN"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'HN') echo ' SELECTED';
echo '> Honduras</OPTION> 
						  <OPTION VALUE="HK"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'HK') echo ' SELECTED';
echo '> Hong Kong</OPTION> 
						  <OPTION VALUE="HU"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'HU') echo ' SELECTED';
echo '> Hungary</OPTION> 
						  <OPTION VALUE="IS"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'IS') echo ' SELECTED';
echo '> Iceland</OPTION> 
						  <OPTION VALUE="IN"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'IN') echo ' SELECTED';
echo '> India</OPTION> 
						  <OPTION VALUE="ID"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'ID') echo ' SELECTED';
echo '> Indonesia</OPTION> 
						  <OPTION VALUE="IR"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'IR') echo ' SELECTED';
echo '> Iran, Islamic Republic of</OPTION> 
						  <OPTION VALUE="IE"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'IE') echo ' SELECTED';
echo '> Ireland</OPTION> 
						  <OPTION VALUE="IL"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'IL') echo ' SELECTED';
echo '> Israel</OPTION> 
						  <OPTION VALUE="IT"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'IT') echo ' SELECTED';
echo '> Italy</OPTION> 
						  <OPTION VALUE="JM"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'JM') echo ' SELECTED';
echo '> Jamaica</OPTION> 
						  <OPTION VALUE="JP"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'JP') echo ' SELECTED';
echo '> Japan</OPTION> 
						  <OPTION VALUE="JO"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'JO') echo ' SELECTED';
echo '> Jordan</OPTION> 
				'; /*		  <OPTION VALUE=""'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == '') echo ' SELECTED';
echo '> Kazakhstan</OPTION>   */   echo '
						  <OPTION VALUE="KE"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'KE') echo ' SELECTED';
echo '> Kenya</OPTION> 
						  <OPTION VALUE="KI"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'KI') echo ' SELECTED';
echo '> Kiribati</OPTION> 
						  <OPTION VALUE="KP"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'KP') echo ' SELECTED';
echo '> Korea, Democratic People\'s Republic of</OPTION> 
						  <OPTION VALUE="KR"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'KR') echo ' SELECTED';
echo '> Korea, Republic of</OPTION> 
						  <OPTION VALUE="KW"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'KW') echo ' SELECTED';
echo '> Kuwait</OPTION> 
						  <OPTION VALUE="LA"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'LA') echo ' SELECTED';
echo '> Lao People\'s Democratic Republic</OPTION> 
						  <OPTION VALUE="LB"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'LB') echo ' SELECTED';
echo '> Lebanon</OPTION> 
						  <OPTION VALUE="LY"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'LY') echo ' SELECTED';
echo '> Libyan Arab Jamahiriya</OPTION> 
						  <OPTION VALUE="LT"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'LT') echo ' SELECTED';
echo '> Lithuania</OPTION> 
						  <OPTION VALUE="LU"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'LU') echo ' SELECTED';
echo '> Luxembourg</OPTION> 
						  <OPTION VALUE="MO"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'MO') echo ' SELECTED';
echo '> Macau</OPTION> 
				';  /*		  <OPTION VALUE=""'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == '') echo ' SELECTED';
echo '> Macedonia, the Former Yugoslav Republic of</OPTION>    */ echo '
						  <OPTION VALUE="MG"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'MG') echo ' SELECTED';
echo '> Madagascar</OPTION> 
						  <OPTION VALUE="MW"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'MW') echo ' SELECTED';
echo '> Malawi</OPTION> 
						  <OPTION VALUE="MY"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'MY') echo ' SELECTED';
echo '> Malaysia</OPTION> 
						  <OPTION VALUE="MV"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'MV') echo ' SELECTED';
echo '> Maldives</OPTION> 
						  <OPTION VALUE="ML"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'ML') echo ' SELECTED';
echo '> Mali</OPTION> 
						  <OPTION VALUE="MT"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'MT') echo ' SELECTED';
echo '> Malta</OPTION> 
						  <OPTION VALUE="MH"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'MH') echo ' SELECTED';
echo '> Marshall Islands</OPTION> 
						  <OPTION VALUE="MQ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'MQ') echo ' SELECTED';
echo '> Martinique</OPTION> 
						  <OPTION VALUE="MR"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'MR') echo ' SELECTED';
echo '> Mauritania</OPTION> 
						  <OPTION VALUE="MU"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'MU') echo ' SELECTED';
echo '> Mauritius</OPTION> 
						  <OPTION VALUE="MX"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'MX') echo ' SELECTED';
echo '> Mexico</OPTION> 
						  <OPTION VALUE="FM"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'FM') echo ' SELECTED';
echo '> Micronesia, Federated States of</OPTION> 
						  <OPTION VALUE="MA"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'MA') echo ' SELECTED';
echo '> Morocco</OPTION> 
						  <OPTION VALUE="MZ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'MZ') echo ' SELECTED';
echo '> Mozambique</OPTION> 
						  <OPTION VALUE="MM"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'MM') echo ' SELECTED';
echo '> Myanmar</OPTION> 
						  <OPTION VALUE="NR"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'NR') echo ' SELECTED';
echo '> Nauru</OPTION> 
						  <OPTION VALUE="NP"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'NP') echo ' SELECTED';
echo '> Nepal</OPTION> 
						  <OPTION VALUE="NL"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'NL') echo ' SELECTED';
echo '> Netherlands</OPTION> 
						  <OPTION VALUE="AN"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'AN') echo ' SELECTED';
echo '> Netherlands Antilles</OPTION> 
						  <OPTION VALUE="NC"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'NC') echo ' SELECTED';
echo '> New Caledonia</OPTION> 
						  <OPTION VALUE="NZ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'NZ') echo ' SELECTED';
echo '> New Zealand</OPTION> 
						  <OPTION VALUE="NI"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'NI') echo ' SELECTED';
echo '> Nicaragua</OPTION> 
						  <OPTION VALUE="NE"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'NE') echo ' SELECTED';
echo '> Niger</OPTION> 
						  <OPTION VALUE="NO"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'NO') echo ' SELECTED';
echo '> Norway</OPTION> 
						  <OPTION VALUE="OM"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'OM') echo ' SELECTED';
echo '> Oman</OPTION> 
						  <OPTION VALUE="PK"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'PK') echo ' SELECTED';
echo '> Pakistan</OPTION> 
						  <OPTION VALUE="PW"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'PW') echo ' SELECTED';
echo '> Palau</OPTION> 
						  <OPTION VALUE="PA"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'PA') echo ' SELECTED';
echo '> Panama</OPTION> 
						  <OPTION VALUE="PY"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'PY') echo ' SELECTED';
echo '> Paraguay</OPTION> 
						  <OPTION VALUE="PE"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'PE') echo ' SELECTED';
echo '> Peru</OPTION> 
						  <OPTION VALUE="PH"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'PH') echo ' SELECTED';
echo '> Philippines</OPTION> 
						  <OPTION VALUE="PL"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'PL') echo ' SELECTED';
echo '> Poland</OPTION> 
						  <OPTION VALUE="PT"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'PT') echo ' SELECTED';
echo '> Portugal</OPTION> 
						  <OPTION VALUE="PR"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'PR') echo ' SELECTED';
echo '> Puerto Rico</OPTION> 
						  <OPTION VALUE="QA"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'QA') echo ' SELECTED';
echo '> Qatar</OPTION> 
						  <OPTION VALUE="RE"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'RE') echo ' SELECTED';
echo '> Reunion</OPTION> 
						  <OPTION VALUE="RO"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'RO') echo ' SELECTED';
echo '> Romania</OPTION> 
						  <OPTION VALUE="RU"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'RU') echo ' SELECTED';
echo '> Russian Federation</OPTION> 
						  <OPTION VALUE="RW"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'RW') echo ' SELECTED';
echo '> Rwanda</OPTION> 
						  <OPTION VALUE="SH"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SH') echo ' SELECTED';
echo '> Saint Helena</OPTION> 
						  <OPTION VALUE="KN"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'KN') echo ' SELECTED';
echo '> Saint Kitts and Nevis</OPTION> 
						  <OPTION VALUE="LC"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'LC') echo ' SELECTED';
echo '> Saint Lucia</OPTION> 
						  <OPTION VALUE="VC"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'VC') echo ' SELECTED';
echo '> Saint Vincent and the Grenadines</OPTION> 
						  <OPTION VALUE="WS"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'WS') echo ' SELECTED';
echo '> Samoa</OPTION> 
						  <OPTION VALUE="ST"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'ST') echo ' SELECTED';
echo '> Sao Tome and Principe</OPTION> 
						  <OPTION VALUE="SA"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SA') echo ' SELECTED';
echo '> Saudi Arabia</OPTION> 
						  <OPTION VALUE="SN"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SN') echo ' SELECTED';
echo '> Senegal</OPTION> 
						  <OPTION VALUE="SC"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SC') echo ' SELECTED';
echo '> Seychelles</OPTION> 
						  <OPTION VALUE="SL"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SL') echo ' SELECTED';
echo '> Sierra Leone</OPTION> 
						  <OPTION VALUE="SG"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SG') echo ' SELECTED';
echo '> Singapore</OPTION> 
						  <OPTION VALUE="SK"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SK') echo ' SELECTED';
echo '> Slovakia</OPTION> 
						  <OPTION VALUE="SI"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SI') echo ' SELECTED';
echo '> Slovenia</OPTION> 
						  <OPTION VALUE="SB"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SB') echo ' SELECTED';
echo '> Solomon Islands</OPTION> 
						  <OPTION VALUE="SO"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SO') echo ' SELECTED';
echo '> Somalia</OPTION> 
						  <OPTION VALUE="ZA"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'ZA') echo ' SELECTED';
echo '> South Africa</OPTION> 
						  <OPTION VALUE="ES"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'ES') echo ' SELECTED';
echo '> Spain</OPTION> 
						  <OPTION VALUE="LK"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'LK') echo ' SELECTED';
echo '> Sri Lanka</OPTION> 
						  <OPTION VALUE="SD"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SD') echo ' SELECTED';
echo '> Sudan</OPTION> 
						  <OPTION VALUE="SR"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SR') echo ' SELECTED';
echo '> Suriname</OPTION> 
						  <OPTION VALUE="SZ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SZ') echo ' SELECTED';
echo '> Swaziland</OPTION> 
						  <OPTION VALUE="SE"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SE') echo ' SELECTED';
echo '> Sweden</OPTION> 
						  <OPTION VALUE="CH"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'CH') echo ' SELECTED';
echo '> Switzerland</OPTION> 
						  <OPTION VALUE="SY"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'SY') echo ' SELECTED';
echo '> Syrian Arab Republic</OPTION> 
						  <OPTION VALUE="TW"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'TW') echo ' SELECTED';
echo '> Taiwan</OPTION> 
						  <OPTION VALUE="TJ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'TJ') echo ' SELECTED';
echo '> Tajikistan</OPTION> 
						  <OPTION VALUE="TZ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'TZ') echo ' SELECTED';
echo '> Tanzania, United Republic of</OPTION> 
						  <OPTION VALUE="TH"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'TH') echo ' SELECTED';
echo '> Thailand</OPTION> 
						  <OPTION VALUE="TG"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'TG') echo ' SELECTED';
echo '> Togo</OPTION> 
						  <OPTION VALUE="TO"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'TO') echo ' SELECTED';
echo '> Tonga</OPTION> 
						  <OPTION VALUE="TT"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'TT') echo ' SELECTED';
echo '> Trinidad and Tobago</OPTION> 
						  <OPTION VALUE="TN"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'TN') echo ' SELECTED';
echo '> Tunisia</OPTION> 
						  <OPTION VALUE="TR"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'TR') echo ' SELECTED';
echo '> Turkey</OPTION> 
						  <OPTION VALUE="TV"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'TV') echo ' SELECTED';
echo '> Tuvalu</OPTION> 
						  <OPTION VALUE="UG"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'UG') echo ' SELECTED';
echo '> Uganda</OPTION> 
						  <OPTION VALUE="UA"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'UA') echo ' SELECTED';
echo '> Ukraine</OPTION> 
						  <OPTION VALUE="AE"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'AE') echo ' SELECTED';
echo '> United Arab Emirates</OPTION> 
						  <OPTION VALUE="GB"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'GB') echo ' SELECTED';
echo '> United Kingdom</OPTION> 
						  <OPTION VALUE="US"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'US') echo ' SELECTED';
echo '> United States</OPTION> 
						  <OPTION VALUE="UM"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'UM') echo ' SELECTED';
echo '> United States Minor Outlying Islands</OPTION> 
						  <OPTION VALUE="UY"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'UY') echo ' SELECTED';
echo '> Uruguay</OPTION> 
						  <OPTION VALUE="UZ"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'UZ') echo ' SELECTED';
echo '> Uzbekistan</OPTION> 
						  <OPTION VALUE="VU"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'VU') echo ' SELECTED';
echo '> Vanuatu</OPTION> 
						  <OPTION VALUE="VE"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'VE') echo ' SELECTED';
echo '> Venezuela</OPTION> 
						  <OPTION VALUE="VN"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'VN') echo ' SELECTED';
echo '> Viet Nam</OPTION> 
						  <OPTION VALUE="VG"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'VG') echo ' SELECTED';
echo '> Virgin Islands, British</OPTION> 
						  <OPTION VALUE="VI"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'VI') echo ' SELECTED';
echo '> Virgin Islands, U.S.</OPTION> 
						  <OPTION VALUE="YE"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'YE') echo ' SELECTED';
echo '> Yemen</OPTION> 
						  <OPTION VALUE="YU"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'YU') echo ' SELECTED';
echo '> Yugoslavia</OPTION> 
						  <OPTION VALUE="ZR"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'ZR') echo ' SELECTED';
echo '> Zaire</OPTION> 
						  <OPTION VALUE="ZM"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'ZM') echo ' SELECTED';
echo '> Zambia</OPTION> 
						  <OPTION VALUE="ZW"'; if (isset($locations[$theid]['country']) && $locations[$theid]['country'] == 'ZW') echo ' SELECTED';
echo '> Zimbabwe</OPTION> 
						</SELECT>'.
		'</td>'.
		'</tr>'.

		'<tr>'.
                '<td align=left style="padding-left: 20px;">'. _("Display Position") . ':</td>'.
                '<td>&nbsp;</td><td>'.
                '<select name="weather_position">';
	if ($locations[$theid]['position'] == "before")
	{
		echo	'<option value=before selected>Above folder list'.
			'<option value=after>Below folder list';
	}
	else
	{
		echo	'<option value=before>Above folder list'.
			'<option value=after selected>Below folder list';
	}
        echo	'</select>'.
		'<br></td>'.
		'</tr>'.

                '<tr>'.
                '<td align=left width="20%" style="padding-left: 20px;">'.
                _("Cache Time (min):").
                '</td>'.
                '<td width="6%">&nbsp;</td><td align=left width="74%">'.
                '<input type=text size=10 maxlen=10 name=weather_cachetime value="';

        if (isset ($locations[$theid]['cachetime']))
        {
                echo $locations[$theid]["cachetime"] / 60;
        }
	else
	{
		echo $weather_cache_time_minimum;
	}

        echo    '"> (' . $weather_cache_time_minimum . ' ' . _("minutes minimum") . ')' .
                '</td>'.
                '</tr>'.

		'</table>'.

        "<table WIDTH=\"100%\" BORDER=\"0\" CELLPADDING=\"5\" CELLSPACING=\"0\" BGCOLOR=\"" . $color[4] . "\"><TR><td ALIGN=\"LEFT\" style=\"padding-left: 10px;\">".
        '<br>'. _("Select which of the following information you want displayed for this location:") . 
        '</TD></TR></TABLE>'.

                "<table cellpadding=2 cellspacing=0 border=0 WIDTH=\"100%\" BGCOLOR=\"" . $color[4] . "\">".
		'<tr>'.
		'<td width="30%" align=left valign=middle style="padding-left: 20px;">'.
		_("Temperature:").
		'</td>'.
		'<td width="20%" align=left valign=middle>';
	if (!isset($locations[$theid]['view-temp']) || $locations[$theid]['view-temp'] == 0)
	{
		echo	'<input type=checkbox name=weather_view_temp value=1>';
	}
	else
	{
		echo	'<input type=checkbox name=weather_view_temp value=1 checked>';
	}

	echo	'</td>'.

		'<td align=left valign=middle width="30%">'.
		_("Feels Like:").
		'</td>'.
		'<td align=left valign=middle width="20%">';
	if (!isset($locations[$theid]['view-feels']) || $locations[$theid]['view-feels'] == 0)
	{
		echo	'<input type=checkbox name=weather_view_feels value=1>';
	}
	else
	{
		echo	'<input type=checkbox name=weather_view_feels value=1 checked>';
	}

	echo	'</td>'.
		'</tr>'.

                '<tr>'.
                '<td align=left valign=middle style="padding-left: 20px;">'.
                _("Conditions:").
                '</td>'.
                '<td align=left valign=middle>';
        if (!isset($locations[$theid]['view-conditions']) || $locations[$theid]['view-conditions'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_conditions value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_conditions value=1 checked>';
        }

        echo    '</td>'.

                '<td align=left valign=middle>'.
                _("UV Index:").
                '</td>'.
                '<td align=left valign=middle>';
        if (!isset($locations[$theid]['view-uv']) || $locations[$theid]['view-uv'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_uv value=1 disabled>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_uv value=1 checked disabled>';
        }

        echo    '</td>'.
                '</tr>'.

                '<tr>'.
                '<td align=left valign=middle style="padding-left: 20px;">'.
                _("Wind:").
                '</td>'.
                '<td align=left valign=middle>';
        if (!isset($locations[$theid]['view-wind']) || $locations[$theid]['view-wind'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_wind value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_wind value=1 checked>';
        }

        echo    '</td>'.

                '<td align=left valign=middle>'.
                _("Dew Point:").
                '</td>'.
                '<td align=left valign=middle>';
        if (!isset($locations[$theid]['view-dew']) || $locations[$theid]['view-dew'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_dew value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_dew value=1 checked>';
        }

        echo    '</td>'.
                '</tr>'.

                '<tr>'.
                '<td align=left valign=middle style="padding-left: 20px;">'.
                _("Humidity:").
                '</td>'.
                '<td align=left valign=middle>';
        if (!isset($locations[$theid]['view-humidity']) || $locations[$theid]['view-humidity'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_humidity value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_humidity value=1 checked>';
        }

        echo    '</td>'.

                '<td align=left valign=middle>'.
                _("Visibility:").
                '</td>'.
                '<td align=left valign=middle>';
        if (!isset($locations[$theid]['view-visibility']) || $locations[$theid]['view-visibility'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_visibility value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_visibility value=1 checked>';
        }

        echo    '</td>'.
                '</tr>'.

                '<tr>'.
                '<td align=left valign=middle style="padding-left: 20px;">'.
                _("Barometer:").
                '</td>'.
                '<td align=left valign=middle>';
        if (!isset($locations[$theid]['view-barometer']) || $locations[$theid]['view-barometer'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_barometer value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_barometer value=1 checked>';
        }

        echo    '</td>'.

                '<td align=left valign=middle>'.
                _("Location:").
                '</td>'.
                '<td align=left valign=middle>';
        if (!isset($locations[$theid]['view-place']) || $locations[$theid]['view-place'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_place value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_place value=1 checked>';
        }

        echo    '</td>'.
                '</tr>'.

		'</table>'.

        "<table WIDTH=\"100%\" BORDER=\"0\" CELLPADDING=\"5\" CELLSPACING=\"0\" BGCOLOR=\"" . $color[4] . "\"><TR><td ALIGN=\"LEFT\" style=\"padding-left: 10px; padding-bottom: 10px;\">".
        '<br>'. _("The following options are to control the apperance of the display box. If the field is left blank, the default values will be used. In the case of the colors, the default values are based on the current theme.") .
        '</TD></TR></TABLE>';

        echo    "<table cellpadding=2 cellspacing=0 border=0 WIDTH=\"100%\" BGCOLOR=\"" . $color[4] . "\">".
                '<tr>'.
                '<td width="26%" align=left valign=middle style="padding-left: 20px;">'.
                _("Show this location:").
                '</td>'.
                '<td width="74%" align=left valign=middle>';
        if (!isset($locations[$theid]['viewable']) || $locations[$theid]['viewable'] == 0)
        {
                echo    '<input type=checkbox name=weather_viewable value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_viewable value=1 checked>';
        }

        echo    '</td>'.
                '</tr>'.

                '<tr>'.
                '<td align=left style="padding-left: 20px;">'.
                _("Box Width:").
                '</td>'.
                '<td align=left>'.
                '<input type=text size=7 maxlen=7 name=weather_width value="';

        if (isset ($locations[$theid]['width']))
        {
                echo $locations[$theid]["width"];
        }

        echo    '">'.
                '</td>'.
                '</tr>'.
		'</table>';

        echo    "<table cellpadding=2 cellspacing=0 border=0 WIDTH=\"100%\" BGCOLOR=\"" . $color[4] . "\">".
                '<tr>'.
                '<td align=left width="26%" style="padding-left: 20px;">'.
                _("Margin - Right:").
                '</td>'.
                '<td align=left width="24%">'.
                '<input type=text size=7 maxlen=7 name=weather_margin_right value="';

        if (isset ($locations[$theid]['margin-right']))
        {
                echo $locations[$theid]["margin-right"];
        }

        echo    '">'.
                '</td>'.

                '<td align=left width="26%" style="padding-left: 10px;">'.
                _("Margin - Left:").
                '</td>'.
                '<td align=left width="24%">'.
                '<input type=text size=7 maxlen=7 name=weather_margin_left value="';

        if (isset ($locations[$theid]['margin-left']))
        {
                echo $locations[$theid]["margin-left"];
        }

        echo    '">'.
                '</td>'.
		'</tr>'.

                '<tr>'.
                '<td align=left" style="padding-left: 20px;">'.
                _("Margin - Top:").
                '</td>'.
                '<td align=left>'.
                '<input type=text size=7 maxlen=7 name=weather_margin_top value="';

        if (isset ($locations[$theid]['margin-top']))
        {
                echo $locations[$theid]["margin-top"];
        }

        echo    '">'.
                '</td>'.

                '<td align=left style="padding-left: 10px;">'.
                _("Margin - Bottom:").
                '</td>'.
                '<td align=left>'.
                '<input type=text size=7 maxlen=7 name=weather_margin_bottom value="';

        if (isset ($locations[$theid]['margin-bottom']))
        {
                echo $locations[$theid]["margin-bottom"];
        }

        echo    '">'.
                '</td>'.
                '</tr>'.

                '<tr>'.
                '<td align=left style="padding-left: 20px;">'.
                _("Color - Background:").
                '</td>'.
                '<td align=left>'.
                '<input type=text size=7 maxlen=7 name=weather_color_background value="';

        if (isset ($locations[$theid]['color-background']))
        {
                echo $locations[$theid]["color-background"];
        }

        echo    '">'.
                '</td>'.

                '<td align=left style="padding-left: 10px;">'.
                _("Color - Foreground:").
                '</td>'.
                '<td align=left>'.
                '<input type=text size=7 maxlen=7 name=weather_color_foreground value="';

        if (isset ($locations[$theid]['color-foreground']))
        {
                echo $locations[$theid]["color-foreground"];
        }

        echo    '">'.
                '</td>'.
                '</tr>'.

                '<tr>'.
                '<td align=left style="padding-left: 20px;">'.
                _("Color - Labels:").
                '</td>'.
                '<td align=left>'.
                '<input type=text size=7 maxlen=7 name=weather_color_label value="';

        if (isset ($locations[$theid]['color-label']))
        {
                echo $locations[$theid]["color-label"];
        }

        echo    '">'.
                '</td>'.

                '<td align=left style="padding-left: 10px;">'.
                _("Color - Values:").
                '</td>'.
                '<td align=left>'.
                '<input type=text size=7 maxlen=7 name=weather_color_value value="';

        if (isset ($locations[$theid]['color-value']))
        {
                echo $locations[$theid]["color-value"];
        }

        echo    '">'.
                '</td>'.
                '</tr>'.
		'</table>'.

		"<table cellpadding=2 cellspacing=0 border=0 WIDTH=\"100%\" BGCOLOR=\"" . $color[4] . "\"><tr><td align=center>".
		'<br><input type=submit name=weather_submit value=' . _("Submit") . '>'.
		"<input type=hidden name=theid value=$theid><br><br>".
		'</form></td></tr></table>';
}

echo	"<table border=0 cellpadding=3 cellspacing=0 align=center WIDTH=\"100%\" BGCOLOR=\"" . $color[4] . "\">".
	'<tr><td><table border=0 cellpadding=3 cellspacing=0 align=center>';

for ($i = 0; $i < count ($locations); $i++)
{

	if ($emptyLocationNumber == $i) continue;


	$bgcolor = (($i % 2) ? $color[0] : $color[9]);

	echo	"<tr bgcolor=\"$bgcolor\"><td><small>".
		"[<a href=\"options.php?theid=$i&action=edit\">" . _("Edit") . '</a>]'.
		'</small></td><td><small>'.
		"[<a href=\"options.php?theid=$i&action=delete\">" . _("Delete") . '</a>]'.
		'</small></td><td><small>';

	if ($locations[$i]['viewable'])
	{
		echo "[<a href=\"options.php?theid=$i&action=hidden\">" . _("Hide") . '</a>]';
	}
	else
	{
		echo "[<a href=\"options.php?theid=$i&action=visible\">" . _("Show") . '</a>]';
	}

	echo	'</small></td>';

	echo	'<td>-</td><td>';
	printf ( _("Location: <b>%s</b>"), _($locations[$i]['code']));
	echo '</td></tr>';
}

echo	'</table></td></tr></table>'.
	"<table width=100% align=center border=0 cellpadding=2 cellspacing=0 bgcolor=\"" . $color[4] . "\">".
	'<tr><td>&nbsp</td></tr>'.
	'</table></td></tr></table>';


?>
