<?php

/*******************************************************************************

	Author  .......  Daniel B. Hemmerich
	Contact  ......  dan@spot.org
	Home Site  ....  http://www.spot.org/
	Program  ......  SquirrelMail Plugin - Weather
	Version  ......  4.1.1

*******************************************************************************/

// include compatibility plugin
//
if (defined('SM_PATH'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('../plugins/compatibility/functions.php'))
   include_once('../plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
   include_once('./plugins/compatibility/functions.php');


if (compatibility_check_sm_version(1, 3))
   include_once (SM_PATH . 'plugins/weather/weather.php');
else
   include_once ('../plugins/weather/weather.php');


function weather_show_before_do ()
{
	$locations = load_locations ();

	for ($i = 0; $i < count ($locations); $i++)
	{
		if ($locations[$i]['position'] == "before")
		{
			weather_display ($locations[$i], $i);
		}
	}

	return;
}


function weather_show_after_do ()
{
	$locations = load_locations ();

	for ($i = 0; $i < count ($locations); $i++)
	{
		if ($locations[$i]['position'] == "after")
		{
			weather_display ($locations[$i], $i);
		}
	}

	return;
}

function weather_optpage_register_block_do ()
{
	global $optpage_blocks;

	$optpage_blocks[] = array (
		'name' => _("Weather"),
		'url'  => '../plugins/weather/options.php',
		'desc' => _("Setup the weather displaying options. You can add all the cities you want to monitor as well as various options to display."),
		'js'   => false);

	return;
}

?>
