<?php

/*******************************************************************************

    Author ....... Daniel Hemmerich
    Contact ...... dan@spot.org
    Home Site .... http://www.spot.org/
    Program ...... Weather
    Version ...... 1.2.1
    Purpose ...... Grab a weather graphic from www.accuweather, based on the
                   zip code provided by the user, and place it either before
                   or after the folder list on the left (or right).

*******************************************************************************/


if (isset($zip_code) && isset($width))
{
    // Ok, Looks like php chokes when it gets a 302. Lets do a raw request

    $httpsock = fsockopen("www.accuweather.com",80);
    $request  = "GET /wxpost/byzip/$zip_code HTTP/1.0\r\n";
    $request .= "Host: www.accuweather.com\r\n";
    $request .= "Accept: */*\r\n";
    $request .= "\r\n\r\n";
   
    fwrite($httpsock,$request);
    $data = "";

    while (!feof($httpsock)) {
        $data .= fread($httpsock,1024);
    }

    // Ok, now somewhere im $data should be out real image url

    preg_match("/Location: (.*)/",$data,$chunk);
    $url = trim($chunk[1]);
   
    $width -= 20;
    $x = $width;
    $y = ceil ($width / 2.1) + 2;
    $im = ImageCreateFromPng($url);
    $imgname = ImageCreate($x, $y);
    ImageFill ($imgname, 0, 0, ImageColorAllocate($imgname, 0xe6, 0xe6, 0xe6));

    if( $width == 120 ) {
        ImageCopy ($imgname, $im, 1, 4, 73, 35, 118, 56);
    } else {
        ImageCopyResized ($imgname, $im, 1, 4, 73, 35, ($x - 2), ($y - 4), 118, 56);
    }
    ImageRectangle ($imgname, 0, 0, ($x - 1), ($y - 1), ImageColorAllocate($imgname, 0, 0, 0));

    Header("Content-type: image/png");
    ImagePng($imgname);

    ImageDestroy($imgname);
    ImageDestroy($im);
}

?>
