<?php

/**
  * SquirrelMail Virtual Host Login Plugin
  * Copyright (C) 2003-2005 Paul Lesneiwski <paul@openguild.net>
  * This program is licensed under GPL. See COPYING for details
  *
  */


/** 
  * Get Per-User, Per-Domain or Per-Service 
  * Level Config Overrides From SQL Database
  *
  * Looks up a user, domain or service level in a SQL database
  * and overrides any settings as found there.
  *
  * @param string $query The query to be run
  * @param string $replacement The value to be inserted into the query
  *                            for lookup (the user name, domain name
  *                            or service level).
  * @param array $args The array of arguments passed to the current hook.
  *
  */
function SQL_settings_lookup($query, $replacement, $args) 
{

   // we assume this function is called from a place 
   // where the config file has already been included...
   //
   global $useSessionBased, $plugins, $squirrelmail_plugin_hooks, $default_org_logo;


   include_once('DB.php');


   $db = vlogin_get_database_connection();

   $query = str_replace('%1', $replacement, $query);


   $settings = $db->getAll($query);


   // check for database errors
   //
   if (DB::isError($settings))
   {
      $msg = $settings->getMessage();
      plain_error_message(sprintf('ERROR IN VLOGIN SQL BACKEND (%s): could not query settings for "%s" - %s', 'SQL_settings_lookup', $replacement, $msg), $color);
      exit;
   }


   if ($useSessionBased)
   {
      global $config_override;
      sqsession_unregister('config_override');
      // If we don't initialize this, it will work
      // together with the multilogin plugin and 
      // any settings already made for the domain
      // $config_override = array();
   }


   // override any settings found
   //
   foreach ($settings as $settingPair)
   {

      $setting = $settingPair[0];
      $value = $settingPair[1];


      // put arrays of values back together
      //
      if (strpos($value, ',,') !== FALSE)
      {

         $value_array = explode(',,', $value);

         $value = array();
         foreach ($value_array as $val)
         {
            if (empty($val)) continue;
            if (strpos($val, '=') !== FALSE)
            {
               list($key, $val) = explode('=', $val);
               $value[$key] = $val;
            }
            else  
               $value[] = $val;
         }
         
      }


      // convert strings "true" and "false" to real boolean values
      //
      else if (strtoupper($value) === 'TRUE') $value = TRUE;
      else if (strtoupper($value) === 'FALSE') $value = FALSE;


      if ($useSessionBased)
      {
         // use default org logo if configured and this org_logo non-existent
         //
         if (!empty($default_org_logo) && $setting == 'org_logo' && !file_exists($value))
            $value = $default_org_logo;

         $config_override[$setting] = $value;
      }
      else
      {

         // in order to set the org_title, in the browser
         // title bar, have to do it now (using an eval
         // otherwise things like $_SESSION will never be
         // found when the variable is first defined)
         //
// TODO: what about the embedded PHP setting here???
         if ($setting == 'org_title')
         {
            global $$setting;
            eval('$$setting = ' . $value . ';');
         }


         // use default org logo if configured and this org_logo non-existent
         //
         else if (!empty($default_org_logo) && $setting == 'org_logo' && !file_exists($value))
         {
            global $$setting;
            $$setting = $default_org_logo;
         }


         // enable additional plugins
         //
         else if (stristr($setting, 'enable_plugins'))
         {
            foreach ($value as $pluginName)
            {
               $plugins[] = $pluginName;
               use_plugin($pluginName);
            }
         }


         // disable plugins
         //
         else if (stristr($setting, 'disable_plugins'))
         {
            foreach ($value as $pluginName)
            {
               $pluginKey = array_search($pluginName, $plugins);
               if (!is_null($pluginKey) && $pluginKey !== FALSE)
               {
                  unset($plugins[$pluginKey]);
                  foreach (array_keys($squirrelmail_plugin_hooks) as $hookName)
                  {
                     unset($squirrelmail_plugin_hooks[$hookName][$pluginName]);
                  }
               }
            }
         }


         // regular config setting...
         //
         else
         {
            global $$setting;
            $$setting = $value;
         }

      }

   }


   if ($useSessionBased)
   {
      
      sqsession_register($config_override, 'config_override');
      
      include_once (SM_PATH . 'plugins/multilogin/functions.php');

      multilogin_sqoverride_config_do($args);

   }

}



?>
