<?php

/**
  * SquirrelMail Virtual Host Login Plugin
  * Copyright (C) 2003-2005 Paul Lesneiwski <paul@openguild.net>
  * This program is licensed under GPL. See COPYING for details
  *
  */


/** 
  * Get Per-User Config Overrides
  *
  * Looks up a user in the per-user config file and, if found,
  * grabs and uses the user's custom settings.
  *
  * @param string $user The username for which to look for custom settings.
  * @param array $args The array of arguments passed to the current hook.
  *
  */
function perUserOverride_do($user, $args) 
{

   // we assume this function is called from a place 
   // where the config file has already been included...
   //
   global $at, $atConversion, $perUserSettingsFile, $useSessionBased,
          $plugins, $squirrelmail_plugin_hooks, $default_org_logo;


   // convert "at" sign...
   //
   foreach ($atConversion as $otherAt)
      $user = str_replace($otherAt, $at, $user);


   // override per-user settings
   //
   if (!empty($perUserSettingsFile) && !empty($user)) {


      // find settings for user
      //
      $userSettings = array();
      if ($USERSETTINGS = @fopen ($perUserSettingsFile, "r"))
      {

         while (!feof($USERSETTINGS))
         {

            $line = fgets($USERSETTINGS, 4096);
            $line = trim($line);


            // skip blank lines and comment lines
            //
            if (strpos($line, '#') === 0 || strlen($line) < 3)
               continue;


            // parse fields out
            //
            if (substr($line, strlen($line) - 1) != ',') $line .= ',';
            preg_match_all('/(.+?),\s*/', $line, $configSettings, PREG_PATTERN_ORDER);


            // stop when we have the right username (case insensitive)
            //
            if (strtoupper($user) == strtoupper($configSettings[1][0]))
            {
               $userSettings = $configSettings[1];
               break;
            }


            // if wildcard match for user is found, 
            // grab settings, but don't stop looking 
            // for exact match
            //
            if (strpos($configSettings[1][0], '*') !== FALSE
             || strpos($configSettings[1][0], '?') !== FALSE)
            {
               if (preg_match('/^' . str_replace(array('?', '*'), array('\w{1}', '.*?'), 
                           strtoupper($configSettings[1][0])) . '$/', strtoupper($user)))
                  $userSettings = $configSettings[1];
            }

         }

         fclose($USERSETTINGS);

      }

      if (sizeof($userSettings) > 0)
      {


        // put arrays of values back together
        //
        for ($x = 0; $x < sizeof($userSettings); $x++)
        {
           if (substr($userSettings[$x], 0, 1) == ',')
           {
              $userSettings[$x - 1] .= $userSettings[$x];
              array_splice($userSettings, $x, 1);
              $x--;
           }
        }


        if ($useSessionBased)
        {
           global $config_override;
           sqsession_unregister('config_override');
           // If we don't initialize this, it will work
           // together with the multilogin plugin and 
           // any settings already made for the domain
           // $config_override = array();
        }


        // loop through user's settings 
        //
        foreach ($userSettings as $setting)
        {

           if (!strpos($setting, '='))
              continue;

           $matches = explode('=', $setting);


           // convert strings "true" and "false" to real boolean values
           //
           if (strtoupper($matches[1]) === 'TRUE') $matches[1] = TRUE;
           else if (strtoupper($matches[1]) === 'FALSE') $matches[1] = FALSE;


           if ($useSessionBased)
           {
              if (stristr($matches[0], 'enable_plugins') || stristr($setting, 'disable_plugins'))
                 $config_override[$matches[0]] = explode(',', $matches[1]);

              // use default org logo if configured and this org_logo non-existent
              else if (!empty($default_org_logo) && $matches[0] == 'org_logo' && !file_exists($matches[1]))
                 $config_override[$matches[0]] = $default_org_logo;

              else
                 $config_override[$matches[0]] = $matches[1];
           }
           else
           {

              // in order to set the org_title, in the browser
              // title bar, have to do it now (using an eval
              // otherwise things like $_SESSION will never be
              // found when the variable is first defined)
              //
// TODO: what about the embedded PHP setting here???
              if ($matches[0] == 'org_title')
              {
                 global $$matches[0];
                 eval('$$matches[0] = ' . $matches[1] . ';');
              }


              // use default org logo if configured and this org_logo non-existent
              //
              else if (!empty($default_org_logo) && $matches[0] == 'org_logo' && !file_exists($matches[1]))
              {
                 global $$matches[0];
                 $$matches[0] = $default_org_logo;
              }


              // enable additional plugins
              //
              else if (stristr($matches[0], 'enable_plugins'))
              {
                 $values = explode(',', $matches[1]);
                 foreach ($values as $pluginName)
                 {
                    $plugins[] = $pluginName;
                    use_plugin($pluginName);
                 }
              }


              // disable plugins
              //
              else if (stristr($setting, 'disable_plugins'))
              {
                 $values = explode(',', $matches[1]);
                 foreach ($values as $pluginName)
                 {
                    $pluginKey = array_search($pluginName, $plugins);
                    if (!is_null($pluginKey) && $pluginKey !== FALSE)
                    {
                       unset($plugins[$pluginKey]);
                       foreach (array_keys($squirrelmail_plugin_hooks) as $hookName)
                       {
                          unset($squirrelmail_plugin_hooks[$hookName][$pluginName]);
                       }
                    }
                 }
              }


              // regular config setting...
              //
              else
              {
                 global $$matches[0];
                 $$matches[0] = $matches[1];
              }

           }

        }


        if ($useSessionBased)
        {
      
           sqsession_register($config_override, 'config_override');
      
           include_once (SM_PATH . 'plugins/multilogin/functions.php');

           multilogin_sqoverride_config_do($args);

        }

     }

  }

}



?>
