<?php
/*
    vkeyboard main window.
    Copyright 2003, 2004 Daniel K. Imori

    This file is part of vkeyboard plugin.

    vkeyboard plugin is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    vkeyboard plugin is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with vkeyboard plugin; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

define('SM_PATH', '../../');

include_once(SM_PATH . 'plugins/vkeyboard/config.php');

// Load keyboard layout selected
require 'layouts/' . $kbd_layout . '.php';

// Gettext
include_once(SM_PATH . 'functions/i18n.php');
$plugin_path = SM_PATH . 'plugins/vkeyboard/';

bindtextdomain('vkeyboard', $plugin_path . 'locale');
textdomain('vkeyboard');

// Initial HTML
echo "<html>\n<head>\n<title>";
echo _("Virtual Keyboard");
echo "</title>\n</head>\n<body>\n<b>";
echo _("Enter your password:");
echo "</b>\n<form name=\"keyboard\">";

// The first key
$n = rand(0, (count($layout) - 1));

// Generating keys
for($i = 0; $i < count($layout); $i++) {
   if($layout[$n] == '"')
      $value = 'value=\'"\'';  // " sucks
   else
      $value = 'value="' . $layout[$n] . '"';
   echo '<input type="button" name="button' . $i . '" ' . $value .
        ' style="width: 1.5em; border-style: none" onclick="window.opener.' .
        'document.forms[0].' . $_GET['passformname'] . '.value += document.' .
        'keyboard.button' . $i . '.value; document.keyboard.login.focus()">';
   $n++;  // next key
   if($n > (count($layout) - 1)) $n = 0;  // back to the first
}

// Buttons
echo '<p><input type="button" name="login" value="';
echo _("Login");
echo '" onclick="window.opener.document.forms[0].submit(); self.close()">' .
     '&nbsp;&nbsp;<input type="button" value="';
echo _("Clear");
echo '" onclick="window.opener.document.forms[0].' . $_GET['passformname'] .
     '.value = \'\'">&nbsp;<input type="button" value="';
echo _("Close");
echo '" onclick="self.close()">';

// Final HTML
echo <<<END
    </form>
  </body>
</html>
END;

// Back gettext to Squirrelmail
bindtextdomain('squirrelmail', SM_PATH . 'locale');
textdomain('squirrelmail');

?>
