<?php
/* variable_sent_folder -- Version 0.3
 * By Robin Rainton <robin@rainton.com>
 * http://rainton.com/fun/freeware
 *
 * Place a drop down on the bottom of the compose form to allow
 * the user to select which folder a copy of this message will
 * be saved in when sent (if at all).
 */

function squirrelmail_plugin_init_variable_sent_folder() {
  global $squirrelmail_plugin_hooks;
  $squirrelmail_plugin_hooks['compose_send']['variable_sent_folder'] =
    'variable_sent_folder_compose';
  $squirrelmail_plugin_hooks['compose_button_row']['variable_sent_folder'] =
    'variable_sent_folder_dropdown';
  $squirrelmail_plugin_hooks['options_folder_inside']['variable_sent_folder'] =
    'variable_sent_folder_options';
  $squirrelmail_plugin_hooks['options_folder_save']['variable_sent_folder'] =
    'variable_sent_folder_save';
  $squirrelmail_plugin_hooks['loading_prefs']['variable_sent_folder'] =
    'variable_sent_folder_pref';
}

function variable_sent_folder_dropdown()
{
  global $sent_folder, $variable_sent_folder, $reply_id,
         $mailbox;
  global $variable_sent_folder_on,
         $variable_sent_folder_default;

 /*
  * Don't show this if we're not supposed to.
  */

  switch ($variable_sent_folder_on) {
    case 0: return;
    case 3: break;
    case 1: if (!isset($reply_id)) return; break;
    case 2: if (isset($reply_id)) return;
  }

/*
 * Make sure the sent selection is perpetuated when doing spell checks,
 * adding attachements, etc, etc.
 * If not, make sure the correct default one will be selected.
 */

  if (isset($variable_sent_folder)) {
    $sent_folder = $variable_sent_folder;
  } else {
    if ($variable_sent_folder_default == 2 &&
        isset($reply_id)) $sent_folder = $mailbox;
  }

/*
 * Log into server if not already done.
 */

  global $imapConnection, $username, $key, $imapServerAddress, $imapPort;
  if (!isset($imapConnection)) {
    $imapConnection = sqimap_login($username, $key, $imapServerAddress,
                                   $imapPort, 0);
  }

/*
 * Show the folder options
 */

  $boxes = sqimap_mailbox_list($imapConnection);
  if (count($boxes) < 1) return;

  echo '<BR>Save Sent Message in: <select name="variable_sent_folder">';
  echo '<option value="' . SMPREF_NONE . '"' .
         ($sent_folder == SMPREF_NONE ? ' selected' : '') .
         ">&lt;Do not Save&gt;</option>\n";
  for ($boxnum = 0; $boxnum < count($boxes); $boxnum++) {
    echo '<option value="' . $boxes[$boxnum]['unformatted'] . '"' .
         ($sent_folder == $boxes[$boxnum]['unformatted'] ? ' selected' : '') .
         '>' .
         $boxes[$boxnum]['unformatted-disp'] . "</option>\n";
  }
  echo "</select>\n";
}

function variable_sent_folder_compose()
{
  global $sent_folder, $variable_sent_folder;
  if (isset($_POST['variable_sent_folder'])) {
    $sent_folder = $_POST['variable_sent_folder'];
  }
}

/*
 * Here come the few functions for preference handling.
 */

function variable_sent_folder_options()
{
  global $variable_sent_folder_on,
         $variable_sent_folder_default;

  ?><tr><td align=right nowrap valign="top">Show Variable Sent Folder:</td><td>
  <select name="variable_sent_folder_option_on">
  <option value="3"<?PHP
      if (isset($variable_sent_folder_on) && $variable_sent_folder_on == 3)
        echo ' SELECTED';
    ?>>Always</option>>
  <option value="2"<?PHP
      if (isset($variable_sent_folder_on) && $variable_sent_folder_on == 2)
        echo ' SELECTED';
    ?>>Only when composing new</option>>
  <option value="1"<?PHP
      if (isset($variable_sent_folder_on) && $variable_sent_folder_on == 1)
        echo ' SELECTED';
    ?>>Only when replying</option>>
  <option value="0"<?PHP
      if (isset($variable_sent_folder_on) && $variable_sent_folder_on == 0)
        echo ' SELECTED';
    ?>>Never</option>>
  </select></td></tr><tr><td align=right nowrap valign="top">
  Default Sent Folder:</td><td>
  <select name="variable_sent_folder_option_default">
  <option value="1"<?PHP
      if (isset($variable_sent_folder_default) && $variable_sent_folder_default == 1)
        echo ' SELECTED';
    ?>>'Sent Folder' defined above</option>>
  <option value="2"<?PHP
      if (isset($variable_sent_folder_default) && $variable_sent_folder_default == 2)
        echo ' SELECTED';
    ?>>As original message when replying</option>>
  </select>
  </td></tr><?PHP
}

function variable_sent_folder_save()
{
  global $username, $data_dir;

  if (isset($_POST['variable_sent_folder_option_on']))
    setPref($data_dir, $username, "variable_sent_folder_on",
            $_POST['variable_sent_folder_option_on']);

  if (isset($_POST['variable_sent_folder_option_default']))
    setPref($data_dir, $username, "variable_sent_folder_default",
            $_POST['variable_sent_folder_option_default']);
}

function variable_sent_folder_pref()
{ 
  global $username, $data_dir;
  global $variable_sent_folder_on,
         $variable_sent_folder_default;

  $variable_sent_folder_on = getPref($data_dir, $username, 'variable_sent_folder_on', 3);
  $variable_sent_folder_default = getPref($data_dir, $username, 'variable_sent_folder_default', 1);
}

?>
