<?php
/**
    VADMIN_FETCH_PIC.PHP
    ---------------------
    Fetches a custom picture for each domain. If QUERY_STRING
    is not set, it tries to determine which domain it is by 
    looking at the access URI. The images are pulled from the
    pic file in $VADMIN_DIR/domain directory.
    								**/
								
$WORK_DIR="vadmin";
// Load some necessary stuff.
chdir("..");
include ("$WORK_DIR/vadmin_config.php");
require ("$WORK_DIR/includes/vadmin_functions.inc");
$QUERY_STRING = $_SERVER{'QUERY_STRING'};
if ($QUERY_STRING) $domain=$QUERY_STRING; else $domain=vadmin_host_walk();
if (!$domain) exit;

$prefs_ary=vadmin_load_prefs($domain);

if (!$prefs_ary["pic"] || $prefs_ary["pic"]=="no"){
 // Load the standard SquirrelMail logo
 header("Content-type: image/jpeg");
 readfile("../../images/sm_logo.jpg");
 exit;
} else {
 // grab the custom image
 $contents=vadmin_get_file("$VADMIN_DIR/$domain/pic");
 header("Pragma: no-cache");
 header("Content-type: " . $prefs_ary["pic"]);
 echo $contents;
}
?>
