<?php
/**
 * VADMIN_DEBUG.PHP
 * -----------------
 * Debug file for VADMIN. Tells you if you have misconfigured your installation.
 *
 */

header("Content-type: text/plain");
echo "RUNNING VADMIN DEBUG\n";
echo "---------------------\n";

echo "Looking for mcrypt functions: ";
if (function_exists("mcrypt_generic")){
 echo "found\n"; 
} else {
 echo "not found\n";
 echo "\n\nYou need to compile in and enable mcrypt support!";
 exit;
}
$CRYPTO_HASH_LINE = $_SERVER{'CRYPTO_HASH_LINE'};
$MCRYPT_ALGO = $_SERVER{'MCRYPT_ALGO'};
echo "Looking for CRYPTO_HASH_LINE: ";
if ($CRYPTO_HASH_LINE){
 echo "found\n";
 echo "Looking for MCRYPT_ALGO: ";
 if ($MCRYPT_ALGO){
  echo "found\n";
  echo "\nAll configuration checks passed successfully.";
 } else {
  echo "not found\n";
  echo "\nPlease check your " . getcwd() . "/includes/apache.inc file!";
  exit;
 }
} else {
 echo "not found\n";
 echo "
This most likely means one or both of the following:
 * An 'include' line was not added to httpd.conf
 * You did not restart apache after installing vadmin
 * You misconfigured the apache.inc.

Check your httpd.conf. You should see this line:
Include " . getcwd() . "/includes/apache.inc

Add this line if you don't see it.

Restart the apache if you didn't and then run this debug again. If you
did restart apache, check the <Directory> directive provided in the
include (includes/apache.inc):

Current working dir as seen by Apache is: ";
 echo getcwd() . "\n";
 echo "
You should check the include file and make sure that the path in the
<Directory> directive EXACTLY matches the one above, as seen here:

<Directory " . getcwd() . ">
 SetEnv CRYPTO_HASH_LINE \"YOUR_CRYPTO_HASH\"
 SetEnv MCRYPT_ALGO \"YOUR_ALGO\"
</Directory>

If the problem persists, please contact squirrelmail-plugins@lists.sourceforge.net.

";


}
?>
