#!/bin/sh

if test `id -u` != 0; then 
 echo "Error: Must be root!"
 exit 1
fi

if test ! $1; then
 echo "Usage: vdeldomain.sh domainname.com"
 exit 1
fi

if test ! -f $HOME/.vadmin; then
 echo "Can't find $HOME/.vadmin. Run installer.sh or mkdot-vadmin.sh"
 exit 1
fi
. $HOME/.vadmin

VDOMAIN=$1

if test ! -d $VADMIN_DIR/$VDOMAIN; then
 echo "Domain '$VDOMAIN' is not configured with VADMIN anyway."
 exit 1
fi

echo -n "Are you sure you want to delete '$VDOMAIN'? y/[n]: "
read REPLY
if test ! $REPLY; then REPLY="n"; fi
if test $REPLY != "y"; then exit 0; fi

echo -n "Deleting '$VDOMAIN' directory..."
rm -rf $VADMIN_DIR/$VDOMAIN
echo "done"
echo -n "Removing '$VDOMAIN' from cross-admins..."
cd $VADMIN_DIR/cross-admins
for XADMIN in `grep -l $VDOMAIN *`; do
 grep -v $VDOMAIN "$XADMIN" > .tmp-xadmin
 if test -s .tmp-xadmin; then
  mv .tmp-xadmin "$XADMIN"
 else
  rm .tmp-xadmin "$XADMIN"
 fi
done
echo "done"
echo "Domain '$VDOMAIN' deleted."
