#!/bin/sh

if test `id -u` != 0; then
 echo "Error: must be root"
 exit 1
fi

if test -f $HOME/.vadmin; then
 echo -n "You already have $HOME/.vadmin. Override? y/[n]: "
 read REPLY
 if test ! $REPLY; then REPLY="n"; fi
 if test $REPLY != "y"; then exit 0; fi
fi

clear
cd ..
PLUGIN_DIR=`pwd`
cd scripts
cat screens/plugin_directory.txt | sed "s|%1%|$PLUGIN_DIR|"
echo -n "Plugin directory [$PLUGIN_DIR]: "
read REPLY
if test $REPLY ; then PLUGIN_DIR=$REPLY; fi
if test ! -d $PLUGIN_DIR; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|No such directory $PLUGIN_DIR|"
 exit 1
fi

clear
VADMIN_DIR="/var/vadmin"
cat screens/vadmin_directory.txt | sed "s|%1%|$VADMIN_DIR|"
echo -n "Vadmin storage directory [$VADMIN_DIR]: "
read REPLY
if test $REPLY ; then VADMIN_DIR=$REPLY; fi
if test ! -d $VADMIN_DIR; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|No such directory $VADMIN_DIR|"
 exit 1
fi
if test ! -d $VADMIN_DIR/cross-admins; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|Directory $VADMIN_DIR is not a VADMIN data directory.|"
 exit 1
fi

clear
HTTPD_CONF="/etc/httpd.conf"
cat screens/which_httpdconf.txt | sed "s|%1%|$HTTPD_CONF|"
echo -n "My httpd.conf is [$HTTPD_CONF]: "
read REPLY
if test $REPLY ; then HTTPD_CONF=$REPLY; fi
if test ! -f $HTTPD_CONF; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|Can't find file $HTTPD_CONF|"
 exit 1
fi

clear
HTTPD_USER=`egrep "^[Uu][Ss][Ee][Rr]" $HTTPD_CONF | sed 's/^[^ ][^ ]* \([^ ][^ ]*\).*/\1/;q'`
HTTPD_GROUP=`egrep "^[Gg][Rr][Oo][Uu][Pp]" $HTTPD_CONF | sed 's/^[^ ][^ ]* \([^ ][^ ]*\).*/\1/;q'`
cat screens/which_apache_proc.txt | sed "s|%1%|$HTTPD_USER|" | sed "s|%2%|$HTTPD_GROUP|"
echo -n "My apache runs as user [$HTTPD_USER]: "
read TMPUSER
echo -n "My apache runs as group [$HTTPD_GROUP]: "
read TMPGROUP
if test $TMPUSER ; then HTTPD_USER=$TMPUSER; fi
if test $TMPGROUP ; then HTTPD_GROUP=$TMPGROUP; fi
if ! egrep "^$HTTPD_USER:" /etc/passwd > /dev/null 2>&1; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|No such user '$HTTPD_USER'|"
 exit 1
fi
if ! egrep "^$HTTPD_GROUP:" /etc/group > /dev/null 2>&1; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|No such group '$HTTPD_GROUP'|"
 exit 1
fi

if ! egrep "^[Uu][Ss][Ee][Rr] *$HTTPD_USER" $HTTPD_CONF > /dev/null 2>&1; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|Your apache is NOT running as user '$HTTPD_USER'|"
 exit 1
fi

if ! egrep "^[Gg][Rr][Oo][Uu][Pp] *$HTTPD_GROUP" $HTTPD_CONF > /dev/null 2>&1; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|Your apache is NOT running as group '$HTTPD_GROUP'|"
 exit 1
fi

echo "Saving preferences in $HOME/.vadmin to be later used by"
echo -n "other vadmin scripts..."
# stick some vars into ~/.vadmin so we can read them later
# from other vadmin scripts
echo "#!/bin/sh" > $HOME/.vadmin
echo "# These variables are used by vadmin scripts" >> $HOME/.vadmin
echo "PLUGIN_DIR=$PLUGIN_DIR" >> $HOME/.vadmin
echo "VADMIN_DIR=$VADMIN_DIR" >> $HOME/.vadmin
echo "HTTPD_USER=$HTTPD_USER" >> $HOME/.vadmin
echo "HTTPD_GROUP=$HTTPD_GROUP" >> $HOME/.vadmin
chmod 0700 $HOME/.vadmin
echo "done"

