#!/bin/sh

if test `id -u` != 0; then 
 echo "Error: Must be root!"
 exit 1
fi

if test ! -f $HOME/.vadmin; then
 echo "Can't find $HOME/.vadmin. Run installer.sh or mkdot-vadmin.sh"
 exit 1
fi
. $HOME/.vadmin

cd $VADMIN_DIR/cross-admins
while test 1; do
 clear
 echo "Current elvises on this system:"
 echo "--------------------------------"
 for ELVIS in `grep -l elvis *`; do echo $ELVIS; done
 echo "--"
 echo -n "Handle/killall/exit: "
 read ACTION
 if test $ACTION; then
  case "$ACTION" in
   exit)
    exit 0
    ;;
   killall)
    echo -n "Remove all elvises from this system? y/[n]: "
    read REPLY
    if test ! $REPLY; then REPLY="n"; fi
    if test $REPLY = "y"; then
     for ELVIS in `grep -l elvis *`; do rm -f "$ELVIS"; done
    fi
    ;;
   *)
    ELVIS=$ACTION
    if test -f "$ELVIS"; then
     if egrep "^elvis$" "$ELVIS" > /dev/null 2>&1; then
      rm -f "$ELVIS"
     else
      echo "elvis" > "$ELVIS"
     fi
    else
     echo -n "Elvis $ELVIS does not exist. Create? [y]/n: "
     read REPLY
     if test ! $REPLY; then REPLY="y"; fi
     if test $REPLY = "y"; then
      echo "elvis" > "$ELVIS"
     fi
    fi
    ;;
  esac
 fi
done
