#!/bin/sh

if test `id -u` != 0; then 
 echo "Error: Must be root!"
 exit 1
fi

if test ! -f $HOME/.vadmin; then
 echo "Did not find $HOME/.vadmin. Run installer.sh or mkdot-vadmin.sh"
 exit 1
fi

clear
cat screens/dmagic_startup.txt
echo -n "Should I import domains? [y]/n: "
read REPLY
if test ! $REPLY; then REPLY="y"; fi
if test $REPLY != "y"; then exit 1; fi
echo

VDOMAINS_FILE="/var/qmail/control/virtualdomains"
while test ! -f $VDOMAINS_FILE; do
 echo "File $VDOMAINS_FILE not found..."
 echo -n "Full path to qmail/control/virtualdomains: "
 read VDOMAINS_FILE
done

. $HOME/.vadmin

clear
cat screens/dmagic_promptme.txt
echo -n "Prompt you before adding a domain? [y]/n: "
read PROMPTADD
if test ! $PROMPTADD; then PROMPTADD="y"; fi

clear
cat screens/dmagic_lowly.txt
cat screens/lowly_admins.txt
echo 
echo -n "Prompt you to add lowly admins? [y]/n: "
read PROMPTLOWLY
if test ! $PROMPTLOWLY; then PROMPTLOWLY="y"; fi

clear
cat screens/dmagic_processing.txt
for VDOMAIN in `sed 's/:.*$//' $VDOMAINS_FILE`; do
 if test ! -d $VADMIN_DIR/$VDOMAIN; then
  DOMAINS_FOUND=1
  if test $PROMPTADD = "y"; then
   echo -n "Found '$VDOMAIN'. Add this domain? [y]/n: "
   read 
   if test ! $REPLY; then REPLY="y"; fi
   if test $REPLY = "y"; then
    ADDIT="yes"
   else
    ADDIT="no"
   fi
  else
   ADDIT="yes"
  fi
  if test $ADDIT = "yes"; then
   echo -n "Adding $VDOMAIN..."
   mkdir $VADMIN_DIR/$VDOMAIN
   touch $VADMIN_DIR/$VDOMAIN/prefs
   touch $VADMIN_DIR/$VDOMAIN/passwd
   touch $VADMIN_DIR/$VDOMAIN/pic
   chown $HTTPD_USER:$HTTPD_GROUP $VADMIN_DIR/$VDOMAIN/*
   touch $VADMIN_DIR/$VDOMAIN/admins
   echo "done"
   if test $PROMPTLOWLY = "y"; then
    echo -n "Edit lowly admins for this domain? [y]/n: "
    read REPLY
    if test ! $REPLY; then REPLY="y"; fi
    if test $REPLY = "y"; then
     ./admined.sh $VDOMAIN
    fi
   fi
  fi
 fi
done
for VDOMAIN in `ls $VADMIN_DIR`; do
 if test $VDOMAIN != "cross-admins"; then
  if ! egrep "^$VDOMAIN:" $VDOMAINS_FILE > /dev/null 2>&1; then
   echo "Domain $VDOMAIN is configured with VADMIN, but is no longer in the system."
   ./vdeldomain.sh $VDOMAIN
  fi
 fi
done

if test $DOMAINS_FOUND; then
 echo "Finished processing domains."
else
 echo "No new domains found."
fi

