#!/bin/sh

if test `id -u` != 0; then 
 echo "Error: Must be root!"
 exit 1
fi

if test ! -f $HOME/.vadmin; then
 cat screens/dot-admin_missing.txt
 exit 1
fi

. $HOME/.vadmin

echo "Checking your Vadmin directory for missing files or odd permissions..."
for VDOMAIN in `ls $VADMIN_DIR`; do
 if test $VDOMAIN != "cross-admins"; then
  echo -n "Analyzing $VDOMAIN..."
  if test ! -f $VADMIN_DIR/$VDOMAIN/admins; then
   echo -n "created missing admins..."
   touch $VADMIN_DIR/$VDOMAIN/admins
  else 
   if test ! -O $VADMIN_DIR/$VDOMAIN/admins; then
    echo 
    echo "***** WARNING: *****"
    echo "File $VADMIN_DIR/$VDOMAIN/admins"
    echo "was NOT owned by root! Please be aware of this."
    echo -n "Setting ownership to root..."
    chown 0 $VADMIN_DIR/$VDOMAIN/admins
    echo "done"
   fi
   if test ! -G $VADMIN_DIR/$VDOMAIN/admins; then
    echo
    echo "***** WARNING: *****"
    echo "File $VADMIN_DIR/$VDOMAIN/admins"
    echo "had incorrect GID setting. Please be aware of this."
    echo -n "Setting GID to correct setting..."
    chgrp 0 $VADMIN_DIR/$VDOMAIN/admins
    echo "done"
   fi
  fi
  for I in `echo 'passwd pic prefs'`; do
   if test ! -f $VADMIN_DIR/$VDOMAIN/$I; then
    echo -n " created missing $I..."
    touch $VADMIN_DIR/$VDOMAIN/$I
    chown $HTTPD_USER:$HTTPD_GROUP $VADMIN_DIR/$VDOMAIN/$I
   else
    if ! su $HTTPD_USER -c "test -O $VADMIN_DIR/$VDOMAIN/$I"; then
     echo -n "setting correct UID on $I..."
     chown $HTTPD_USER $VADMIN_DIR/$VDOMAIN/$I
    fi
    if ! su $HTTPD_USER -c "test -G $VADMIN_DIR/$VDOMAIN/$I"; then
     echo -n "setting correct GID on $I..."
     chgrp $HTTPD_GROUP $VADMIN_DIR/$VDOMAIN/$I
    fi
   fi
  done
  echo "done"
 fi
done
