#!/bin/sh

if test `id -u` != 0; then 
 echo "Error: Must be root!"
 exit 1
fi

if test ! $1; then
 echo "Usage: admined.sh domainname.com"
 exit 1
fi

if test ! -f $HOME/.vadmin; then
 echo "Can't find $HOME/.vadmin. Run installer.sh or mkdot-vadmin.sh"
 exit 1
fi
. $HOME/.vadmin
VDOMAIN=$1

if test ! -d $VADMIN_DIR/$VDOMAIN; then
 echo "Error: Domain $VDOMAIN is not configured with VADMIN"
 exit 1
fi

if test ! $EDITOR; then EDITOR="vi"; fi
$EDITOR $VADMIN_DIR/$VDOMAIN/admins

