<?php
/**
 * vadmin_fetch_pic.php
 * ---------------------
 * Fetches a custom picture for each domain. If QUERY_STRING
 * is not set, it tries to determine which domain it is by 
 * looking at the access URI. The images are pulled from the
 * pic file in $VADMIN_DIR/domain directory.
 *
 * Licensed under GNU GPL v2. Please see COPYING for full terms.
 *
 * $Id: vadmin_fetch_pic.php,v 1.4 2003/07/07 01:07:16 graf25 Exp $
 *
 * @author Konstantin Riabitsev ($Author: graf25 $)
 * @version $Date: 2003/07/07 01:07:16 $
 */

/**
 * Load the config parser before we chdir.
 */
require_once('config_parser.php');

$config_file = 'conf/vadmin.conf';
$vadmin_config = vadmin_parse_config($config_file);

/**
 * Load main functions.
 */
$include_dir = $vadmin_config{'paths'}{'includes'};
require_once($include_dir . '/vadmin_functions.inc');
$GLOBALS{'VADMIN_CONFIG'} = $vadmin_config;

/**
 * See what setting is storage.type set to and load the needed
 * file. This is the only place where error checking is implemented
 * since many different storage types are possible.
 */
$storage_type = vadmin_getvar('CONFIG', 'storage.type');
$storage_functions_file = sprintf('%s/%s_functions.inc', 
                                  $include_dir, $storage_type);
if (file_exists($storage_functions_file) 
    && is_readable($storage_functions_file)){
    require_once($storage_functions_file);
} else {
    spew("$me: FATAL: could not load the storage functions file!");
    vadmin_system_error(sprintf(
        _("Could not load function file for storage type %s"), $storage_type));
}

$domain = vadmin_getvar('GET', 'DOM');
if ($domain == ''){
    /**
     * Load the standard SquirrelMail logo 
     */
    header('Content-type: image/png');
    readfile('../../images/sm_logo.png');
    exit;
}

$contents = vadmin_get_pic($domain);

if ($contents == false){
    /**
     * Load the standard SquirrelMail logo 
     */
    header('Content-type: image/png');
    readfile('../../images/sm_logo.png');
    exit;
} else {
    $mimetype = vadmin_get_pref($domain, 'mimetype');
    header('Pragma: no-cache');
    header('Content-type: ' . $mimetype);
    echo $contents;
}
?>
