<?php
/**
 * autores.mod
 * ------------
 * This module lets users set autoresponders.
 *
 * Licensed under GNU GPL v2. Please see COPYING for full terms.
 *
 * $Id: autores.mod,v 1.3 2003/06/16 04:22:13 graf25 Exp $
 * 
 * @author Konstantin Riabitsev ($Author: graf25 $)
 * @version $Date: 2003/06/16 04:22:13 $
 */

$ACT = vadmin_getvar('VADMIN', 'ACT');
$LVL = vadmin_getvar('VADMIN', 'LVL');
$MOD = 'autores';
$me = "$MOD.mod/$ACT";
spew("$me: taking over");

$domain = vadmin_getdomain();
$username = vadmin_getvar('SQMAIL', 'username');
spew("$me: making sure they are in the same domain");
list($uname, $udomain) = vadmin_get_user_unamedomain($username);
if ($udomain != $domain){
    spew("$me: You're not supposed to be here! Bad boy!");
    vadmin_security_breach();
}

$color = vadmin_getvar('SQMAIL', 'color');
$secret = vadmin_get_domain_passwd($domain);
$title = _("Your autoresponder settings");

switch ($ACT){
    /******************************* main *******************************/    
 case 'main':
     list($code, $stat) = vautoresponsestatus($domain, $secret, $uname);
     if ($stat == 'enabled'){
         $action = vadmin_mkform_action($LVL, $MOD, 'remove');
         $repl = vreadautoresponse($domain, $secret, $uname);
         $message = nl2br(htmlspecialchars($repl[1]));
         $show = ''
             . '<tr>'
             . ' <th bgcolor="' . $color[9] . '">'
             .    _("Your autoresponder is enabled")
             . ' </th>'
             . '</tr>'
             . '<tr>'
             . ' <td>'
             . '  <p><strong>' . _("Your message") . ':</strong><br />'
             .     $message
             . '  </p>'
             . ' </td>'
             . '</tr>'
             . '<tr>'
             . ' <td bgcolor="' . $color[9] . '" align="center">'
             . '  <input type="submit" '
             . '    value="' . _("Disable autoresponder") . '" />'
             . ' </td>'
             . '</tr>';
     } else {
         $action = vadmin_mkform_action($LVL, $MOD, 'set');
         $repl = vreadautoresponse($domain, $secret, $uname);
         if ($repl[0] == 0){
             $message = htmlspecialchars($repl[1]);
         } else {
             $message = _("I am currently away from my email. I will respond to your message when I return.");
         }
         $show = ''
             . '<tr>'
             . ' <th bgcolor="' . $color[9] . '">'
                  . _("Your autoresponder is not enabled")
             . ' </th>'
             . '</tr>'
             . '<tr>'
             . ' <td>'
             . '  <p><strong>' . _("Your message") . ':</strong><br />'
             . '   <textarea name="message" cols="70" rows="10" '
             . '    wrap="hard">' . $message . '</textarea>'
             . '  </p>'
             . ' </td>'
             . '</tr>'
             . '<tr>'
             . ' <td bgcolor="' . $color[9] . '" align="center">'
             . '  <input type="submit" '
             . '   value="' . _("Enable autoresponder") . '" />'
             . ' </td>'
             . '</tr>';
     }
     $body = ''
         . '<form method="post" action="' . $action . '">'
         . ' <table border="0" width="70%" align="center">'
         .    $show
         . ' </table>'
         . '</form>';
     vadmin_make_page($title, null, $body, false, false);
     break;

     /******************************* set ****************************/
 case 'set':
     /**
      * Get the message directly from $_POST as opposed to vadmin_getvar
      * so we don't have automatic anti-xss, which doesn't look so good in
      * an email message.
      */
     $message = $_POST{'message'};
     if ($message == ''){
         vadmin_user_error(_("Please provide an autoresponse message. It cannot be an empty string."));
     }
     list($code, $stat) = vautoresponsestatus($domain, $secret, $uname);
     if ($stat == 'disabled'){
         $repl = venableautoresponse($domain, $secret, $uname);
         if ($repl[0]){
             vadmin_system_error($repl[1]);
         }
     }
     $repl = vwriteautoresponse($domain, $secret, $uname, $message);
     if ($repl[0]){
         vadmin_system_error($repl[1]);
     }
     if ($stat == 'nonexistant'){
         $repl = venableautoresponse($domain, $secret, $uname);
         if ($repl[0]){
             vadmin_system_error($repl[1]);
         }
     }         
     /**
      * Redirect back to main
      */
     vadmin_redirect($LVL, $MOD, 'main', null);
     break;

     /******************************* remove **************************/
 case 'remove':
     $repl = vdisableautoresponse($domain, $secret, $uname);
     if ($repl[0]){
         vadmin_system_error($repl[1]);
     }
     /**
      * Redirect back to main
      */
     vadmin_redirect($LVL, $MOD, 'main', null);
     break;

   /******************************* default ***************************/
 default:
     vadmin_system_error(
         sprintf(_("Invalid request, handler for '%s' does not exist"), $ACT));
     break;
}

/**
 * For emacs weenies among us:
 * Local variables:
 * mode: php
 * End:
 */
?>
