<?php
/**
 * accounts.mod
 * ------------
 * This file takes care of user accounts and aliases.
 *
 * Licensed under GNU GPL v2. Please see COPYING for full terms.
 *
 * $Id: accounts.mod,v 1.18 2003/06/16 04:17:24 graf25 Exp $
 * 
 * @author Konstantin Riabitsev ($Author: graf25 $)
 * @version $Date: 2003/06/16 04:17:24 $
 */

/**
 * This is the only function not in the common include file. It generates
 * a nice output so I don't have to do it over and over again. It only
 * takes one param, but modifies several global values. 
 *
 * @param $command the name of parameter that was modified.
 * @return         void.
 */
function vadmin_report_progress($command){
    $me = 'vadmin_report_progress';
    /**
     * Dirty little bastard, that's what I am. :(
     */
    global $changes, $body, $errormsg, $successmsg, $color;
    
    /** 
     * Make pretty alternating rows.
     */
    if ($changes/2 != intval($changes/2)){
        $body .= '<tr bgcolor="' . $color[0] . '">';
    } else{
        $body .= '<tr>';
    }
    $body .= '<th>' . $command . ':</th><td>';
    spew("$me: reporting progress of '$command'");
    if ($errormsg){
        spew("$me: reporting an error: $errormsg");
        $body .= '<strong>' . _("Error:") . '</strong> ' . $errormsg
            . '</td></tr>';
    } else {
        spew("$me: reporting a success: $successmsg");
        $body .= '<strong>' . _("Success:") . '</strong> '
            . $successmsg . '</td></tr>';
    }
    $changes++;
    $errormsg = '';
    $successmsg = '';
}

function vadmin_get_edit_perms($domain, $myname, $mydesig, $username){
    $me = 'vadmin_get_edit_perms';
    if ($mydesig == 'ELVIS'){
        spew("$me: ELVIS can edit anyone");
        return true;
    }
    spew("$me: checking if this is an admin of any sort");
    $udesig = vadmin_get_user_designation($domain, $username);
    spew("$me: udesig is '$udesig'");
    if ($udesig == 'NONER'){
        spew("$me: everyone can edit 'NONER'");
        return true;
    }
    if ($myname == $username){
        /**
         * They can edit themselves all they want
         */
        return true;
    }
    spew("$me: mydesig is '$mydesig'");
    if ($mydesig == 'LOWLY'){
        /**
         * Lowly admin cannot edit any other admins besides themselves.
         */
        return false;
    } elseif ($mydesig == 'CROSS'){
        /**
         * CROSS can only edit LOWLY
         */
        if ($udesig == 'LOWLY'){
            return true;
        }
    }
    return false;
}

$ACT = vadmin_getvar('VADMIN', 'ACT');
$LVL = vadmin_getvar('VADMIN', 'LVL');
$MOD = 'accounts';
$me = "$MOD.mod/$ACT";
spew("$me: taking over");

$domain   = vadmin_getvar('VADMIN',  'VADMIN_DOMAIN');
$crypto   = vadmin_getvar('SESSION', 'VADMIN_SECRET');
$secret   = vadmin_crypto($crypto, 'decrypt');
$color    = vadmin_getvar('SQMAIL', 'color');
$username = vadmin_getvar('SQMAIL', 'username');
$desig    = vadmin_get_user_designation($domain, $username);

switch ($ACT){
    /***************************** listall *****************************/
 case 'listall':
     spew("$me: Calling listdomain");
     $userbunch = listdomain($domain, $secret);
     spew("$me: Total users in this domain: " . sizeof($userbunch));
     $body = ''
         . '<table border="0" align="center" width="95%">'
         . ' <tr bgcolor="' . $color[9] . '">'
         . '  <th>' . _("Username/Alias") . '</th>'
         . '  <th>' . _("Personal Info") . '</th>'
         . '  <th>' . _("Mailbox") . '</th>'
         . '  <th>' . _("Forwards") . '</th>'
         . ' </tr>';
     spew("$me: Checking if this is a CROSS or ELVIS to show admin info");
     $show_admin = false;
     if ($desig == 'CROSS' || $desig == 'ELVIS'){
         $show_admin = true;
         $lowly_ary = vadmin_get_lowly_array($domain);
     }

     /**
      * Sort them alphabetically. This could be a performance hit, but
      * it's a nice trade-off for sanity.
      */
     spew("$me: sorting usernames...");
     sort($userbunch);
     reset($userbunch);
     $flip = true;
     foreach ($userbunch as $userarray){
         if ($flip = !$flip){
             $body .= '<tr bgcolor="' . $color[0] .'">';
         } else {
             $body .= '<tr>';
         }
         $userid = $userarray[0];
         if ($userid == '+'){
             $userid = '*@' . $domain;
             $usertitle = $userid;
             spew("$me: catchall (+) account found. Changed to '$userid'");
         } else {
             $usertitle = "$userid@$domain";
         }
         $can_edit = vadmin_get_edit_perms($domain, $username, $desig,
                                           $usertitle);
         $link = vadmin_mkform_action($LVL, $MOD, 'getuser');
         if ($show_admin == true){
             if (in_array($usertitle, $lowly_ary)){
                 $userid = sprintf(_("%s (admin)"), $userid);
                 spew("$me: $userid is a lowly admin");
             }
         }
         if ($can_edit == true){
             $body .= ''
                 . '<td>'
                 . ' <a href="' . $link . '&amp;userid=' 
                 . urlencode($userarray[0]) . '">' . $userid . '</a>'
                 . '</td>';
         } else {
             $body .= '<td>' . $userid . '</td>';
         }
         $body .= ''
             . '<td>' . $userarray[4] . '&nbsp;</td>'
             . '<td>' . $userarray[2] . '&nbsp;</td>'
             . '<td>';

         if (sizeof($userarray[3])){
             $body .= htmlspecialchars(join(', ', $userarray[3]));
         } else {
             $body .= '&nbsp;';
         }
         $body .= '</td></tr>';
     }
     $body .= ''
         . ' <tr bgcolor="' . $color[9] . '">'
         . '  <th colspan="4">' . _("End of listing") . '</th>'
         . ' </tr>'
         . '</table>';
     $title = sprintf(_("User listing for %s"), $domain);
     vadmin_make_page($title, null, $body, true, true);
     break;

     /******************************** getuser ***************************/
 case 'getuser':
     /**
      * See if this user really exists
      */
     spew("$me: checking if such user exists");
     $userid = vadmin_getvar('GET', 'userid');
     if (!$userid){
         $userid = vadmin_getvar('POST', 'userid');
     }
     $usertitle = "$userid@$domain";
     $command = array('lookup', $domain, $userid, $secret);
     $tmp = vm_daemon_raw($command);
     if ($tmp[0]){
         spew("$me: no such user or alias '$userid'");
         $msg = sprintf(_("No such user or alias exists: %s"), $userid);
         vadmin_user_error($msg);
     }
   
     /**
      * Make sure they can edit this user.
      */
     if (!vadmin_get_edit_perms($domain, $username, $desig, $usertitle)){
         spew("$me: ai-ai-ai, they can't edit this user.");
         $msg = sprintf(_("You don't have permissions to edit user '%s'"), 
                          $userid);
         vadmin_user_error($msg);
     }

     /**
      * Call lookup(), a function provided by vmail.inc.
      */
     spew("$me: fetching the user data");
     $user_ary = listdomain_parse_userdata($tmp[1], $userid);

     /**
      * Since it doesn't return the password, change the "Set" into
      * "encrypted" to make it more obvious to the end-user.
      */
     if ($user_ary[1] != 'Set'){
         spew("$me: password is not set for this user");
         $setpass = "-"; 
     } else {
         spew("$me: changing password to 'encrypted' for clarity");
         $setpass = _("encrypted");
     }
   
     /**
      * Process and organize the rest of the data.
      */
     $mailbox = $user_ary[2];
     spew("$me: mailbox is '$mailbox'");
     
     if (is_array($user_ary[3])){
         $aliases = join(', ', $user_ary[3]);
     } else {
         $aliases = '';
     }
     spew("$me: aliases is '$aliases'");
   
     $personal_info = $user_ary[4];
     spew("$me: personal_info is '$personal_info'");
   
     $hard_quota = $user_ary[5];
     $soft_quota = $user_ary[6];
     $size_limit = $user_ary[7];
     if ($hard_quota != '-'){
         $hard_quota = intval($hard_quota/1024/1024);
     }
     if ($soft_quota != '-'){
         $soft_quota = intval($soft_quota/1024/1024);
     }
     if ($size_limit != '-'){
         $size_limit = intval($size_limit/1024/1024);
     }
     spew("$me: hard_quota is '$hard_quota'");
     spew("$me: soft_quota is '$soft_quota'");
     spew("$me: size_limit is '$size_limit'");
   
     $count_limit = $user_ary[8];
     $creation_time = $user_ary[9];
     spew("$me: count_limit is '$count_limit'");
     spew("$me: creation_time is '$creation_time'");
   
     $expiry_time = $user_ary[10];
     if ($expiry_time != '-'){
         /**
          * Convert into days from seconds.
          */
         $expiry_time = intval($expiry_time/86400);
     }
     spew("$me: expiry_time is '$expiry_time'");
     
     if ($userid == '+'){
         $usertitle = _("a 'catchall' account");
     } else {
         $usertitle = sprintf('%s@%s', $userid, $VADMIN_DOMAIN);
     }
     spew("$me: usertitle is '$usertitle'");
     $title = sprintf(_("Listing for <em>%s</em>, created on <em>%s</em>"),
                      $usertitle, date("M-d-Y", $creation_time));
   
     $action = vadmin_mkform_action($LVL, $MOD, 'chattrs');
     $body = ''
         . '<form method="post" action="' . $action . '">'
         . ' <input type="hidden" name="userid" value="' . $userid . '">'
         . '  <table border="0" width="80%" align="center">'
         . '   <tr>'
         . '    <th bgcolor="' . $color[9] . '" colspan="2">'
         .       _("Change user attributes")
         . '    </th>'
         . '   </tr>'
         . '   <tr>'
         . '    <td>'
         .       _("Personal Info") .' (<a href="#personalinfo">?</a>): '
         . '     <input name="personal_info" value="' . $personal_info . '" />'
         . '    </td>'
         . '    <td>'
         .       _("Hard Quota") . ' (<a href="#hardquota">?</a>): '
         . '     <input name="hard_quota" size="10" value="'
         .        $hard_quota . '" /> ' . _("MBytes")
         . '    </td>'
         . '   </tr>'
         . '   <tr>'
         . '    <td>'
         .       _("Mailbox") . ' (<a href="#mailbox">?</a>): '
         . '     <input name="vmailbox" value="' . $mailbox . '" />'
         . '    </td>'
         . '    <td>'
         .       _("Soft Quota") . ' (<a href="#softquota">?</a>): '
         . '     <input name="soft_quota" size="10" value="' 
         .       $soft_quota . '" /> ' . _("MBytes")
         . '    </td>'
         . '   </tr>'
         . '   <tr>'
         . '    <td>'
         .       _("Set Password") . ' (<a href="#password">?</a>): '
         . '     <input size="10" name="vpassword" value="' . $setpass . '" '
         . '      onfocus="if (this.value==\"' . _("encrypted") . '\") '
         . '      this.value=\"\";" />'
         . '    </td>'
         . '    <td>'
         .       _("Size Limit") . ' (<a href="#sizelimit">?</a>): '
         . '     <input name="size_limit" size="10" value="' 
         .        $size_limit . '" />' . _("MBytes")
         . '    </td>'
         . '   </tr>'
         . '   <tr>'
         . '    <td>'
         .       _("Expiry Time") . ' (<a href="#expirytime">?</a>): '
         . '     <input name="expiry_time" size="10" value="' 
         .        $expiry_time . '" />' . _("days")
         . '    </td>'
         . '    <td>'
         .       _("Count Limit") . ' (<a href="#countlimit">?</a>): '
         . '     <input name="count_limit" size="10" value="' 
         .        $count_limit . '" />' . _("msgs")
         . '    </td>'
         . '</tr>';
     spew("$me: checking if we should display admin information");
     if ($desig == 'CROSS' || $desig == 'ELVIS'){
         $udesig = vadmin_get_user_designation($domain, $usertitle);
         $ison = '';
         if ($udesig == 'LOWLY'){
             $ison = ' checked="yes"';
         }
         $body .= ''
             . '<tr>'
             . ' <td colspan="2" align="center">'
             . '  <input type="checkbox" name="admin" value="1"' 
             .     $ison . ' />' . _("Can administer this domain")
             . ' </td>'
             . '</tr>';
     }
     $body .= ''
         . '<tr>'
         . ' <th colspan="2" bgcolor="' . $color[9] . '">'
         .     _("Forwards") . ' (<a href="#forwards">?</a>): '
         . '   /' . _("separate by commas") . '/'
         . ' </th>'
         . '</tr>'
         . '<tr>'
         . ' <td colspan="2" align="center">'
         . '  <textarea name="valiases" cols="60" rows="2">' . $aliases 
         .    '</textarea>'
         . ' </td>'
         . '</tr>'
         . '<tr>'
         . ' <th bgcolor="' . $color[9] . '" colspan="2">'
         . '  <input type="submit" value="' . _("Make these changes") 
         .     '&gt;&gt;" />'
         . ' </th>'
         . '</tr>'
         . '</table></form>';
     if ($username != $usertitle){
         spew("$me: creating a 'delte this user' button");
         $action = vadmin_mkform_action($LVL, $MOD, 'deluser');
         $body .= ''
             . '<hr />'
             . '<form method="post" action="' . $action . '">'
             . ' <input type="hidden" name="userid" value="' . $userid . '" />'
             . ' <table border="0" width="80%" align="center">'
             . '  <tr>'
             . '   <th bgcolor="' . $color[9] . '"> ' 
             .      _("Delete this account") 
             . '   </th>'
             . '  </tr>'
             . '  <tr>'
             . '   <td align="center">'
             . '    <p style="width: 90%; text-align: left">'
             .       _("Click here if you wish to delete this account. This will also delete any and all user files associated with it -- mailbox files, SquirrelMail preferences, etc.")
             . '    </p>'
             . '   </td>'
             . '  </tr>'
             . '  <tr>'
             . '   <th bgcolor="' . $color[9] . '">'
             . '    <input type="submit" value="' . _("Delete this account") 
             .       ' &gt;&gt;" /> '
             . '   </th>'
             . '  </tr>'
             . ' </table>'
             . '</form>';
     }
     /**
      * Provide some documentation, explaining which field does what.
      * So much pain. For translators, too.
      */
     spew("$me: writing a cheat-sheet");
     $body .= ''
         . '<hr />'
         . '<table border="0" width="80%" align="center">'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '">' 
         .     _("Description of fields")
         . '  </th>'
         . ' </tr>'
         . ' <tr>'
         . '  <td>'
         . '   <p><strong><a name="personalinfo">' . _("Personal Info") . '.'
         . '    </a></strong> '
         .      _("This is where you put full name of this user or some other information to help you better identify your users and aliases.") . '</p>'
         . '   <p><strong><a name="mailbox">' . _("Mailbox") . '.</a></strong>'
         .       _("This is a Maildir-format style mailbox. If you wish to change this user to an alias without a mailbox, then you will need to leave this setting blank. Please don't change setting unless you know what you are doing, as this can prevent users from accessing their mailboxes.") . '</p>'
         . '   <p><strong><a name="password">' . _("Set Password") . '.'
         . '    </a></strong> '
         .      _("Since users' passwords are encrypted, it is impossible to see what it is in this listing. Leave it saying 'encrypted' or blank to keep the old value, or type in a new value to change this user's mailbox access password.") . '<br />'
         . _("A '-' means that password for this user is not set.") . '</p>'
         . '   <p><strong><a name="expirytime">' . _("Expiry Time") . '.'
         . '    </a></strong> '
         .      _("If you want to limit the availability of this mailbox by some amount of time, put in the number of days this box should be active.") . '<br />'
         .      _("A '-' means there is no time limit on this box.") . '</p>'
         . '   <p><strong><a name="hardquota">' . _("Hard Quota") . '.'
         . '    </a></strong> '
         .       _("The absolute limit of how many kilobytes this user may have in his or her mailbox. If this limit is ever reached, the system will not accept any more messages for this user.") . '<br />'
         .       _("A '-' means unlimited storage space.") . '</p>'
         . '   <p><strong><a name="softquota">' . _("Soft Quota") . '.'
         . '    </a></strong> '
         .      _("This sets the size of user's mailbox in kilobytes. If this level is reached, the user is notified that his or her mailbox is at its limits and should be cleaned. The system will still accept messages until Hard Quota limit is reached. Soft Quota should be less than Hard Quota.") . '<br />'
         .      _("A '-' means no limits are set on this user's mailbox.")
         . '   </p>'
         . '   <p><strong><a name="sizelimit">' . _("Size Limit") . '.'
         . '    </a></strong> '
         .      _("This limits the maximum size of any one message that this user is trying to receive in kilobytes. If a message arrives which is larger than the limit specified here, then it will be discarded.") . '<br />'
         .      _("A '-' means no limits on message sizes.") . '</p>'
         . '   <p><strong><a name="countlimit">' . _("Count Limit") . '.'
         . '    </a></strong> '
         .      _("This limits how many messages a user can have in his or her mailbox. If more messages accumulate than the amount allows, any incoming messages will be discarded until the user cleans the mailbox.") . '<br />'
         .      _("A '-' means no limits.") . '</p>'
         . '   <p><strong><a name="forwards">' . _("Forwards") . '.'
         . '    </a></strong> '
         .      _("This specifies the forwarding addresses for this user or alias. You may put in as  many as you want, separating them by commas (comma-space is OK). Leave blank if you don't want to forward any copies.") . '</p>'
         . '  </td>'
         . ' </tr>'
         . '</table>';
     vadmin_make_page($title, null, $body, true, true);
     break;

     /***************************** chattrs ***************************/
 case 'chattrs':
     /**
      * Get values passed via the form, POST.
      */
     spew("$me: getting the values passed via POST");
     $userid        = vadmin_getvar('POST', 'userid');
     $usertitle     = "$userid@$domain";
     if (!vadmin_get_edit_perms($domain, $username, $desig, $usertitle)){
         spew("$me: ai-ai-ai, they can't edit this user.");
         $msg = sprintf(_("You don't have permissions to edit user '%s'"), 
                          $userid);
         vadmin_user_error($msg);
     }

     $vpassword     = vadmin_getvar('POST', 'vpassword');
     $personal_info = vadmin_getvar('POST', 'personal_info');
     $hard_quota    = vadmin_getvar('POST', 'hard_quota');
     $vmailbox      = vadmin_getvar('POST', 'vmailbox');
     $soft_quota    = vadmin_getvar('POST', 'soft_quota');
     $size_limit    = vadmin_getvar('POST', 'size_limit');
     $expiry_time   = vadmin_getvar('POST', 'expiry_time');
     $count_limit   = vadmin_getvar('POST', 'count_limit');
     $valiases      = vadmin_getvar('POST', 'valiases');
     $admin         = vadmin_getvar('POST', 'admin');

     /**
      * lookup() is a function from vmail.inc by vmailmgr.
      */
     spew("$me: looking up current user settings");
     $user_ary = lookup($domain, $userid, $secret);

     /**
      * Generate table header.
      */
     $body = ''
         . '<table border="0" width="80%" align="center">'
         . ' <tr bgcolor="' . $color[9] . '">'
         . '  <th>' . _("Command") . '</th>'
         . '  <th>' . _("Execution result") . '</th>'
         . ' </tr>';

     /**
      * This var tracks how many changes were done to the
      * user settings.
      */
     $changes = 0;

     /**
      * Set administrator privs, but only if this is CROSS or ELVIS
      */
     if ($desig == 'CROSS' || $desig == 'ELVIS'){
         $achange = false;
         $handle = "$userid@$domain";
         spew("$me: check if $userid is currently a lowly admin");
         $lowly_ary = vadmin_get_lowly_array($domain);
         if (in_array($handle, $lowly_ary)){
             spew("$me: Yes, this is currently an admin");
             if (!isset($admin)){
                 spew("$me: Removing admin privs from $handle");
                 $new_ary = array();
                 foreach ($lowly_ary as $eadmin){
                     if ($handle != $eadmin){
                         spew("$me: keeping $eadmin");
                         array_push($new_ary, $eadmin);
                     }
                 }
                 $lowly_ary = $new_ary;
                 $achange = true;
             }
         } else {
             spew("$me: No, this is currently not an admin");
             if (isset($admin) && $admin == '1'){
                 spew("$me: granting $userid lowly admin privs");
                 array_push($lowly_ary, $handle);
                 $achange = true;
             }
         }
         if ($achange == true){
             vadmin_put_lowly_array($domain, $lowly_ary);
             $successmsg = _("Marked as administrator");
             vadmin_report_progress(_("Setting administrator privileges"));
         }
     }

     /**
      * Analyze the password. If it's "encrypted" or empty, then no
      * change is requested. If the new value is "-", then they have
      * requested to remove the password, but it's not currently supported. 
      */
     spew("$me: analyzing password request if any");
     if ($user_ary[1] != "Set"){
         $user_ary[1] = "-";
     }
     if ($vpassword != _("encrypted") && $vpassword != ""){
         if ($vpassword != $user_ary[1]){
             /**
              * New password provided. 
              */
             spew("$me: so, they want to change the password");
             if ($vpassword == "-"){
                 /**
                  * They want to remove the password.
                  * Somehow, this feature is not in the current vmail.inc
                  * Disabling until it appears, since it IS in the console
                  * scripts.
                  *
                  * $repl=vchattr($VADMIN_DOMAIN, $secret, $userid, "PASS","");
                  * if ($repl[0]) $errormsg = $repl[1];
                  */
                 spew("$me: Bzzt! Can't make a passwordless account atm.");
                 $errormsg = _("This is currently not working due to a bug in include files provided by vmailmgr.");
             } else {
                 /**
                  * Set a new password.
                  * Do some simple checks.
                  */
                 if (!preg_match("/[\w_]/si", $vpassword)){
                     spew("$me: spaces in the password are bad, m'kay?");
                     $errormsg = _("Invalid characters in password. Passwords can only contain latin characters, numbers, and underscores.");
                 } else {
                     /**
                      * Call the vchpass function, provided by vmail.inc.
                      */
                     spew("$me: calling vchpass");
                     $repl = vchpass($VADMIN_DOMAIN, $secret, $userid, 
                                     $vpassword);
                     if ($repl[0]){
                         spew("$me: error reported: " . $repl[1]);
                         $errormsg = $repl[1];
                     } else {
                         spew("$me: password changed successfully");
                         $successmsg = _("The password has been changed.");
                     }
                 }
             }
             vadmin_report_progress(_("Changing Password"));
         }
     }

     /**
      * See if changes to the mailbox are requested.
      */
     spew("$me: analyzing mailbox change requests if any");
     if ($vmailbox != $user_ary[2]){
         spew("$me: Check against the limits");
         $proceed = true;
         if ($user_ary[2] == ''){
             $mailbox_limit = vadmin_smart_limit($domain, $desig, 'mailboxes');
             if ($mailbox_limit != false){
                 $mboxes = vadmin_get_user_number($domain);
                 if ($mboxes >= $mailbox_limit){
                     spew("$me: cute, but I've thought of this. :)");
                     $errormsg = 'Mailbox limit reached. Ignored.';
                     $proceed = false;
                 }
             }
         }
         if ($proceed == true){
             /**
              * Change the destination of the mailbox. Call the
              * vchattr() function provided by vmail.inc.
              */
             spew("$me: calling vchattr");
             $repl = vchattr($domain, $secret, $userid, "DEST", $vmailbox);
             if ($repl[0]){
                 spew("$me: error returned: " . $repl[1]);
                 $errormsg = $repl[1];
             } else {
                 $successmsg = sprintf(_("Changed to '%s'"), $vmailbox);
             }
         }
         vadmin_report_progress(_("Changing Mailbox"));
     }
     
     /**
      * Prepare the aliases by collapsing them into a string. This allows us
      * to comare the new values with the old ones.
      */
     spew("$me: analyzing aliases");
     if (is_array($user_ary[3])){
         $aliases = join(", ", $user_ary[3]);
     } else { 
         $aliases = "";
     }
     spew("$me: aliases is: $aliases");
     spew("$me: valiases is: $valiases");
     
     if ($valiases != $aliases){
         /**
          * Change forwards to a new value.
          */
         if (strlen($valiases)){
             $forwards = split(",", $valiases);
             /**
              * Trim the values to avoid issues with spaces
              */
             @array_walk($forwards, 'vadmin_trim_array');
         } else {
             $forwards = array();
         }
         spew("$me: total size of forwads is: " . sizeof($forwards));
         /**
          * Call the vchforward function provided by vmail.inc.
          */
         spew("$me: calling vchforward");
         $repl = vchforward($VADMIN_DOMAIN, $secret, $userid, $forwards);
         if ($repl[0]){
             spew("$me: error returned: " . $repl[1]);
             $errormsg = $repl[1]; 
         } else {
             $successmsg = sprintf(_("Updated to '%s'"), $valiases);
         }
         vadmin_report_progress(_("Changing Aliases"));
     }
     
     /**
      * Analyze if changes requested to the personal info.
      */
     spew("$me: analyzing changes to personal info if any");
     if ($personal_info != $user_ary[4]){
         /**
          * Call vchattr(), a vmail.inc function.
          */
         spew("$me: calling vchattr");
         $repl = vchattr($VADMIN_DOMAIN, $secret, $userid, 'PERSONAL',
                         $personal_info);
         if ($repl[0]){
             spew("$me: error returned: " . $repl[1]);
             $errormsg = $repl[1]; 
         } else{
             $successmsg = sprintf(_("Updated to '%s'"), $personal_info);
         }
         vadmin_report_progress(_("Changing Personal Info"));
     }
     
     /**
      * Analyze Hard Quota changes.
      * If the setting was changed to "", they want to remove the setting,
      * so change it to "-".
      */
     spew("$me: analyzing hard quota change requests if any");
     if (!strlen($hard_quota)){
         $hard_quota = "-";
     }
     if ($hard_quota*1024*1024 != $user_ary[5]){
         $limit = vadmin_smart_limit($domain, $desig, 'hardquota');
         if ($hard_quota == "-"){
             if ($limit != false){
                 $errormsg = _("Unlimited quotas not permitted");
             } else {
                 /**
                  * Change hard quota to unlimited.
                  */
                 spew("$me: changing hard_quota to unlimited via vchattr");
                 $repl = vchattr($domain, $secret, $userid, 'HARDQUOTA', '-');
                 if (!$repl[0]){
                     $successmsg=_("Changed to unlimited.");
                 }
             }
         } else {
             if ($limit && $limit < $hard_quota){
                 $errormsg = sprintf(_("Quota above the limit of %d Mb"),
                                     $limit);
             } else {
                 /**
                  * Call the vchattr() function provided by vmail.inc and
                  * change the quota setting.
                  */
                 spew("$me: setting to " . $hard_quota*1024*1024);
                 $repl = vchattr($domain, $secret, $userid, 'HARDQUOTA',
                                 $hard_quota*1024*1024);
                 if (!$repl[0]){
                     $successmsg = sprintf(_("Changed to %d MBytes."), 
                                           $hard_quota);
                 }
             }
         }
         if (isset($repl) && $repl[0]){
             spew("$me: error returned: " . $repl[1]);
             $errormsg = $repl[1];
         }
         vadmin_report_progress(_("Changing Hard Quota"));
     }
     
     /**
      * Analyze Soft Quota changes requested. If the new value is "",
      * then set it to "-" for consistency with the values returned by
      * vmail.inc.
      */
     spew("$me: analyzing request for soft_quota change if any");
     if (!strlen($soft_quota)){
         $soft_quota = "-";
     }
     if ($soft_quota*1024*1024 != $user_ary[6]){
         if ($soft_quota == "-"){
             /**
              * Change to unlimited.
              */
             spew("$me: changing soft_quota to unlimited. Calling vchattr");
             $repl = vchattr($VADMIN_DOMAIN, $secret, $userid, 'SOFTQUOTA', 
                             '-');
             if (!$repl[0]){
                 $successmsg=_("Changed to unlimited.");
             }
         } else {
             spew("$me: changing soft_quota to: " . $soft_quota*1024*1024);
             $repl = vchattr($VADMIN_DOMAIN, $secret, $userid, 'SOFTQUOTA', 
                             $soft_quota*1024*1024);
             if (!$repl[0]){
                 $successmsg = sprintf(_("Changed to %d MBytes."), 
                                       $soft_quota);
             }
         }
         if ($repl[0]){
             spew("$me: error returned: " . $repl[1]);
             $errormsg = $repl[1];
         }
         vadmin_report_progress(_("Changing Soft Quota"));
     }
     
     /**
      * Analyze MessageSize Limit requests. If the value is "", change
      * it to "-".
      */
     spew("$me: analyzing message size limit requests if any");
     if (!strlen($size_limit)){
         $size_limit = "-";
     }
     if ($size_limit*1024*1024 != $user_ary[7]){
         $limit = vadmin_smart_limit($domain, $desig, 'size');
         if ($size_limit == "-"){
             if ($limit != false){
                 $errormsg = _("Unlimited message size not permitted");
             } else {
                 /**
                  * Change to unlimited.
                  */
                 spew("$me: changing size_limit to unlimited via vchattr");
                 $repl = vchattr($domain, $secret, $userid, 'MSGSIZE', '-');
                 if (!$repl[0]){
                     $successmsg = _("Changed to unlimited.");
                 }
             }
         } else {
             if ($limit && $limit < $size_limit){
                 $errormsg = sprintf(_("Size above the limit of %d Mb"), 
                                     $limit);
             } else {
                 spew("$me: changing size_limit to: " . $size_limit*1024*1024);
                 $repl = vchattr($domain, $secret, $userid, 'MSGSIZE',
                                 $size_limit*1024*1024);
                 if (!$repl[0]){
                     $successmsg = sprintf(_("Changed to %d MBytes."), 
                                           $size_limit);
                 }
             }
         }
         if (isset($repl) && $repl[0]){
             spew("$me: error returned: " . $repl[1]);
             $errormsg = $repl[1];
         }
         vadmin_report_progress(_("Changing Size Limit"));
     }
     
     /**
      * Analyze MessageCount Limit requests. Change from "" to "-" if needed.
      */
     spew("$me: analyzing message count change requests if any");
     if (!strlen($count_limit)){
         $count_limit = "-";
     }
     if ($count_limit != $user_ary[8]){
         $limit = vadmin_smart_limit($domain, $desig, 'count');
         if ($count_limit == "-"){
             if ($limit != false){
                 $errormsg = _("Unlimited message count not permitted");
             } else {
                 /**
                  * change to unlimited
                  */
                 spew("$me: changing count_limit to unlimited");
                 $repl = vchattr($domain, $secret, $userid, 'MSGCOUNT', '-');
                 if (!$repl[0]){
                     $successmsg = _("Changed to unlimited.");
                 }
             }
         } else {
             if ($limit && $limit < $count_limit){
                 $errormsg = sprintf(_("Message count above permitted %d"), 
                                     $limit);
             } else {
                 spew("$me: changing count_limit to $count_limit");
                 $repl = vchattr($domain, $secret, $userid, 'MSGCOUNT',
                                 $count_limit);
                 if (!$repl[0]){
                     $successmsg = sprintf(_("Changed to %s messages."), 
                                           $count_limit);
                 }
             }
         }
         if (isset($repl) && $repl[0]){
             spew("$me: error returned: " . $repl[1]);
             $errormsg = $repl[1];
         }
         vadmin_report_progress(_("Changing Count Limit"));
     }
     
     /**
      * Analyze the changes to the time of acct expiration. Change
      * from "" to "-" if unlimited is requested.
      */
     spew("$me: analyzing expiry time change requests if any");
     if (!strlen($expiry_time)){
         $expiry_time = "-";
     }
     if ($expiry_time != $user_ary[10]){
         if ($expiry_time == "-"){
             /**
              * change to unlimited
              */
             spew("$me: changing expiry_time to unlimited");
             $repl = vchattr($VADMIN_DOMAIN, $secret, $userid, 'EXPIRY', '-');
             if (!$repl[0]){
                 $successmsg = _("Changed to unlimited.");
             }
         } else {
             $expiry_time_sec = $expiry_time * 86400;
             spew("$me: changing expiry_time to $expiry_time_sec");
             $repl = vchattr($VADMIN_DOMAIN, $secret, $userid, 'EXPIRY',
                             $expiry_time_sec);
             if (!$repl[0]){
                 $successmsg=sprintf(_("Changed to %s days."), $expiry_time);
             }
         }
         if ($repl[0]){
             spew("$me: error returned: " . $repl[1]);
             $errormsg = $repl[1];
         }
         vadmin_report_progress(_("Changing Expiry Time"));
     }
     
     /**
      * See if any changes were made.
      */
     if ($changes){
         $body .= '<tr bgcolor="' . $color[9] . '"><th colspan="2">'
             . _("Execution completed") . '</th></tr>';
     } else {
         $body .= '<tr><td colspan="2" align="center">'
             . _("No changes requested") . '</td></tr>';
     }
     
     $body .= '</table>';
     $title = sprintf(_("Changing attributes for <em>%s</em>"), $usertitle);
     
     vadmin_make_page($title, null, $body, true, true);
     break;

     /****************************** newuser **************************/
 case 'newuser':
     $action = vadmin_mkform_action($LVL, $MOD, 'createuser');
     $body = ''
         . '<form method="post" action="' . $action . '">'
         . ' <input type="hidden" name="type" value="user" />'
         . ' <table border="0" align="center">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">' . _("Username:") . '</th>'
         . '   <td><input name="userid" /></td>'
         . '  </tr>'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">' . _("Password:") . '</th>'
         . '   <td><input name="vpassword" /></td>'
         . '  </tr>'
         . ' </table>'
         . ' <table border="0" align="center">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         .      _("[Optional] Also forward to (separate by commas):")
         . '   </th>'
         . '  </tr>'
         . '  <tr>'
         . '   <td align="center">'
         . '    <textarea name="forwards" cols="60" rows="2"></textarea>'
         . '   </td>'
         . '  </tr>'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         . '    <input type="submit" value="' . _("Create new user") 
         .       ' &gt;&gt;">'
         . '   </th>'
         . '  </tr>'
         . ' </table>'
         . '</form>';
     $title = _("Creating new user");
     vadmin_make_page($title, null, $body, true, true);
     break;

     /****************************** newalias **************************/
 case 'newalias':
     $action = vadmin_mkform_action($LVL, $MOD, 'createuser');
     $body = ''
         . '<form method="post" action="' . $action . '">'
         . ' <input type="hidden" name="type" value="alias" />'
         . ' <table border="0" align="center">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">' . _("Username:") . '</th>'
         . '   <td><input name="userid" /></td>'
         . '  </tr>'
         . ' </table>'
         . ' <table border="0" align="center">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         .      _("Forward to (separate by commas):")
         . '   </th>'
         . '  </tr>'
         . '  <tr>'
         . '   <td align="center">'
         . '    <textarea name="forwards" cols="60" rows="2"></textarea>'
         . '   </td>'
         . '  </tr>'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         . '    <input type="submit" value="' . _("Create new alias") 
         .       ' &gt;&gt;">'
         . '   </th>'
         . '  </tr>'
         . ' </table>'
         . '</form>';
     $title = _("Creating new alias");
     vadmin_make_page($title, null, $body, true, true);
     break;

     /****************************** newcatchall **************************/
 case 'newcatchall':
     $action = vadmin_mkform_action($LVL, $MOD, 'createuser');
     $body = ''
         . '<form method="post" action="' . $action . '">'
         . ' <input type="hidden" name="type" value="alias" />'
         . ' <input type="hidden" name="userid" value="+" />'
         . ' <table border="0" align="center">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         .      _("Forward to (separate by commas):")
         . '   </th>'
         . '  </tr>'
         . '  <tr>'
         . '   <td align="center">'
         . '    <textarea name="forwards" cols="60" rows="2"></textarea>'
         . '   </td>'
         . '  </tr>'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         . '    <input type="submit" value="'
         .       _("Create new 'catchall' default forward") . ' &gt;&gt;">'
         . '   </th>'
         . '  </tr>'
         . ' </table>'
         . '</form>';
     $title = _("Creating new 'catchall' account");
     vadmin_make_page($title, null, $body, true, true);
     break;

     /***************************** createuser *************************/
 case 'createuser':
     /**
      * Get form values.
      */
     $type      = vadmin_getvar('POST', 'type');
     $userid    = vadmin_getvar('POST', 'userid');
     $vpassword = vadmin_getvar('POST', 'vpassword');
     $forwards  = vadmin_getvar('POST', 'forwards');

     /**
      * Collapse forwards into array and trim so we don't have issues with
      * spaces.
      */
     if (strlen($forwards)){
         $forwards = explode(',', $forwards);
         @array_walk($forwards, 'vadmin_trim_array');
     } else {
         $forwards = array();
     }
     spew("$me: total number of forwards is: " . sizeof($forwards));

     if ($type == 'user'){
         /**
          * Call a vadduser() function by vmail.inc.
          */
         spew("$me: calling vadduser()");
         $repl = vadduser($domain, $secret, $userid, $vpassword, $forwards);
         if ($repl[0]){
             spew("$me: error returned: " . $repl[1]);
             vadmin_user_error($repl[1]);
         }
         spew("$me: taking care of domain limits.");
         $hardquota = vadmin_smart_limit($domain, $desig, 'hardquota');
         $size = vadmin_smart_limit($domain, $desig, 'size');
         $count = vadmin_smart_limit($domain, $desig, 'count');
         if ($hardquota != false){
             vchattr($domain, $secret, $userid, 'HARDQUOTA', 
                     $hardquota*1024*1024);
         }
         if ($size != false){
             vchattr($domain, $secret, $userid, 'MSGSIZE', $size*1024*1024);
         }
         if ($count != false){
             vchattr($domain, $secret, $userid, 'MSGCOUNT', $count);
         }
     } elseif ($type == 'alias'){
         /**
          * Call a vaddalias() function by vmail.inc.
          */
         spew("$me: calling vaddalias()");
         $repl = vaddalias($VADMIN_DOMAIN, $secret, $userid, "", $forwards);
         if ($repl[0]){
             spew("$me: error returned: " . $repl[1]);
             vadmin_user_error($repl[1]);
         }
     }
     $usertitle = "$userid@$VADMIN_DOMAIN";
     if ($userid == '+'){
         $usertitle = _("'catchall'");
     }
     $action = vadmin_mkform_action($LVL, $MOD, 'getuser');
     $body = ''
         . '<form method="post" action="' . $action . '">'
         . ' <input type="hidden" name="userid" value="' . $userid . '" />'
         . ' <table border="0" width="60%" align="center">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         .      sprintf(_("Account %s created"), $usertitle)
         . '   </th>'
         . '  </tr>'
         . '  <tr>'
         . '   <td>'
         .      sprintf(_("User <strong>%s</strong> has been successfully created and is ready to be used. If you would like to adjust settings for this newly created account, then please click the button below."), $usertitle)
         . '   </td>'
         . '  </tr>'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         . '    <input type="submit" value="' . _("Customize this account") 
         .       ' &gt;&gt;" />'
         . '   </th>'
         . '  </tr>'
         . ' </table>'
         . '</form>';
     $title = _("User created");
     vadmin_make_page($title, null, $body, true, true);
     break;

     /****************************** deluser **************************/
 case 'deluser':
     $userid = vadmin_getvar('POST', 'userid');
     $usertitle = "$userid@$domain";
     if (!vadmin_get_edit_perms($domain, $username, $desig, $usertitle)){
         spew("$me: ai-ai-ai, they can't edit this user.");
         $msg = sprintf(_("You don't have permissions to edit user '%s'"), 
                          $userid);
         vadmin_user_error($msg);
     }
     spew("$me: making sure they know that they are doing");
     if ($userid == "+"){
         $usertitle = _("'catchall'");
     }
     $action_cancel = vadmin_mkform_action($LVL, $MOD, 'getuser');
     $action_ok = vadmin_mkform_action($LVL, $MOD, 'deluser_yes');

     $body = ''
         . '<table border="0" width="80%" align="center">'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '" colspan="2">'
         .     _("Confirm action")
         . '  </th>'
         . ' </tr>'
         . ' <tr>'
         . '  <td align="center" colspan="2">'
         . '   <p style="width: 90%; text-align: left">'
         .      sprintf(_("<strong>WARNING:</strong> You are about to delete user or alias <strong>%s</strong>. If it's a real user, this will delete his/her mailbox including all stored messages, and clear any SquirrelMail preferences this user has. Proceed?"), $usertitle)
         . '   </p>'
         . '  </td>'
         . ' </tr>'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '">'
         . '   <form method="post" action="' . $action_cancel . '">'
         . '    <input type="hidden" name="userid" value="' . $userid . '" />'
         . '    <input type="submit" value="&lt;&lt; '._("No, cancel").'" />'
         . '   </form>'
         . '  </th>'
         . '  <th bgcolor="' . $color[9] . '">'
         . '   <form method="post" action="' . $action_ok . '">'
         . '    <input type="hidden" name="userid" value="' . $userid . '" />'
         . '    <input type="submit" value="'._("Yes, delete").' &gt;&gt;" />'
         . '   </form>'
         . '  </th>'
         . ' </tr>'
         . '</table>';
     $title = sprintf(_("About to delete account %s"), $usertitle);
     vadmin_make_page($title, null, $body, true, true);
     break;

     /*************************** deluser_yes *************************/
 case 'deluser_yes':
     $data_dir = vadmin_getvar('SQMAIL', 'data_dir');
     $userid = vadmin_getvar('POST', 'userid');
     $usertitle = "$userid@$domain";
     if (!vadmin_get_edit_perms($domain, $username, $desig, $usertitle)){
         spew("$me: ai-ai-ai, they can't edit this user.");
         $msg = sprintf(_("You don't have permissions to edit user '%s'"), 
                          $userid);
         vadmin_user_error($msg);
     }
     spew("$me: Deleting $userid fo sho.");

     /**
      * Call vdeluser() provided by vmail.inc.
      */
     spew("$me: calling vdeluser");
     $repl = vdeluser($VADMIN_DOMAIN, $secret, $userid);
     if ($repl[0]){
         spew("$me: error returned: " . $repl[1]);
         vadmin_system_error($repl[1]);
     }

     /**
      * Remove user preferences.
      */
     $fileary = array();
     $prefsfile = getHashedFile($usertitle, $data_dir, "$usertitle.pref");
     if (file_exists($prefsfile)){
         $hash_dir = dirname($prefsfile);
         if ($dh = opendir($hash_dir)){
             while (false !== ($ufile = readdir($dh))) {
                 if (strstr($ufile, $usertitle) != false){
                     spew("$me: found '$ufile'. Attempting to delete.");
                     if (unlink("$hash_dir/$ufile")){
                         spew("$me: deleted '$hash_dir/$ufile'");
                         array_push($fileary, $ufile);
                     } else {
                         spew("$me: deletion of '$hash_dir/$ufile' failed");
                     }
                 }
             }
         }
     }

     if ($userid == "+"){
         $usertitle = _("'catchall'");
     }

     $body = ''
         . '<table border="0" width="60%" align="center">'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '">'
         .     sprintf(_("Account %s deleted"), $usertitle)
         . '  </th>'
         . ' </tr>'
         . ' <tr>'
         . '  <td align="center">'
         .     sprintf(_("Account <strong>%s</strong> deleted successfully."), $usertitle);
     if (sizeof($fileary)){
         $files = join($fileary, '<br />');
         $body .= ''
             . '<p>'
             . _("The following preference files have also been deleted:") 
             . '<br />' . $files . '</p>';
     }
     $body .= ''
         . '  </td>'
         . ' </tr>'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '">&nbsp;</th>'
         . ' </tr>'
         . '</table>';
     $title = _("Deletion Results");
     vadmin_make_page($title, null, $body, true, true);
     break;

   /******************************* default ***************************/
 default:
     vadmin_system_error(
         sprintf(_("Invalid request, handler for '%s' does not exist"), $ACT));
     break;
}

/**
 * For emacs weenies among us:
 * Local variables:
 * mode: php
 * End:
 */
?>
