<?php

/**
  * SquirrelMail Vacation Local Plugin
  * Copyright (c) 2004-2005 Jonathan Bayer <jbayer@spamcop.net>,
  *                         Paul Lesneiwski <pdontthink@angrynerds.com>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage Vacation Local 
  *
  */



define('SM_PATH', '../../');



if (file_exists(SM_PATH . 'include/validate.php'))
   include_once(SM_PATH . 'include/validate.php');
else
   include_once(SM_PATH . 'src/validate.php');



bindtextdomain ('vacation_local', SM_PATH . 'locale');
textdomain ('vacation_local');



include_once(SM_PATH . 'plugins/vacation_local/config.php');



global $vac_action, $vacation_data, $vacation_delete, $vacation_file,
       $sq_vacation_file, $vacation_header;



sqgetGlobalVar('vac_action', $vac_action, SQ_FORM);
sqgetGlobalVar('vacation_data', $vacation_data, SQ_FORM);



// start by assuming no vacation message
//
$vacation = FALSE;  
$list = do_action('list', $sq_vacation_file, '');
if ($list) $vacation = TRUE;



// remove vacation message
// 
if($vac_action == 'REMOVE_VACATION' && $vacation) 
{
   $vacation = FALSE;  
   $vacation_data = "";
   do_action('delete', $vacation_file . ',' . $vacation_delete, '');
}



// change or add vacation message
//
if (($vac_action == 'CHANGE_VACATION' || $vac_action == 'ADD_VACATION')  && $vacation_data != '') 
{

//TODO: put forwarding functionality back in
//   if (upload_data($forward_data, $forward_file)) // change forward file

   // text only format 
   //
   if (upload_data($vacation_data, $sq_vacation_file)) 

      // change vacation message
      //
      if (upload_data($vacation_header . $vacation_data . "\n", $vacation_file))  

         $vacation = TRUE;

}



bindtextdomain ('squirrelmail', SM_PATH . 'locale');
textdomain ('squirrelmail');



global $color;
displayPageHeader($color, "None");



bindtextdomain ('vacation_local', SM_PATH . 'locale');
textdomain ('vacation_local');



echo "<br />\n"
   . "<table width=\"95%\" align=\"center\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\">"
   . "<tr><td bgcolor=\"" . $color[0] . "\">\n"
   . "<center><b>" . _("Options") . " - " . _("Change Vacation Message") 
   . "</b></center></td></tr></table>\n"
   . "<table width=\"95%\" align=\"center\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\">\n";



echo '<hr>'._("Compose").'<hr>';
// no vacation message is currently configured
//
if (!$vacation) 
{
   echo _("You do not have a vacation message set up.<br />You can enter one by typing the text you want to reply with in the box below.")
      . '<br /><p>'
      . "<form method=\"post\" action=\"vac_init.php\">\n"
      . "\n<textarea name=\"vacation_data\" rows=\"8\" cols=\"50\">"
      . "$vacation_data</textarea><br /><br />"
      . "<input type=\"hidden\" name=\"vac_action\" value=\"ADD_VACATION\">\n"
      . "<input type=\"submit\" value=\"" . _("Add Message") . "\"></form>\n";
} 



// vacation message is turned on
//
else 
{
   $vacation_data = download_data($sq_vacation_file);
   echo _("Your current Vacation message is:")
      . "<form method=\"post\" action=\"vac_init.php\">\n"
      . "\n<textarea name=\"vacation_data\" rows=\"8\" cols=\"50\">"
      . "$vacation_data</textarea><br />"
      . "<input type=\"hidden\" name=\"vac_action\" value=\"CHANGE_VACATION\">\n"
      . "<input type=\"submit\" value=\"" . _("Change Message") . "\">\n"
      . "</form>"
      . "<form method=\"post\" action=\"vac_init.php\">\n"
      . "<input type=\"hidden\" name=\"vac_action\" value=\"REMOVE_VACATION\">\n"
      . "<input type=\"submit\" value=\"" . _("Delete Message") . "\">\n"
      . "</form>";
}



echo "</table>\n";



bindtextdomain ('squirrelmail', SM_PATH . 'locale');
textdomain ('squirrelmail');



/**
  * Do Action
  *
  * Serves as a proxy between PHP code and the binary 
  * that can access the local file system.
  *
  * @param string $action This should be one of four values
  *                       that indicate what action is to be
  *                       taken: 
  *                         "list"   determines if a file exists
  *                         "put"    uploads the given file 
  *                         "get"    downloads the given file
  *                         "delete" removes the indicated file
  * @param string $remoteFile The name of the file to be manipulated
  *                           on the local file system.
  * @param string $localFile The name of the file to be uploaded or
  *                          downloaded (basically, this is usually
  *                          just a temporary file).
  *
  * @return boolean FALSE if the action failed, TRUE otherwise
  *
  */
function do_action($action, $remoteFile, $localFile) 
{

   global $color, $username, $key, $onetimepad, 
          $mail_vacation_binary, $vac_debug;

   // decrypt password
   //
   sqgetGlobalVar('key', $key, SQ_COOKIE);
   sqgetGlobalVar('onetimepad', $onetimepad, SQ_SESSION);
   $password = OneTimePadDecrypt($key, $onetimepad); 

   $server = 'localhost';

   $result = FALSE;

   if ($vac_debug)
   {
      echo "ACTION: $action === REMOTE: $remoteFile === LOCAL: $localFile === USRE: $username === PASSWORD: $password<br>";
   }

   switch ($action) 
   {

      // check whether file exists
      //
      case 'list': 

	$list = exec($mail_vacation_binary . ' ' . $server . ' ' . $username 
              . ' ' . $password . ' list ' . $remoteFile . ' ???', $output, $retval);

        if ($list == $remoteFile) 
           $result = TRUE;
        else
           $result = FALSE;

        break;



      // upload $remoteFile to $localFile
      //
      case 'put': 

         $put = exec($mail_vacation_binary . ' ' . $server . ' ' . $username 
              . ' ' . $password . ' put ' . $localFile . ' ' . $remoteFile, $output, $retval);

         if ($put != '')
            $result = TRUE;
         else
         {
            plain_error_message(_("An error occurred uploading the file: ") . $output[0], $color);
            $result = FALSE;
         }

         break;



      // download $remoteFile to $localFile
      // 
      case 'get': 

         $get = exec($mail_vacation_binary . ' ' . $server . ' ' . $username 
              . ' ' . $password . ' get ' . $remoteFile . ' ' . $localFile, $output, $retval);

         if ($get != '' && strpos($get, 'Usage') !== 0) 
            $result = TRUE;
         else
         {
            plain_error_message(_("An error occurred downloading the file: ") . $output[0], $color);
            $result = FALSE;
         }

         break;



      // delete files listed in $remoteFile if they exist
      //
      case 'delete': 

         $remoteFiles = explode(',', $remoteFile);
         $result = TRUE;
         foreach ($remoteFiles as $file)
         {

            $list = exec($mail_vacation_binary . ' ' . $server . ' ' . $username
                  . ' ' . $password . ' list ' . $file . ' ???', $output, $retval);

            if ($list == $file) 
            {
               $del = exec($mail_vacation_binary . ' ' . $server . ' '
                    . $username . ' ' . $password . ' delete ' . $file . ' ???', $output, $retval);

               if (!$del) 
               {
                  plain_error_message(_("An error occurred deleting the file: ") . $output[0], $color);
                  $result = FALSE;
               }

            }

         }

         break;



      // unknown action
      //
      default:

         echo _("Unknown action: ") . "$action<br />\n";
         $result = FALSE;

   }

   return $result;

}



/**
  * Download Data
  *
  * Download remote file and return its contents.
  *
  * @param string $remoteFile The path and name of the 
  *                           file to be retrieved.
  *
  * @return string The contents of the desired file are returned
  *
  */
function download_data($remoteFile) 
{

   global $attachment_dir, $username, $color;

   $tempFile = $attachment_dir . '/' . $username . '.mailcfg.tmp';
   
   $result = '';
   
   $get = do_action('get', $remoteFile, $tempFile);
   
   if ($get) 
   {
      if (($FILE = fopen($tempFile, 'r')) === FALSE)
      {
         plain_error_message(_("An error occurred attempting to read temp file; check permissions on attachments directory"), $color);
         @fclose($FILE);
         @unlink($tempFile);  
         return '';
      }

      while (!feof($FILE)) 
         $result .= fread($FILE, 1024);

      fclose($FILE);
      unlink($tempFile);
   }
   
   return $result;

}



/**
  * Upload Data
  *
  * Upload string to a remote file.
  *
  * @param string $data The actual data to be uploaded
  *                     to the indicated file.
  * @param string $remoteFile The path and name of the 
  *                           file to be uploaded.
  *
  * @return boolean FALSE if the upload failed, TRUE otherwise
  *
  */
function upload_data($data, $remoteFile) 
{

   global $attachment_dir, $username, $color;
   
   $tempFile = $attachment_dir . '/' . $username . '.mailcfg.tmp';
   
   if (($FILE = fopen($tempFile, 'w')) === FALSE)
   {
      plain_error_message(_("An error occurred attempting to create temp file; check permissions on attachments directory"), $color);
      @fclose($FILE);
      @unlink($tempFile);  
      return FALSE;
   }

   fwrite($FILE, stripslashes($data));
   fclose($FILE);
  
   $put = do_action('put', $remoteFile, $tempFile);

   // delete localFile
   //
   unlink($tempFile);  
   
   return $put;

}


?> 
