<?php
/**
 * useracl.php
 *
 * Copyright (c) 1999-2003 Alexandros Vellis <avel@noc.uoa.gr>
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * @package plugins
 * @subpackage useracl
 */

/**
 * Functions that output HTML markup, used for the presentation logic of the
 * plugin
 */

/**
 * Print permissions table header row
 *
 * @return void
 */
function useracl_print_table_header() {
	global $color;

	print '<tr>' .
	'<TH WIDTH=10></TH>' .
	'<TH WIDTH=220><small>' . _("User") . '</small></TH>' .
	'<TH WIDTH=100><small>' . _("None") . '</small></TH>' .
	'<TH WIDTH=100><small>' . _("Read") . '</small></TH>' .
	'<TH WIDTH=100><small>' . _("Append") . '</small></TH>' .
	'<TH WIDTH=100><small>' . _("Delete") . '</small></TH>' .
 	'<TH> </TH></TR>';
}

/**
 * Print permissions table Add New User row
 *
 * @return void
 */
function useracl_print_addnew() {
	global $color;

	print '<tr bgcolor="'.$color[4].'">'.
		'<td></td>'.
		'<td align="left"><input type="text" name="newuser" value="" size="20" /></td>'.
		'<td></td>';
	useracl_print_addnew_perms();
	print '<td align="center"><input type="submit" name="adduser" value="'. _("Add User") .'" /></td>'.
		'</tr>';

}

/**
 * Print permissions table New User permissions radio button columns
 *
 * @return void
 */
function useracl_print_addnew_perms() {

	print '<td align="center"><input type="radio" checked="" name="new_user_perm_radio" value="read"></td>'.
		'<td align="center"><input type="radio" name="new_user_perm_radio" value="append"></td>'.
		'<td align="center"><input type="radio" name="new_user_perm_radio" value="delete"></td>';
}

/**
 * Print permissions table row for existing user
 *
 * @param array $perm_array Array that describes this mailbox's ACLs
 * @param string $mbox Mailbox Name
 *
 * @return void
 */
function useracl_print_array($perm_array, $mbox){
	global $color, $names, $mails;
	$tabs[0] = "none";
	$tabs[1] = "read";
	$tabs[2] = "append";
	$tabs[3] = "delete";

	/*
	$tabs[0] = "read";
	$tabs[1] = "append";
	$tabs[2] = "delete";
	*/

	$i=0;
	$toggle = false;

	foreach($perm_array as $user=>$perm){
		echo "<tr";
		if ($toggle) {
			print ' bgcolor="'.$color[12].'"';
		} else {
		 	print ' bgcolor="'.$color[4].'"';
		    }
		print '>';

		if(!$toggle) {
			$toggle = true;
		} elseif($toggle) {
			$toggle = false;
		}

		echo '<td align="center">' .
			// '<input type="checkbox" name="delete_checked['.$i.']" value="'.$user.'">'.
			'</td>';

		echo '<td align="left" nowrap="">';
		if(isset($mails[$user])) {
			$comp_uri = 'src/compose.php?mailbox='.$mbox.'&amp;send_to='.urlencode($mails[$user]);
		}
		
		if(isset($names[$user])) {
			$disp = $names[$user] . ' <small>('.$user.')</small>';
		} else {
			$disp = $user;
		}
		if(isset($comp_uri) && isset($disp)) {
			echo makeComposeLink($comp_uri, $disp);
		} else {
			echo $disp;
		}

		echo '</td>';

		for($k=0;$k<count($tabs);$k++) {
			$radio_checked = $perm == $tabs[$k] ? 'checked=""' : '';

			echo '<td align="center">'.
				'<input type=radio '.$radio_checked.' name=perm_radio['.$user.'] value='.$tabs[$k].'>'.
				'</td>';
		}

		echo '<td align="center"> <INPUT TYPE="submit" NAME=update['.$user.'] value="'. _("Update") .'"> </TD>';
		echo "</tr>\n";
		echo '<input type="hidden" name=all_users['.$i.'] VALUE="'.$user.'">';
		echo '<input type="hidden" name=user_position['.$user.'] VALUE="'.$i.'">';
		$i++;
	}
}
	

/**
 * Print permissions table footer row
 *
 * @return void
 */
function useracl_print_table_footer() {
	echo '<tr> <td align="center" colspan="2">'.
	// '<a href=\"javascript:SetChecked(1)\"> Check All </a> - <a href=\"javascript:SetChecked(0)\"> Clear All </a> ' .
	'</td>'.
	'<td align="right" colspan="5">' .
	// FIXME
	// '<input type="submit" name="delete_checked" value="' . _("Delete Checked") . '">'.
	'<input type="submit" name="update_all" value="' . _("Update All") . '"> </td>'.
	'</tr>';
}

/**
 * Print New User Row for separate table, with mailbox select
 *
 * @param string $mybox Optional parameter for preselected mailbox field
 * @param string $myuser Optional parameter for prefilled user field
 * @return void
 */
function useracl_print_addnew_separate($mybox = '', $myuser = '') {
	global $color, $boxes;
	
	print '<tr bgcolor="'.$color[4].'">'.
		'<td><select name="mbox" size="0">';
	foreach($boxes as $no=>$box) {
		$mbox = $box['unformatted'];
		if(strstr($mbox, 'INBOX') && $mbox != 'INBOX' ) {
			print '<option value="'.urlencode($box['unformatted']).'"';
			if(!empty($mybox) && $mybox == $box['unformatted']) {
				print ' selected=""';
			}
			print '>'.$box['formatted'].'</option>';
		}
	}
	print '</select></td>'.
		'<td align="center"><input type="text" name="newuser" value="';
		if(!empty($myuser)) {
			print htmlspecialchars($myuser);
		}
	print '" size="18" /></td>'.
		'</td><td>';
	useracl_print_addnew_perms();
	print '<td align="center"><input type="submit" name="adduser" value="'. _("Add User") .'" /></td>';
	print '</tr>';

}


/**
 * HTML Output functions follow.
 */


function useracl_html_printheader($title) {

	global $color;
	
	print '<br>
	<table bgcolor="'.$color[0].'" width="95%" align="center" cellpadding="2" cellspacing="0" border="0">
	<tr><td align="center">
	    <strong>'. $title . '</strong>';
	    
	print '
	    <table width="100%" border="0" cellpadding="5" cellspacing="0">
	    <tr><td bgcolor="'.$color[4].'" align="center">
	';
}

function useracl_html_print_all_sections_start() {

	echo '<table width="85%" cols="1" align="center" cellpadding="2" cellspacing="0" border="0">';

}


function useracl_html_print_section_start($title) {

	global $color, $error;

	print "<TR><TD BGCOLOR=\"$color[9]\" ALIGN=CENTER><B>".
	     $title .
	     "</B></TD></TR>";

	if(isset($error)) {
		print '<TR><TD BGCOLOR="'.$color[2].'" ALIGN="CENTER"><p><font color="'.$color[8].'"><strong>'.
		$error . '</strong></font></TD></TR>';
	
	}

	print "<TR><TD BGCOLOR=\"$color[0]\" >";

}

function useracl_html_print_section_end() {

	global $color;
	
	echo "</TD></TR>\n";
	echo "<tr><td bgcolor=\"$color[4]\">&nbsp;</td></tr>\n";
}

function useracl_html_print_all_sections_end() {

	echo "</table>";

}

function useracl_html_printfooter() {

	print '</td></tr></table>';
	print '</td></tr></table>';

}


?>
