<?php
/**
 * useracl.php
 *
 * Copyright (c) 1999-2003 Alexandros Vellis <avel@noc.uoa.gr>
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * @package useracl
 */

/**
 * Main routine - Business and Presentation Logic (GUI) are in here
 */

/* Path for SquirrelMail required files. */
define('SM_PATH','../../');

require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/global.php');
require_once(SM_PATH . 'functions/imap.php');
require_once(SM_PATH . 'functions/display_messages.php');
require_once(SM_PATH . 'plugins/useracl/config.php');
require_once(SM_PATH . 'plugins/useracl/imap_acl.php');
require_once(SM_PATH . 'plugins/useracl/functions.php');
require_once(SM_PATH . 'plugins/useracl/html.php');
require_once(SM_PATH . 'plugins/ldapquery/functions.php');

sqgetGlobalVar('key',          $key,           SQ_COOKIE);
sqgetGlobalVar('username',     $username,      SQ_SESSION);
sqgetGlobalVar('onetimepad',   $onetimepad,    SQ_SESSION);
sqgetGlobalVar('delimiter',    $delimiter,     SQ_SESSION);

if(isset($_POST['mbox'])) {
	$mbox = urldecode($_POST['mbox']);
}
	
	
if (isset($_GET['addacl'])) {
	$addacl = 1;
}

if(isset($_POST['mailbox'])) {
	$selected_mbox = urldecode($_POST['mailbox']);
} elseif(isset($_GET['mailbox'])) {
	$selected_mbox = urldecode($_GET['mailbox']);
}

if(isset($mbox) && isset($addacl)) {
	$selected_mbox = $mbox;
}

/* i18n setup */
$lang_iso = getPref($data_dir, $username, 'language');
$lang = substr($lang_iso, 0, 2);
$charset = $languages[$lang_iso]['CHARSET'];

$location = get_location();

$imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);

if(sqimap_capability($imapConnection, 'ACL') == false ) {
	print 'IMAP server does not support the ACL capability, sorry.';
	sqimap_logout($imapConnection);
	exit;
}

$prev = bindtextdomain ('useracl', SM_PATH . 'plugins/useracl/locale');
textdomain ('useracl');
	

if(isset($_POST['update_all']) || isset($_POST['update']) || isset($_POST['adduser']) || $show_ldap_cn == true) {
	if($check_user_method == 'ldap') {
		/* Initialize ldap handle */
		if(!($ldap=ldap_connect($ldap_server[$ldap_server_no]['host'], $ldap_server[$ldap_server_no]['port']))) {
			print "Could not connect to LDAP server.";
		}
		if (isset($ldap_server[$ldap_server_no]['binddn'])) {
			if (!ldap_bind($ldap, $ldap_server[$ldap_server_no]['binddn'], $ldap_server[$ldap_server_no]['bindpw'])) {
				print "Could not bind to LDAP server.";
			}
		}
	}
}


if(isset($_POST['update_all'])) {
	/* Update All */
	$all_users = $_POST['all_users'];

	for($i=0;$i<count($all_users);$i++){
		$user = $all_users[$i];
		$permission = $_POST['perm_radio'][$user];
		$re = set_permission($imapConnection, $mbox, $user, $permission);
	}

	if($re) {
		$successmsg = sprintf( _("Successfully changed permissions for folder %s"), imap_utf7_decode_local($mbox));
	} else {
		$errormsg = sprintf( _("Failed to change permissions for folder %s"), imap_utf7_decode_local($mbox));
	}


} elseif(isset($_POST['update'])) {
	/* Update Single */
	$user_sent = array_keys($_POST['update']);
	$user = $user_sent[0];
	$permission = $_POST['perm_radio'][$user];

	if(set_permission($imapConnection, $mbox, $user, $permission)){
		$successmsg = sprintf( _("Successfully changed permissions for folder %s"), imap_utf7_decode_local($mbox));
	} else {
		$errormsg = sprintf( _("Failed to change permissions for folder %s"), imap_utf7_decode_local($mbox));
	}

} elseif(isset($_POST['delete_checked'])) {
	/* Delete Checked Permissions */
	/* FIXME */
	$delete_checked = $_POST['delete_checked'];

	for($i=0;$i<count($delete_checked);$i++){
		$user = $delete_checked[$i];
		if( sqimap_deleteacl($imapConnection, urldecode($mbox), urldecode($user))) {
			$successmsg = sprintf( _("Successfully changed permissions for folder %s"), imap_utf7_decode_local($mbox));
		} else {
			$errormsg = sprintf( _("Failed to change permissions for folder %s"), imap_utf7_decode_local($mbox));
		}
	}

} elseif(isset($_POST['adduser'])) {
	

	/* Add New User */
	$user = trim($_POST['newuser']);
	if(strlen($user)) {
		$permission = $_POST['new_user_perm_radio'];

		if($user == $username) {
			$errormsg = _("Cannot modify permissions on your own folder; you will always have full rights on your folders.");

		} elseif($ret = set_permission($imapConnection, $mbox, $user, $permission)) {
			$successmsg = sprintf( _("User %s has been given %s permisssion for folder %s."), $user, _(ucfirst($permission)), imap_utf7_decode_local($mbox));

		} else {
			$errormsg = sprintf( _("Failed to give user %s %s permission for folder %s."), $user, _(ucfirst($permission)), imap_utf7_decode_local($mbox));
			$errormsg .= '<br />' . _("Specified user does not exist.");
		}
	}
}

/* Main */

/* ------------- Business Logic ---------  */

$boxes = sqimap_mailbox_list($imapConnection);

$usernames = array(); /* Array to gather all usernames together */

foreach($boxes as $no=>$box) {

	$mbox = $box['unformatted'];

	/* Get ACLs only for subfolders of INBOX */
	/* FIXME: Alternate namespace */
	if(strstr($mbox, 'INBOX') && $mbox != 'INBOX' ) {
		sqimap_getacl($imapConnection, $mbox, $out);
		if(array_key_exists($username, $out)) {
			unset($out[$username]);
		}
		$perm[$mbox] = $out;
	}
}
$perm_array = create_human_readable_permarray($perm);
sqimap_logout($imapConnection);


if( $show_ldap_cn == true) {
	/* Ask user full names so as to display nicely */
	foreach($perm as $mbox=>$pe) {
		$usernames = array_merge($usernames, array_keys($pe));
	}

	$usernames=array_unique($usernames);
	$usernames=array_values($usernames);

	if (!isset($ldap)) {
		if(!($ldap=ldap_connect($ldap_server[$ldap_server_no]['host'], $ldap_server[$ldap_server_no]['port']))) {
			print "Could not connect to LDAP server.";
		}
		if (isset($ldap_server[$ldap_server_no]['binddn'])) {
			if (!ldap_bind($ldap, $ldap_server[$ldap_server_no]['binddn'], $ldap_server[$ldap_server_no]['bindpw'])) {
				print "Could not bind to LDAP server.";
			}
		}
	}
	
	$filter = '(|(uid=';
	$filter .= implode(')(uid=', $usernames);
	$filter .= '))';

	if($show_ldap_cn == true) {
		$attributes = array('cn', 'uid', 'mail');
	} else {
		$attributes = array('uid', 'mail');
	}

	if (!($sr = ldap_search($ldap, $ldap_server[$ldap_server_no]['base'], $filter, $attributes))) {
		print "Could not search for usernames.";
	}
	$entries = ldap_get_entries ($ldap, $sr);

	$names = array();
	$mails = array();

	for($i=0; $i<$entries['count']; $i++) {

		if($show_ldap_cn == true) {
			if(isset($entries[$i]['cn;lang-'.$lang][0])) {
				$names[$entries[$i]['uid'][0]] =
				    ldapquery_string_convert($entries[$i]['cn;lang-'.$lang][0],
				    $ldap_server[$ldap_server_no]['charset'], $charset);
			} elseif(isset($entries[$i]['cn'][0])) {
				$names[$entries[$i]['uid'][0]] = $entries[$i]['cn'][0];
			}
		}

		if(isset($entries[$i]['mail'][0])) {
			$mails[$entries[$i]['uid'][0]] = $entries[$i]['mail'][0];
		}
	}
	ldap_close($ldap);
}
		



/* ------------- Presentation Logic ---------  */

$js = <<<ECHO
<script language="JavaScript" type="text/javascript">
function SetChecked(val) {
	dml=document.usersList;
	len = dml.elements.length;
	var i=0;
	for( i=0 ; i<len ; i++) {
		if (dml.elements[i].name.substring(0,14)=='delete_checked') {
			dml.elements[i].checked=val;
		}
	}
}
</script>
ECHO;

if ($compose_new_win == '1' && isset($_GET['addacl'])) {
	displayHtmlHeader(_("Add New User Permission"), '', false);
} else {
	$prev = bindtextdomain ('squirrelmail', SM_PATH . 'locale');
	textdomain ('squirrelmail');

	displayPageHeader($color, '');

	$prev = bindtextdomain ('useracl', SM_PATH . 'plugins/useracl/locale');
	textdomain ('useracl');
}

// echo $js;

/*
print '<pre>';
print_r($_POST);
print '</pre>';
*/

$prev = bindtextdomain ('useracl', SM_PATH . 'plugins/useracl/locale');
textdomain ('useracl');

if(isset($successmsg)) {
	print '<div style="color:green;font-size:1.2em;text-align:center">'.
		$successmsg .
		'</div><br />';
}

if(isset($errormsg)) {
	print '<div style="color:red;font-size:1.2em;text-align:center">'.
		$errormsg .
		'</div><br />';
}


useracl_html_printheader( _("User Permissions") );
useracl_html_print_all_sections_start();

foreach($boxes as $no=>$box) {

	$mbox = $box['unformatted'];

	if (isset($_GET['addacl'])) {
		if($mbox != $selected_mbox) {
			continue;
		}
	}

	if(strstr($mbox, 'INBOX') && $mbox != 'INBOX' && 
	   (isset($perm_array[$mbox]) || isset($addacl))) {
		useracl_html_print_section_start( sprintf( _("Current Permissions for Folder: %s") , imap_utf7_decode_local($mbox)));

		print '<form name="form_'.$mbox.'" action="useracl.php?mailbox='.urlencode($mbox);
		if(isset($_GET['addacl'])) {
			print '&amp;addacl=1';
		}
		print '" method="post">';

		print '<input type="hidden" name="mbox" value="'.urlencode($mbox).'" />';
		print '<table width="100%" border="0" >';
		useracl_print_table_header();
		if(isset($perm_array[$mbox]))
			useracl_print_array($perm_array[$mbox], $mbox);
		else
			useracl_print_array(array(), $mbox);
		useracl_print_addnew();
		useracl_print_table_footer();
		print '</table>';
		print '</form>';
		useracl_html_print_section_end();
	}
}



if( ( isset($_GET['addacl']) && !isset($selected_mbox) ) ||
    ( !isset($_GET['addacl']) ) ){

	useracl_html_print_section_start( _("Add New User Permission") );

	print '<form name="form_addnew" action="useracl.php';
	if(isset($_GET['addacl'])) {
		print '?addacl=1';
	}
	print '" method="post">';
	print '<table width="100%" border="0" >';
	useracl_print_table_header();
	useracl_print_addnew_separate();
	print '</table>';
	print '</form>';
	
	useracl_html_print_section_end();
}


useracl_html_print_all_sections_end();


$prev = bindtextdomain ('squirrelmail', SM_PATH . 'locale');
textdomain ('squirrelmail');
if ($compose_new_win == '1' && isset($_GET['addacl'])) {
	print '<INPUT TYPE="BUTTON" NAME="Close" onClick="return self.close()" VALUE='._("Close").'></TD></TR>'."\n";
}


useracl_html_printfooter();


?>
