<?PHP
/*
 * User Logo SquirrelMail Plugin
 *
 * Displays the username in a logo at the top of the folders pane.
 *
 * By Richard Gee (richard.gee@pseudocode.co.uk)
 *
 * Version 1.1
 * Copyright 2002 Pseudocode Limited.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

 /* $Id$ */

chdir('..');
require_once('../src/validate.php');

chdir('user_logo');
require('config.php');

session_cache_limiter('none');
session_start();
header('Cache-control: private, max-age=1440, pre-check=1440');
header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 86400) . ' GMT');
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');

$username = $_SESSION['username'];

// If file doesn't exist then create it
if (!file_exists("$username.png")) {
  if (strpos($username, '@')) {
    $name = preg_replace('/@.*/' ,'', $username);
    $server = preg_replace('/.*@/' ,'', $username);
  }
  else {
    $name = $username;
    $server = '';
  }

  $img = imagecreatefrompng('image.png');

  // Set up text and outline colors
  $color1 = imagecolorallocate($img, $textcol[0], $textcol[1], $textcol[2]);
  $color2 = imagecolorallocate($img, $outlinecol[0], $outlinecol[1], $outlinecol[2]);

  $width = imagesx($img);
  $height = imagesy($img) - 2;

  $box = imagettfbbox(18, 0, $font, $name);
  $x1 = ($width - ($box[4] - $box[0])) / 2;
  $h1 = $box[1] - $box[5];

  if ($server != '') {
    $box = imagettfbbox(12, 0, $font, '@');
    $x2 = ($width - ($box[4] - $box[0])) / 2;
    $h2 = $box[1] - $box[5];

    $box = imagettfbbox(13, 0, $font, $server);
    $x3 = ($width - ($box[4] - $box[0])) / 2;
    $h3 = $box[1] - $box[5];

    $h1 = $h1 * 2;

    outline_text($img, $atsize, $x2, ($height + $h2) / 2, $color1, $color2, $font, '@');

    outline_text($img, $serversize, $x3, ($height + $h2) / 2 + $h3 + 4, $color1, $color2, $font, $server);

    outline_text($img, $usersize, $x1, ($height - $h2) / 2 - 4, $color1, $color2, $font, $name);
  }
  else {
    outline_text($img, $usersize, $x1, ($height + $h1) / 2, $color1, $color2, $font, $name);
  }

  imagepng($img, "$username.png");
  imagedestroy($img);
}

header('Content-Type: image/png');

readfile("$username.png");

function outline_text($img, $size, $x, $y, $color1, $color2, $font, $text) {
  imagettftext($img, $size, 0, $x-1, $y, $color2, $font, $text);
  imagettftext($img, $size, 0, $x+1, $y, $color2, $font, $text);
  imagettftext($img, $size, 0, $x, $y-1, $color2, $font, $text);
  imagettftext($img, $size, 0, $x, $y+1, $color2, $font, $text);
  imagettftext($img, $size, 0, $x, $y, $color1, $font, $text);
}
?>
