<?php

/**
  * SquirrelMail User Information Plugin
  * Copyright (c) 2008-2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage user_info
  *
  */

global $preload_user_info, $user_info_modules;


// User information will not be calculated and loaded until
// it is asked for (usually by another plugin) when this is
// turned off.  That usually helps performance, but you can
// also turn this setting on (set to 1) so this plugin will
// pro-actively load user information into the user session
// if you think the data is used very heavily anyway.
// 
// Note that you do not need to activate this plugin in the
// SquirrelMail configuration if this is turned off.
// 
$preload_user_info = 0;



// Add-in module list: each module name should have a
// nested list inside of it containing any configuration
// parameters needed by it, but at least "file" and
// "function", which indicate where to find the module
// (the file to include and then the function to call
// in order to get the module's user information data).
//
// The module's callback function will be given this
// very array as its one and only argument, to which
// one additional key-value pair is added, which is
// "user_info", containing the current $user_info
// (user information) list (note that that list will
// contain useful things like the user's username and
// IP address).
//
// The module's callback function is expected to return
// an array of user information that is ready to be
// added directly to the main $user_information array
// (it should take care to define sensible attribute
// names that aren't in use by other modules).  For
// example, a IP-to-country module might return a
// simple array such as ("country_code" => "FR",
// "country_name" => "France").
//
// This example uses the sample script found in the
// "contrib" directory of this plugin
//
// $user_info_modules = array(
//    'ip-to-country' => array(
//       'file' => '/usr/share/ip_address_lookups/lookup_country_by_ip_address.php',
//       'function' => 'lookup_country_by_ip_addr',
//    ),
// );
//
$user_info_modules = array(
);



