<?php
/* unsafe_image_rules -- Version 0.5
 * By Robin Rainton <robin@rainton.com>
 * http://rainton.com/fun/freeware
 *
 * This page handles options for the plugin.
 * Shamless snatch of code from filters page - thanks guys ;-)
 */

if (!defined('SM_PATH')) define('SM_PATH','../../');
require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/page_header.php');
require_once(SM_PATH . 'include/load_prefs.php');

/*
 * Get globals
 */

  $username = $_SESSION['username'];

/*
 * Start options page display.
 */

  displayPageHeader($color, 'None');

/*
 * Get variables from our form that are frequently used.
 */

  $action = $_GET['action'];
  $theid = $_GET['theid'];
  $how = $_POST['how'];
  $where = $_POST['where'];
  $what = $_POST['what'];

  if (isset($_POST['unsafe_image_rules_submit'])) {
     $theid = isset($_POST['theid'])? $_POST['theid'] : $theid = 0;
/*
 * This is a bit bad, but if $how is regexp then prefix
 * $where with "R". This makes stuff backwards compatable.
 */

     if ($how == 'regexp') $where = "R" . $where;

     setPref($data_dir, $username, "unsafe_image_rules".$theid, $where.",".$what);
  } elseif (isset($action) && $action == 'delete') {
     remove_trusted($theid);
  } elseif (isset($_POST['user_submit'])) {
      setPref($data_dir, $username, 'unsafe_image_rules_all',
              isset($_POST['uir_all']) ? "1" : "0");
      setPref($data_dir, $username, 'unsafe_image_rules_addr',
              isset($_POST['uir_addr']) ? "1" : "0");
      setPref($data_dir, $username, 'unsafe_image_rules_ids',
              isset($_POST['uir_ids']) ? "1" : "0");
      setPref($data_dir, $username, 'unsafe_image_rules_trusted',
              isset($_POST['uir_trusted']) ? "1" : "0");
      echo "<br><center><b>"._("Saved Trusted Options")."</b></center>\n";
  }

  $unsafe_image_rules_list = load_unsafe_image_rules();
  $unsafe_image_rules_all = getPref($data_dir, $username, 'unsafe_image_rules_all');
  $unsafe_image_rules_addr = getPref($data_dir, $username, 'unsafe_image_rules_addr');
  $unsafe_image_rules_ids = getPref($data_dir, $username, 'unsafe_image_rules_ids');
  $unsafe_image_rules_trusted = getPref($data_dir, $username, 'unsafe_image_rules_trusted');

  echo '<br>' .
       '<table width=95% align=center border=0 cellpadding=2 cellspacing=0>'.
       "<tr><td bgcolor=\"$color[0]\">".
       '<center><b>' . _("Options") . ' -  ' . _("Unsafe Image Rules") . '</b></center>'.
       '</td></tr></table>'.

       '<br><form method=post action="options.php">'.
       '<center>'.
       '<table width=80% cellpadding=2 cellspacing=0 border=0>';

/*
 * Trust all images option.
 * This might be disabled by admin
 */

  if (!(isset($unsafe_image_rules_disable_all) && $unsafe_image_rules_disable_all))
  {
    echo '<tr><th align=right nowrap valign=top>' . _("Trust all sources:") . '</th>'.
         '<td valign=top><input type=checkbox name="uir_all"';
    if (isset($unsafe_image_rules_all) && $unsafe_image_rules_all) {
        echo ' CHECKED';
    }
    echo "></td><td><small><B>WARNING!</B> This is not recommended by" .
         " the Squirrelmail Development Team.<BR>" . 
         "Read this <a href=\"http://www.squirrelmail.org/wiki/UnsafeImages\"> " .
         "http://www.squirrelmail.org/wiki/UnsafeImages</a> for more details. " .
         "There is a risk you may recieve more spam if you check this option.<BR>" .
         "If checked unsafe images are always seen.<BR>" .
         "If this option is checked, the state of other options is irrelevant." .
          "</small></td><tr>" .
          "</tr>\n";
  }

/*
 * Trust addresses option.
 */

  echo '<tr><th align=right nowrap valign=top>' . _("Trust sources in address book:") . '</th>'.
       '<td valign=top><input type=checkbox name="uir_addr"';         
  if (isset($unsafe_image_rules_addr) && $unsafe_image_rules_addr) {
      echo ' CHECKED';
  }
  echo "></td><td><small>If checked unsafe images are shown for messages from anyone in your address book." .
       "</small></td></tr>\n";

/*
 * Trust IDs option.
 */

  echo '<tr><th align=right nowrap valign=top>' . _("Trust anything I send:") . '</th>'.
       '<td valign=top><input type=checkbox name="uir_ids"';         
  if (isset($unsafe_image_rules_ids) && $unsafe_image_rules_ids) {
      echo ' CHECKED';
  }
  echo "></td><td><small>If checked unsafe images are shown for messages sent by any of your identities.<BR>" .
       "You might not want to set this if you forward Spam to other people, and then go back and read from your 'Sent' folder." .
       "</small></td></tr>\n";

/*
 * Trust only some option.
 */

  echo '<tr><th align=right nowrap valign=top>' . _("Trust defined sources:") . '</th>'.
       '<td valign=top><input type=checkbox name="uir_trusted"';         
  if (isset($unsafe_image_rules_trusted) && $unsafe_image_rules_trusted) {
      echo ' CHECKED';
  }
  echo "></td><td><small>If checked unsafe images are shown for the sources shown below." .
       "</small></td></tr>\n";

/*
 * Submit for top changes.
 */

  echo '<tr><td colspan=3 align=center><input type=submit name="user_submit" value="' .
       _("Save") . '"></td></tr>'.
       '</table>'.
       '</center>'.
       '</form>';

/*
 * New, done, then list existing ones.
 */

  echo '<center>[<a href="options.php?action=add">' . _("Add New Rule") .
       '</a>] - [<a href="../../src/options.php">' . _("Done") . '</a>]</center><br>';

  if (isset($action) && ($action == 'add' || $action == 'edit')) {
    if ( !isset($theid) ) {
         $theid = count($unsafe_image_rules_list);
    }
    echo '<form action="options.php" method=post>'.
         '<table width=95%><tr><td align=center>' .
         _("Trust source if ") .
         '<select name=where>';

    $where_set = isset($unsafe_image_rules_list[$theid]['where']);

    $sel = (($where_set && $unsafe_image_rules_list[$theid]['where'] == 'From')?'selected':'');
    echo "<option value=\"From\" $sel>" . _ ("From") . '</option>';

    $sel = (($where_set && $unsafe_image_rules_list[$theid]['where'] == 'To')?'selected':'');
    echo "<option value=\"To\" $sel>" . _ ("To") . '</option>';

    $sel = (($where_set && $unsafe_image_rules_list[$theid]['where'] == 'Cc')?'selected':'');
    echo "<option value=\"Cc\" $sel>" . _ ("Cc") . '</option>';

    $sel = (($where_set && $unsafe_image_rules_list[$theid]['where'] == 'To or Cc')?'selected':'');
    echo "<option value=\"To or Cc\" $sel>" . _ ("To or Cc") . '</option>';

    $sel = (($where_set && $unsafe_image_rules_list[$theid]['where'] == 'Subject')?'selected':'');
    echo "<option value=\"Subject\" $sel>" . _ ("Subject") . '</option>';

    echo '</select><select name=how>';

    $how_set = isset($unsafe_image_rules_list[$theid]['how']);

    $sel = (!$how_set ||
            ($how_set && $unsafe_image_rules_list[$theid]['how'] == 'contains')?'selected':'');
    echo "<option value=\"contains\" $sel>" . _("Contains") . '</option>';

    $sel = (($how_set && $unsafe_image_rules_list[$theid]['how'] == 'regexp')?'selected':'');
    echo "<option value=\"regexp\" $sel>" . _("Reg.Exp.") . '</option>';

    echo "</select>" .
         '<input type=text size=32 name=what value="';
    if (isset($unsafe_image_rules_list[$theid]['what'])) {
      echo htmlentities($unsafe_image_rules_list[$theid]["what"]);
    }
    echo '"></td></tr><tr><td align=center>'.
         "<table><tr><td valign=center align=right><b><small>NB:</small></b></td><td align=left>" .
         "<small>" .
         "When specifying a Reg.Exp you must include delimeters.<BR>" .
         "The 'Contains' check will be done with case-insensitive match." .
         "</small></td></tr></table>" .
         '<input type=submit name=unsafe_image_rules_submit value=' . _("Submit") . '>'.
         "<input type=hidden name=theid value=$theid>".
         '</td></tr></table>' .
         '</form>' .
         '</center>';
    }

    echo '<table border=0 cellpadding=3 cellspacing=0 align=center>';

    for ($lp = 0; $lp < count($unsafe_image_rules_list); $lp++) {
      $clr = (($lp % 2)?$color[0]:$color[9]);
      echo "<tr bgcolor=\"$clr\"><td><small>".
           "[<a href=\"options.php?theid=$lp&action=edit\">" . _("Edit") . '</a>]'.
            '</small></td><td><small>'.
            "[<a href=\"options.php?theid=$lp&action=delete\">" . _("Delete") . '</a>]' .
            "</small></td><td>-</td><td>";
      printf( _("If <b>%s</b> %s <b>%s</b></b>"),
              _($unsafe_image_rules_list[$lp]['where']),
              ($unsafe_image_rules_list[$lp]['how'] == "regexp" ? ("Reg.Exp.")
                                                                : ("Contains")),
              htmlentities($unsafe_image_rules_list[$lp]['what']));
      if ($unsafe_image_rules_list[$lp]['how'] == "regexp" &&
          !is_good_regexp($unsafe_image_rules_list[$lp]['what']))
      {
        echo "<br><B>WARNING:</b> This doesn't loook like a valid Reg.Exp.";
      }
      echo '</td></tr>';

  }
  echo '</table>';

function remove_trusted($id)
{
  global $data_dir, $username;

  while ($trusted = getPref($data_dir, $username, 'unsafe_image_rules' . ($id + 1))) {
    setPref($data_dir, $username, 'unsafe_image_rules' . $id, $trusted);
    $id++;
  }

  removePref($data_dir, $username, 'unsafe_image_rules' . $id);
}

?>
