<?php

/*******************************************************************************

$Log: weather.php,v $
Revision 1.48  2005/01/15 04:32:42  jamuel
Separate commit to update how the parser deals with the barometric pressure
rising and falling icon (new in the datafeed).  Adds weather_proxy_icon
support.

Revision 1.47  2005/01/15 03:21:44  jamuel
Updated the datafeed parser logic to support new datafeed format.

Revision 1.46  2004/11/24 20:02:56  jamuel
Rework for proxy server fixes and for socket timeout fixes.

Revision 1.45  2004/10/07 18:01:47  jamuel
Face lift to handle plugin architectural guidelines, added a
twc_weather-version() function, bumped the version, and README.

Revision 1.44  2004/10/07 05:43:01  jamuel
Fixes for weather_proxy support in options.php, switched out requires
with includes, fixed narratives parser (wasn't catching text with %
sign).

Revision 1.43  2004/10/02 06:00:18  jamuel
Updates to support user selectable barometric pressure SI units as hPa
or kPa.

Also fixed a nagging bug in the options screen that caused non-
US locations to be tagged not found because the weather code was not being
used.  The new functionality is if the Location doesn't change (i.e. some
other attributes are changed) the script doesn't attempt to validate the
location (since it ought to still be good shouldn't it).

Revision 1.42  2004/09/29 00:39:14  jamuel
Minor updates to I18n related code.  Also bumped version and README
in preparation for 1.3 beta 3 release.

Revision 1.41  2004/09/28 05:09:19  jamuel
Left $debug flag on.

Revision 1.40  2004/09/28 04:59:24  jamuel
Reworked all string outputs to support I18n

Revision 1.39  2004/09/27 16:52:06  jamuel
Major overhaul to eliminate most all (I hope) E_ALL info messages.

Revision 1.37  2004/09/26 07:05:53  jamuel
Added the I18n hooks for translations.

Revision 1.35  2004/09/22 20:51:00  jamuel
Multiple commits to get up to 1.2 RC2a with a fix to options.php that was
causing blank pages when clicking Hide or Show on locations.

Revision 1.48  2003/09/23 00:01:50  jamuel
Mostly hacks to twc_support to enable transparent wicon proxying.  Also
worked on weather.php to handle mangling of the wicon URL correctly
so that a PNG is called a PNG and a GIF called a GIF when/where appropriate.

Config has a new setting to deal with the transparent proxying.

Revision 1.47  2003/07/24 16:13:35  jamuel

Added additional debugging information to capture files.

Revision 1.46  2003/07/15 18:12:12  jamuel

Added quick and dirty cache validation scheme to load_locations().  Check
the temperature that's retrieved from the cache, if contains a numerical
value then the cache *probably* has good data.  Set's cache_valid to TRUE
then when weather_display is called a cache_valid is added to the cache
checking conditional.

Revision 1.45  2003/07/10 18:39:43  jamuel

Made WIcon Proxy on by default, fixed extended forecasts to work beyhond
5 days, changed weather.com URL back to www from w3, added @ error
suppression around some of the File/Socket IO.

Revision 1.44  2003/06/16 17:16:22  jamuel

Minor formatting change to center the location and/or alias when no wicon
is displayed.

Revision 1.43  2003/06/05 16:48:26  jamuel
Turned off debugging\!

Revision 1.42  2003/06/05 16:38:50  jamuel

Added support for forcing the SM server to proxy client request for the
weather icons rather than having the client redirected to the datafeed
for the icons.

Revision 1.41  2003/05/26 17:58:25  jamuel

Major changes to bring in 1.2 features (weather location templates) and
the TWC URL fix

Revision 1.40  2003/04/24 01:19:13  jamuel

Minor bug fix to check if SM_PATH is already defined.  Code was colliding
with some other plugins according to reports.

Revision 1.39  2003/03/12 18:21:47  jamuel


-- Cleaned up/rearranged more code

-- Re-enabled most administrative config options.

-- Added a socket timeout/timer option to config.php to safety/check stalled/
   broken connections to the TWC datafeed.

Revision 1.38  2003/02/27 23:21:08  jamuel

Turn debugging off darn it!

Revision 1.37  2003/02/27 23:17:40  jamuel

Cleaned up twc_support quite a bit.  Added lots of comments and restructured
some of the lines of code to stay within 80 columns.

Also fixed the output of the weather box to so that the column position
of the weather values doesn't fluctuate.  They sort of floated ever since
the option to display a wide (vs narrow) forecast/narrative text.
(Thanks to Stephen Brown for coming up with the patch for that.)

Made a couple of random fixes to the support code to help handle random
preg_replace problems/bugs in my search-patterns.  What comes to mind
are a fix for trapping "than" vs "an" (was getting a hit on a phrase
that had "than") and was dropping a period on an end of a sentence that
contained an inches conversion.  Both are fixed.

Revision 1.36  2003/02/26 07:36:04  jamuel

Forgot to turn off debugging again!

Revision 1.35  2003/02/26 07:30:30  jamuel

Fixed a gaff in the Feels Like parser--wasn't handling N/A correctly from
TWC.

Also added an option to display the forecast narrative across the
entire length of the weather box as opposed to just the right side aligned
with the other weather values.  This option is per location and the default
is to display in the new "wide" format.  If you want the old "narrow" format
just select "Narrow Format" for the particular location.

Thanks to Stephen Brown for the contributed code.

Finally changed the units for Barometric Pressure from mb's to KPa's based
on user feedback.  Apparently KPa are the units typically expressed in
Europe. KPa's are 10% of millibars.

Revision 1.34  2003/02/25 16:35:22  jamuel

Should be final commit on Beta 2 mod's to support SI Narratives.  Only thing
left are any lingering bugs . . .

Revision 1.33  2003/02/21 22:36:03  jamuel

Patched icon and temperature parsing to match rel-1-0

Revision 1.32  2003/02/21 21:59:57  jamuel

Beta 2 updates to support SI unit conversion in narrative.

Revision 1.31  2003/02/14 05:01:20  jamuel

Added hooks for SI conversion of the weather narrative (text).

Revision 1.30  2003/02/08 18:13:54  jamuel

Changed support.php to twc_support.php to eliminate conflicts in how this
file is required_once with other plug-ins using the same name.

Revision 1.29  2003/02/08 08:27:01  jamuel

Bumped the version number, updated the README, and turned debugging off.

Revision 1.28  2003/02/08 08:06:12  jamuel

Full metric conversion support (the best I can tell) for all of the
possible weather values from the datafeed.  Lots of trickery in the parser
especially for Winds and Barometric Pressure. Can determine Variable and
Gusty winds and can now show steady/rising/falling pressure indications.

Revision 1.27  2003/02/07 18:17:09  jamuel


After many request, and much over due--I've added support for metric (SI)
unit display.  Added a couple of conversion functions in support.php
that are called by weather.php when the weather values are parsed from
the datafeed.  A check is made to see if the user wanted metrics displayed
via the location setup/edit screen in twc_weather options.

The only trick left to implement would be to do something similar for
the weather narrative (forecasts)--which currently ONLY supports english
units.  So if the user selects metrics right now, atleast, the narrative
will still be display abeit in english units.

Stay tuned . . .

Revision 1.26  2003/01/16 22:55:27  jamuel

Fix for Box Width values being ignored when displaying weather text.  I had
long, long ago hardcoded the value to 200 back when I was first putzing
thru PHP . . .  Ooopsie.  This has now been fixed.

Revision 1.25  2003/01/08 16:34:26  jamuel

Updated the parser for the data feed to reflect changes in the weather.com
site.  Tested with SM-1.4.0-rc1, 1.3.2, and 1.2.9.

Revision 1.24  2002/12/28 19:33:34  jamuel

More cleanup.

Revision 1.23  2002/12/28 19:22:58  jamuel

Final clean up of debugging conditionals and such.

Revision 1.22  2002/12/16 03:26:16  jamuel

Fixed an issue where the "Forecast" table_color_label wasn't being
interpreted correctly because of an inadvertent linefeed--wasn't obvious
from looking at the code because it looks like a line wrap in vi.  Just
deleted the linefeed and made the line continuous.

Revision 1.21  2002/12/15 05:39:52  jamuel

Cleaned up paths for version detection compatibility.

Revision 1.20  2002/12/12 18:59:08  jamuel


Added SM version checking support.  Now correctly determines SM version by
parsing $version from SM's strings.php so that the correct foo is done to
the plug-in path's based on 1.2.x vs 1.3.x

Revision 1.19  2002/12/12 00:37:56  jamuel


Fixed major logic bomb that had weather_code and weather_place getting
mix/matched when setting prefs mostly in options.php.  Also added minor
tweak to weather.php that was compensating for options.php previously.

Issue boils down mainly that I had my notion of weather_code and weather_place
screwed up in my head since I was playing tricks with weather_code when
multiple hits were found when adding a new location (place).

Also definitively determined that rg=Off is NOT supported under 1.2.x since
(I think) database support is broken when retriving prefs (getPrefs)
via the MySQL hack.  Since I don't have a non-MySQL based user prefs
running to test SM with file-based prefs I can't say for certain as
to whether twc_weather will run under 1.2.x with rg = Off and file-base
user prefs turned on. twc_weather does, however, run with rg = On.  Finally,
under SM_1.3.x twc_weather does indeed support rg = Off (or On).

Revision 1.18  2002/12/09 23:19:12  jamuel

Accidentally left debugging flag turned on.

Revision 1.17  2002/11/24 22:38:28  jamuel

Wrong pad value for chopping off the "Feels Like" value.   Was getting an
extra whitespace character prepended to value.  This broke the N/A fix up
routine (when TWC reports N/A we substitue N/A with the current temp
instead.)

Revision 1.16  2002/11/24 21:56:30  jamuel

Weather.com updated the datafeed again.  Have rehacked the parser text to
properly capture the datafeed.  Enjoy!

Revision 1.15  2002/11/19 22:05:00  jamuel

Added SM_PATH support to beginning of file (and removed chinky `chdir').
Also deleted some extraneous debug commands that were not removed from a
prior update session.  Plugin now works with SM 1.3.2 with
register_globals = ON *only* for now . . .

Revision 1.14  2002/07/22 22:39:05  jamuel

Added drop-down selector for user to choose the # of days worth of narrative
forecasts to display instead of the hardcoded three (3).

The trick is TWC splits the current and next day into at least two seperate
narratives per day so weather.php has to juggle what a "day" means when it
iterates thru the narrative text presented by twc.  Currently days = 1-->2
forecasts days = 2-->4 forecasts, days = 3-->5 forecasts, etc.  This gets
a little sloppy at the end of a day since there is only 1 forecast for the
current day so even though you select 2 days, for example, you get Tonight,
2 Tomorrows, and the next day--instead of just Tonight and Tomorrow.  When
I get the courage to smarten up the parser logic I'll implement a fix--until
then fagettaboutit.

Finally, I added some logic that if Forecasts are ON and the # of Days
are set to 0 then 3 forecasts will be displayed.

Revision 1.13  2002/07/19 22:46:08  jamuel

Noticed that when debugging was turned off only one forecast was printed for
each location instead of the hardwired 3.  Found bug in $narrative parser,
wasn't properly trimming the string to the right length (too long) and was
getting a crlf ^M stored in the Prefs.  All is good and checked in with
debugging off.

Revision 1.12  2002/07/19 21:04:59  jamuel

First pass at the forecast narratives.  Not sure if I like the current layout.
Any suggestions?

Revision 1.11  2002/07/19 18:38:07  jamuel

Added Prefs handling for narrative forecast.

Revision 1.10  2002/07/17 21:49:17  jamuel

Fixed parsing of Weather Icon and associate prefs storage of the IMG tag.
Wasn't correctly parsing for all icon cases and the tag stored in prefs
didn't contain the trailing ">".  Since we extract only a substr of the IMG
tag and discard things like WIDTH= need to add the trailer ">"

Revision 1.9  2002/07/12 21:32:53  jamuel

Previous commit might have broken removing "From the" from the Wind display
option.  This fixes that so the annoying "From the"'s are removed.

Revision 1.8  2002/07/11 05:59:43  jamuel

Fixed Wind parsing to allow for "calm" condition.  Weather.com report calm mph
rather than fixing it up proper.  So I rewrite "calm mph" as "Calm".  That's
it!

Revision 1.5  2002/07/02 22:46:06  jamuel
Added CVS Keywords ($) to source file.

*******************************************************************************/

/*
 *  Note: the format of the user preference file may seem.. well.. not orderly,
 *  to put it nicely. This is only due to the fact, that we have to remember
 *  that the configuration file may already be from an older version. Users
 *  are not going to want to re-enter information every time the administrator
 *  decides to update this absolutely wonderful plugin!
 */

global $debug; 

/* set this to true if you want to skip caching during debugging */

/* SM Version Checking */

if (twc_weather_check_SM_version (1, 3, 2))
{       
	if(!defined('SM_PATH'))
	{	
		define('SM_PATH','../../');
	}
	include_once (SM_PATH . 'plugins/twc_weather/chunky.php');
	include_once (SM_PATH . 'plugins/twc_weather/twc_support.php');

	if (file_exists (SM_PATH . 'plugins/twc_weather/config.php'))
		include_once (SM_PATH . 'plugins/twc_weather/config.php');
	else
		include_once (SM_PATH . 'plugins/twc_weather/config.php.sample');
	
}
else
{
        include_once ('chunky.php');
	include_once ('twc_support.php');

       	if (file_exists ('config.php'))
               	include_once ('config.php');
       	else
               	include_once ('config.php.sample');
}

function load_locations ()
{
	global $data_dir, $username;

	$locations = array ();

	for ($i = 0; $location = getPref ($data_dir, $username, 'twc_weather' . $i); $i++)
	{
		$temp = explode ('\\', $location);
		$locations[$i]['code'] = $temp[0];
		$locations[$i]['place'] = $temp[1];
		$locations[$i]['position'] = $temp[2];
		$locations[$i]['view-temp'] = $temp[3];
		$locations[$i]['view-feels'] = $temp[4];
		$locations[$i]['view-conditions'] = $temp[5];
		$locations[$i]['view-uv'] = $temp[6];
		$locations[$i]['view-wind'] = $temp[7];
		$locations[$i]['view-dew'] = $temp[8];
		$locations[$i]['view-humidity'] = $temp[9];
		$locations[$i]['view-visibility'] = $temp[10];
		$locations[$i]['view-barometer'] = $temp[11];

		$locations[$i]['timestamp'] = $temp[12];
		$locations[$i]['cache-name'] = $temp[13];
		$locations[$i]['cache-temp'] = $temp[14];
		$locations[$i]['cache-feels'] = $temp[15];
		$locations[$i]['cache-conditions'] = $temp[16];
		$locations[$i]['cache-uv'] = $temp[17];
		$locations[$i]['cache-wind'] = $temp[18];
		$locations[$i]['cache-dew'] = $temp[19];
		$locations[$i]['cache-humidity'] = $temp[20];
		$locations[$i]['cache-visibility'] = $temp[21];
		$locations[$i]['cache-barometer'] = $temp[22];
		$locations[$i]['cachetime'] = $temp[23];

		$locations[$i]['viewable'] = $temp[24];
		$locations[$i]['width'] = $temp[25];
		$locations[$i]['margin-right'] = $temp[26];
		$locations[$i]['margin-left'] = $temp[27];
		$locations[$i]['margin-top'] = $temp[28];
		$locations[$i]['margin-bottom'] = $temp[29];
		$locations[$i]['color-background'] = $temp[30];
		$locations[$i]['color-foreground'] = $temp[31];
		$locations[$i]['color-label'] = $temp[32];
		$locations[$i]['color-value'] = $temp[33];

		$locations[$i]['view-place'] = $temp[34];
		$locations[$i]['view-alias'] = $temp[35];
		$locations[$i]['view-icon'] = $temp[36];
		$locations[$i]['alias'] = $temp[37];
		$locations[$i]['icon'] = $temp[38];
		$locations[$i]['view-narrative'] = $temp[39];
		$locations[$i]['narrative'] = $temp[40];
		$locations[$i]['narrative-days'] = $temp[41];
		$locations[$i]['use-metric'] = $temp[42];
		$locations[$i]['forecast-narrow'] = $temp[43];
		if (preg_match("/^[0-9]/", $locations[$i]['cache-temp']))
		{
			$locations[$i]['cache_valid'] = TRUE;
		}
		else
		{
			$locations[$i]['cache_valid'] = FALSE;
		}
		$locations[$i]['wind-units'] = $temp[44];
		$locations[$i]['pressure-units'] = $temp[45];
	}	

	return $locations;
}

function remove_location ($id)
{
	global $data_dir, $username;
	while ($nextLocation = getPref($data_dir, $username, 'twc_weather' . ($id + 1)))
	{
		setPref ($data_dir, $username, 'twc_weather' . $id, $nextLocation);
		$id++;
	}
	removePref ($data_dir, $username, 'twc_weather' . $id);
}
function weather_narrative($location, $theid)
{
	global $color, $left_size, $data_dir, $username, $weather_proxy; 
	global $weather_datafeed_timeout, $debug;
	$request = 'GET ';
	$the_server = 'www.w3.weather.com';
	if ($weather_proxy)
        {
                        preg_match ("/^(http:\/\/)?([^\/]+):(\d+)/i", $weather_proxy, $matches);

			$request .= "http://$the_server";
                        $the_server = $matches[2];
                        $the_port   = $matches[3];
 	}
        else
        {
                        $the_port = 80;
        }

          	$request .= "/weather/mpdwcr/narrative?locid=" . $location['code'] . 
			    "&adprodname=lap_travel_daily_main&channel=businesstraveler" . " HTTP/1.1\r\n";;
        
                $request .= "Host: www.w3.weather.com\r\n";
                $request .= "Accept: */*\r\n";
                $request .= "Connection: close\r\n";
                $request .= "\r\n\r\n";
		$data = "";
		
		/* Make a call to TWC -- only wait around $weather_datafeed_timeout seconds or bail out */                
                $httpsock = @fsockopen ($the_server, $the_port, $errno, $errstr, $weather_datafeed_timeout);
                if ($httpsock)
                {
			@stream_set_timeout ($httpsock, $weather_datafeed_timeout);
                	@fwrite ($httpsock, $request);

			$timer = time();
        		while ( !@feof($httpsock) && (time() < $timer + $weather_datafeed_timeout))
        		{
        			$data .= @fread ($httpsock, 8192);
        		}
			@fclose($httpsock);
			if (preg_match ('/Transfer\-Encoding\:\ chunked/', $data))
			{
				$data = Decode_Chunked_Message ($data);
			}
		}
		
	$narrative_days = $location['narrative-days'];
	$narrative = '';
	if ($cntMatches = preg_match_all ('/day\[\'([0-9]+)\'\]\=new\ mpdNDObj\(new\ Date\([\'0-9\,]*\)\,\'([0-9]+)\'\,\'([a-z0-9\s\,\.\+\-\%]*)\'\,\'([a-z0-9\s]*)\'\)\;/i', $data, $all_matches))
	{
		for ($i = 0; $i < 11; $i++)
		{
			if ($all_matches[2][$i] <= $narrative_days)
			{	
				$narrative .= '<b>' ;
				if (!empty ($all_matches[4][$i]))
				{ 
					$narrative .= _($all_matches[4][$i]) . '</b> '. $all_matches[3][$i] . '<br>';
				}
			}
		}			
	}
	
	$narrative = preg_replace('/[\n]/', '', $narrative);
	
	if ($debug)
	{
		global $weather_debug_dir;
		$fp = fopen($weather_debug_dir . "/twc_weather-narrative.log", "w");
		fwrite ($fp, "Server: $the_server\n");
		fwrite ($fp, "Port: $the_port\n");
		fwrite ($fp, "Request: $request\n");
		fwrite ($fp, "Raw Data: $data\n");
		fwrite ($fp, "Narrative: $narrative\n");
		fclose ($fp);
	}
	return ($narrative);
}
function weather_display ($location, $theid)
{
	global $color, $left_size, $data_dir, $username, $weather_proxy,
	       $weather_proxy_icons, $weather_proxy_icons_method,
	       $weather_datafeed_timeout, $weather_cache_time_minimum, 
	       $weather_location_amount, $debug;
	
	$cache_time = $weather_cache_time_minimum;
	$thetime = time (NULL);
	$cachetime = $location['timestamp'] + $cache_time;
	
	if (($cachetime < $thetime) || $debug === TRUE || 
	     $location['cache_valid'] === FALSE)
	{
		$the_server = 'w3.weather.com';
		$request = 'GET ';
		if ($weather_proxy)
		{
			preg_match ("/^(http:\/\/)?([^\/]+):(\d+)/i", 
			            $weather_proxy, $matches);
			
			$request .= "http://$the_server";
			$the_server = $matches[2];
			$the_port   = $matches[3];
			
		}
		else
		{
			$the_server = "w3.weather.com";
			$the_port = 80;
		}

		if (substr($location['code'], 0,2) == "US" )
		{ 
                	$request  .= "/weather/local/" . $location['code'] . 
			            "?whatprefs=&GO=GO HTTP/1.1\r\n";
                }
		else
		{
		$request  .= "/outlook/travel/businesstraveler/local/" . $location['code'] . 
			     " HTTP/1.1\r\n";
		}
		$request .= "Host: w3.weather.com\r\n";
		$request .= "Accept: */*\r\n";
		$request .= "Connection: close\r\n";
		$request .= "\r\n\r\n";
		
		$data = '';
		$httpsock = @fsockopen ($the_server, $the_port, $errno, $errstr, $weather_datafeed_timeout);
		if ($httpsock)
		{
			@stream_set_timeout ($httpsock, $weather_datafeed_timeout);
			@fwrite ($httpsock, $request);
			

			/* 
		   	Make a call to TWC -- only wait around 
		   	$weather_datafeed_timeout seconds or bail out 
			*/	

			$timer = time();

			while ( !@feof($httpsock) && (time() < $timer + $weather_datafeed_timeout))
			{
				$data .= @fread ($httpsock, 8192);
			}
			@fclose($httpsock);
			if (isset ($debug) && $debug)
			{	
				$prechunked_data = $data;
			}
			if (preg_match ('/Transfer\-Encoding\:\ chunked/', $data))
                        {
  				$data = Decode_Chunked_Message ($data);
			}
		}
		$temp1 = strstr ($data, "Current Conditions for ");
		if (strlen ($temp1) == 0)
			$temp1 = strstr ($data, "Travel Forecast for");

		$temp0 = strstr ($temp1, "<IMG SRC=http://image.weather.com");
		if ($weather_proxy_icons == TRUE)
		{
			$icon = substr ($temp0, 9 , strpos ($temp0, "WIDTH")) . '>';
			if ($weather_proxy_icons_method != "TRANSPARENT")
			{
				/* Need this little hack to get the image named
				   correctly on the client browswer */
				$icon = preg_replace("/gif/", "png", $icon);
			}
			$icon = '<IMG SRC=' . SM_PATH . 'plugins/twc_weather/twc_image_handler.php?wicon=' . $icon;
		}
                else
		{
			$icon = substr ($temp0, 0 , strpos ($temp0, "WIDTH")) . '>';
 		}
                $citytitle = substr ($temp1, 19, strpos ($temp1, "</B>") - 19);
		
		$temp4 = strstr ($temp0, "obsTempTextA");
		if ($location['use-metric'])
		{
			$temperature = SI_Temperature (substr ($temp4, 13, strpos ($temp4, "&") - 13)) . "&deg;C";
		}
		else
		{
			$temperature = substr ($temp4, 13, strpos ($temp4, "&") - 13) . "&deg;F";
		}
                $temp3 = strstr ($temp0, "obsTextA");
                $conditions = substr ($temp3, 9, strpos ($temp3, "</B") - 9);

		$temp5 = strstr ($data, "Feels Like");
		if ( preg_match ("/(N\/A)+/", substr($temp5, 1, 50), $matches) )
		{
			$feelslike = $temperature;

		}
		else
		{
			if ($location['use-metric']) 
                        {
				$feelslike = SI_Temperature( substr ($temp5, 15, strpos ($temp5, "&deg") - 15)) . "&deg;C";
			}
			else
			{
				$feelslike = substr ($temp5, 15, strpos ($temp5, "&deg") - 15) . "&deg;F";
			}
		}
		$temp6 = strstr ($data, "uv0");
		$uv = substr ($temp6, 4, strpos ($temp6, "&") - 4);

		$temp7 = strstr ($data, "Wind:");
		$temp7 = strstr ($temp7, "obsTextA");
		$wind = substr ($temp7, 10, strpos ($temp7, "</td>") - 10);
		if (strlen (strstr ($wind, "CALM")) > 0) 
		{
			$wind = "Calm";
		}
		else     
		{
			if (strlen (strstr($wind,"From")) > 0)	
			{
				$wind = substr ($wind, 4);
			}
			else
			{
				$wind = strstr ($wind, "Variable");
			}
			$pos_at = strpos ($wind, "at") + 3;
			$pos_mph = strpos ($wind, "mph");
			$temp_dir = substr($wind, 0, $pos_at);
			if (strlen (strstr($wind,"gusting")) > 0)
			{
				$temp_gusting = strstr($wind, "gusting");
				$pos_gusting_to = strpos($temp_gusting, "to") + 3;
				$pos_gusting_mph = strpos ($temp_gusting, "mph");
				$temp_gusting = substr($temp_gusting, $pos_gusting_to, $pos_gusting_mph - $pos_gusting_to  );
			}
			else
			{
				$temp_gusting = "";
			}
			$wind = substr ($wind , $pos_at , $pos_mph - $pos_at);
			if ($location['use-metric'])
			{
				$wind = SI_Speed($wind, $location['wind-units']);
				if (strlen ($temp_gusting) == 0)
				{
					$wind .= " " . $location['wind-units'];
				}
			}
			else
			{	
				$wind .= "mph";
			}
			$wind = $temp_dir . " " . $wind;

			if ($location['use-metric'] && strlen($temp_gusting) > 0)
			{
				$wind .= " gusting to ". SI_Speed($temp_gusting, $location['wind-units']) . " ". $location['wind-units'];
			}
		}

		
		$temp8 = strstr ($data, "Dew Point:");
		$temp8 = strstr ($temp8, "obsTextA");
		$dew = substr ($temp8, 10, strpos ($temp8, "&") - 10);
		if ($location['use-metric'] == 1)
		{	
			$dew = SI_Temperature ($dew) . '&deg;C';
		}
		else
		{
			$dew .= '&deg;F';
		}

		$temp9 = strstr ($data, "Humidity:");
		$temp9 = strstr ($temp9, "obsTextA");
		$humidity = substr ($temp9, 10, strpos ($temp9, "</td>") - 10);

		$temp10 = strstr ($data, "Visibility:");
		$temp10 = strstr ($temp10, "obsTextA");	
		$visibility = substr ($temp10, 10, strpos ($temp10, "</td") - 10);
		if (strncmp ($visibility, 'Unlimited', 8) == 0)
		{
			$visibility = 'Unlimited';
		}
		elseif (strlen ($visibility == 0))
		{
			$visibility = 'N/A';	
		}
		else
		{	
			$pos_mile = strpos ($visibility, "mile");
			$visibility = substr ($visibility, 0, $pos_mile);

			if ($location['use-metric'])
			{
				$visibility = SI_Distance ($visibility) . " km";			
			}
			else
			{
				$visibility .= " miles";
		 	}
		}
		$temp11 = strstr ($data, "Pressure");
		$temp11 = strstr ($temp11, "obsTextA");
		$bar_direction = strstr($temp11, "<IMG SRC");
		$bar_direction = substr ($bar_direction, 0, strpos ($bar_direction, '</td>') - 0);
		$bar_icon1 = substr ($bar_direction, 0, strpos ($bar_direction, "\n") - 0);
	  	$bar_icon2 = strstr ($bar_direction, "WIDTH");
		$bar_icon2 = strstr ($bar_icon2, "http://");
	
		if ($weather_proxy_icons == TRUE)
                { 
			$bar_icon1 = strstr($bar_icon1, "http://");
			$bar_icon1 = substr($bar_icon1, 0, strpos ($bar_icon1, '" WIDTH'));
			if ($weather_proxy_icons_method != "TRANSPARENT")
                        {	
				$bar_icon1 = preg_replace("/gif/", "png", $bar_icon1);
                        }
                        $bar_icon1 = '<IMG SRC=' . SM_PATH . 'plugins/twc_weather/twc_image_handler.php?wicon=' . $bar_icon1 . '>'; 
                	
			$bar_icon2 = strstr($bar_icon2, "http://");
			$bar_icon2 = substr ($bar_icon2, 0, -2);
                        if ($weather_proxy_icons_method != "TRANSPARENT")
                        {
                                $bar_icon2 = preg_replace("/gif/", "png", $bar_icon2);
                        }
                        $bar_icon2 = '<IMG SRC=' . SM_PATH . 'plugins/twc_weather/twc_image_handler.php?wicon=' . $bar_icon2 . '>';
	
			$bar_direction = $bar_icon1 . $bar_icon2;
			$fp = fopen ('/tmp/twc-debug.log', 'w');
                	fwrite ($fp, "icon1: $bar_direction\n");
                	fclose ($fp);
		}

		$barometer = substr ($temp11, 10, strpos ($temp11, "&nbsp") - 10);
                
		$pressure_units = $location['pressure-units'];
		
		if ($location['use-metric'])
		{
			$barometer = SI_Pressure ($barometer, $pressure_units) . " $pressure_units";
		}
		else
		{
			$barometer = $barometer . " in";
		}
		$barometer .= " $bar_direction";

		if (strncmp ($feelslike, "N/A", 3) == 0)
		{
			$feelslike = $temperature;
		}

		$narrative = weather_narrative($location, $theid);
		
                if ($location['use-metric'])
                {
                        $narrative = SI_Narrative($narrative, $location['wind-units']);
                }
		else
		{
			$narrative = fixEnglishNarrative($narrative);
		}
/*
   If we set the $debug then we will dump our vars and the
   the reply from TWC to /tmp (assuming you have permissions to write to /tmp

*/
		if (isset ($debug) && $debug===TRUE)
		{
			global $weather_debug_dir;
			$fp = fopen ($weather_debug_dir . '/twc_weather-vars.log', 'a');
			fwrite ($fp, "Server: $the_server\n");
			fwrite ($fp, "Port: $the_port\n");
                	fwrite ($fp, "Request: $request\n");
			fwrite ($fp, "City: $citytitle\n");
			fwrite ($fp, "Icon: $icon\n");
                	fwrite ($fp, "Temperature: $temperature\n");
                	fwrite ($fp, "Conditions: $conditions\n");
                	fwrite ($fp, "Feels Like: $feelslike\n");
                	fwrite ($fp, "UV: $uv\n");
                	fwrite ($fp, "Wind: $wind\n");
			fwrite ($fp, "Wind Units: " . $location['wind-units'] . "\n");
                	fwrite ($fp, "Dew: $dew\n");
                	fwrite ($fp, "Visibility: $visibility\n");
			fwrite ($fp, "Humidity: $humidity\n");
                	fwrite ($fp, "Barometer: $barometer\n");
                	fwrite ($fp, "Pressure Units: '" . $location['pressure-units'] . "'\n");
			fwrite ($fp, "Narrative: $narrative\n");
			fwrite ($fp, "Use Metric: " . $location['use-metric'] . "\n");
			fwrite ($fp, "Narrow: " . $location['forecast-narrow'] . "\n");
			fwrite ($fp, "Proxy: " . $weather_proxy . "\n");
			fwrite ($fp, "Min Cache: " . $weather_cache_time_minimum . "\n");
			fwrite ($fp, "Max Locales: " . $weather_location_amount . "\n");	                
			fwrite ($fp, "Timeout: " . $weather_datafeed_timeout . "\n");
			fwrite ($fp, "Debug: " . $debug . "\n\n");
			fclose ($fp);

			$fp = fopen ($weather_debug_dir. '/twc_weather-data.log', 'a');
			fwrite ($fp, "Pre-Chunk: \n" . $prechunked_data. "\n\n");
                	fwrite ($fp, "Post-Chunk: \n" . $data . "\n\n");
                	fclose ($fp);  

		}

		setPref ($data_dir, $username, "twc_weather".$theid,
			$location['code']."\\".
			$location['place']."\\".
			$location['position']."\\".
			$location['view-temp']."\\".
			$location['view-feels']."\\".
			$location['view-conditions']."\\".
			$location['view-uv']."\\".
			$location['view-wind']."\\".
			$location['view-dew']."\\".
			$location['view-humidity']."\\".
			$location['view-visibility']."\\".
			$location['view-barometer']."\\".
			$thetime."\\".
			$citytitle."\\".
			$temperature."\\".
			$feelslike."\\".
			$conditions."\\".
			$uv."\\".
			$wind."\\".
			$dew."\\".
			$humidity."\\".
			$visibility."\\".
			$barometer."\\".
			$location['cachetime']."\\".
			$location['viewable']."\\".
			$location['width']."\\".
			$location['margin-right']."\\".
			$location['margin-left']."\\".
			$location['margin-top']."\\".
			$location['margin-bottom']."\\".
			$location['color-background']."\\".
			$location['color-foreground']."\\".
			$location['color-label']."\\".
			$location['color-value']."\\".
			$location['view-place']."\\".
			$location['view-alias']."\\".
			$location['view-icon']."\\".
			$location['alias']."\\".
			$icon."\\".
			$location['view-narrative']."\\".
			$narrative."\\".
			$location['narrative-days']."\\".
			$location['use-metric']."\\".
			$location['forecast-narrow']."\\".
			$location['wind-units']."\\".
			$location['pressure-units']);
	}
	else
	{
		$citytitle = $location['cache-name'];
		$conditions = $location['cache-conditions'];
		$temperature = $location['cache-temp'];
		$feelslike = $location['cache-feels'];
		$uv = $location['cache-uv'];
		$wind = $location['cache-wind'];
		$dew = $location['cache-dew'];
		$humidity = $location['cache-humidity'];
		$visibility = $location['cache-visibility'];
		$barometer = $location['cache-barometer'];
		$pressure_units = $location['pressure-units'];
		$icon = $location['icon'];
		$narrative = $location['narrative'];
	}

	if (!$location['viewable'])
	{
		return;
	}

	if ($location['position'] == "after")
	{
		print "<br>";
	}

	if ($location['width'])
	{
		$table_width = $location['width'];
		$table_width2 = $table_width - 2;
	}
	else
	{
		$table_width = 200;  //$left_size - 12;
		$table_width2 = $table_width - 2;
	}

	if ($location['margin-right'])
	{
		$table_margin_right = $location['margin-right'];
	}
	else
	{
		$table_margin_right = 4;
	}

	if ($location['margin-left'])
	{
		$table_margin_left = $location['margin-left'];
	}
	else
	{
		$table_margin_left = 4;
	}

	if ($location['margin-top'])
	{
		$table_margin_top = $location['margin-top'];
	}
	else
	{
		$table_margin_top = 4;
	}

	if ($location['margin-bottom'])
	{
		$table_margin_bottom = $location['margin-bottom'];
	}
	else
	{
		$table_margin_bottom = 4;
	}

	if ($location['color-background'])
	{
		$table_color_background = $location['color-background'];
	}
	else
	{
		$table_color_background = $color[9];
	}

	if ($location['color-foreground'])
	{
		$table_color_foreground = $location['color-foreground'];
	}
	else
	{
		$table_color_foreground = $color[3];
	}

	if ($location['color-label'])
	{
		$table_color_label = $location['color-label'];
	}
	else
	{
		$table_color_label = $color[6];
	}

	if ($location['color-value'])
	{
		$table_color_value = $location['color-value'];
	}
	else
	{
		$table_color_value = $color[11];
	}


	print "<table style=\"margin-left: " . $table_margin_left . "px; margin-right: " . $table_margin_right . "px; margin-top: " . $table_margin_top . "px; margin-bottom: " . $table_margin_bottom . "px;\" cellpadding=1 cellspacing=0 border=0 bgcolor=" . $table_color_background . " width=" . $table_width . ">";
	print "<tr><td><table cellpadding=0 cellspacing=0 border=0  width=" . $table_width2 . " bgcolor=" . $table_color_foreground . ">";

        print "<tr>";
        $colspan = '';
 	if ($location['view-icon'])
	{
	        print "<td align=left width=\"20%\" style=\"padding-left: 6px\">";
		print $icon;
 		print "</td>";
		$align = "left";
 	}
	else
	{
		$align = "center";
		$colspan = "colspan=2";
	}
	if ($location['view-place'])
                print "<td align=" . $align . " " . $colspan . " width=\"80%\"><b><font face=\"helvetica\" style=\"font-size:10pt;\" color=" . $table_color_label . ">" . $citytitle . "</font></b></td></tr>";

        if ($location['view-alias'])
                print "<td align=". $align ." ". $colspan . "><b><font face=\"helvetica\" style=\"font-size: 10pt;\" color=" . $table_color_label . ">" . $location['alias'] . "</font></b><br></td></tr>";

	if ($location['view-temp'])        
	print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Temperature:") . "</font></td><td align=left style=\"padding-left: 0px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $temperature . "</font></td></tr>";
		
	if ($location['view-feels'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Feels Like:") . "</font></td><td><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $feelslike . "</font></td></tr>";

	if ($location['view-conditions'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Conditions:") . "</font></td><td><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $conditions . "</font></td></tr>";

	if ($location['view-uv'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("UV Index:") . "</font></td><td><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $uv . "</font></td></tr>";

	if ($location['view-wind'])
		print "<tr><td align=left valign=top style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Wind:") . "</font></td><td><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $wind . "</font></td></tr>";

	if ($location['view-dew'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Dew Point:") . "</font></td><td><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $dew . "</font></td></tr>";

	if ($location['view-humidity'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Humidity:") . "</font></td><td><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $humidity . "</font></td></tr>";

	if ($location['view-visibility'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Visibility:") . "</font></td><td><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $visibility . "</font></td></tr>";

	if ($location['view-barometer'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Barometer:") . "</font></td><td><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $barometer . "</font></td></tr>";

	if ($location['view-narrative'])
	{
		if ($location['forecast-narrow'])
		{
			print "<tr><td valign=top style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Forecast:") . "</font></td><td align=left valign=top><font face=\"helvetica\" style=\"font-size: 8pt;\" color=";
		}
		else
		{
                	print "<tr><td valign=top style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Forecast:") . "</font></td><td>&nbsp;</td></tr><tr><td align=left valign=top colspan=2 style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=";
		}

	print $table_color_value . ">" . $narrative . "</font></td></tr>";
	}	

	print "<tr><td colspan=2 style=\"padding-top: 6px; padding-left: 6px; padding-right: 6px; text-align: center\" align=left><a href=\"http://www.weather.com"; 

	if (strpos ($location['place'], "US") === false)
	{
		print "/outlook/travel/local/";
	}
	else
	{	print "/weather/local/";
	}
	print $location['code'] . "\" target=\"top\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">www.weather.com</font></a></td></tr>";
	print "</table></td></tr></table>";

	if ($location['position'] == "before")
	{
		print "<br>";
	}

	return;

}
?>
