<?php
/******************************************************************************

$Log: options.php,v $
Revision 1.21  2004/10/02 06:00:17  jamuel
Updates to support user selectable barometric pressure SI units as hPa
or kPa.

Also fixed a nagging bug in the options screen that caused non-
US locations to be tagged not found because the weather code was not being
used.  The new functionality is if the Location doesn't change (i.e. some
other attributes are changed) the script doesn't attempt to validate the
location (since it ought to still be good shouldn't it).

Revision 1.20  2004/09/29 00:39:14  jamuel
Minor updates to I18n related code.  Also bumped version and README
in preparation for 1.3 beta 3 release.

Revision 1.19  2004/09/28 04:59:24  jamuel
Reworked all string outputs to support I18n

Revision 1.18  2004/09/27 16:52:06  jamuel
Major overhaul to eliminate most all (I hope) E_ALL info messages.

Revision 1.17  2004/09/27 05:07:07  jamuel
Add option for user selectable wind speed SI units: km/h or m/s from the
options.php screen.  Had to do a lot of re-rigging of the wind speed
parsers.  Also bit the bullet and started eliminating E_ALL info messages.

Revision 1.16  2004/09/22 20:51:00  jamuel
Multiple commits to get up to 1.2 RC2a with a fix to options.php that was
causing blank pages when clicking Hide or Show on locations.

Revision 1.22  2003/09/23 00:01:50  jamuel
Mostly hacks to twc_support to enable transparent wicon proxying.  Also
worked on weather.php to handle mangling of the wicon URL correctly
so that a PNG is called a PNG and a GIF called a GIF when/where appropriate.

Config has a new setting to deal with the transparent proxying.

Revision 1.21  2003/05/26 18:40:44  jamuel

options template function was displaying the previous location name/alias
when creating a new location--sort of confusing.  So just display ""'s
instead for the place and alias (and code).

Revision 1.20  2003/05/26 17:58:25  jamuel

Major changes to bring in 1.2 features (weather location templates) and
the TWC URL fix

Revision 1.19  2003/04/24 01:19:13  jamuel

Minor bug fix to check if SM_PATH is already defined.  Code was colliding
with some other plugins according to reports.

Revision 1.18  2003/04/07 16:35:45  jamuel

Well I'm defining SM_PATH I might as well use it require strings.php

Revision 1.17  2003/04/06 19:43:35  jamuel

Looks like strings.php (in SM functions) uses SM_PATH without it first
being defined.  Options.php was require_once'ing strings.php to determine
the SM_VERSION to see how to deal with paths to plugins.  Move the SM_PATH
definition up above the require_once.

Revision 1.16  2003/02/26 07:30:30  jamuel

Fixed a gaff in the Feels Like parser--wasn't handling N/A correctly from
TWC.

Also added an option to display the forecast narrative across the
entire length of the weather box as opposed to just the right side aligned
with the other weather values.  This option is per location and the default
is to display in the new "wide" format.  If you want the old "narrow" format
just select "Narrow Format" for the particular location.

Thanks to Stephen Brown for the contributed code.

Finally changed the units for Barometric Pressure from mb's to KPa's based
on user feedback.  Apparently KPa are the units typically expressed in
Europe. KPa's are 10% of millibars.

Revision 1.15  2003/02/08 18:13:54  jamuel

Changed support.php to twc_support.php to eliminate conflicts in how this
file is required_once with other plug-ins using the same name.

Revision 1.14  2003/02/08 08:06:12  jamuel

Full metric conversion support (the best I can tell) for all of the
possible weather values from the datafeed.  Lots of trickery in the parser
especially for Winds and Barometric Pressure. Can determine Variable and
Gusty winds and can now show steady/rising/falling pressure indications.

Revision 1.13  2003/02/07 18:17:09  jamuel


After many request, and much over due--I've added support for metric (SI)
unit display.  Added a couple of conversion functions in support.php
that are called by weather.php when the weather values are parsed from
the datafeed.  A check is made to see if the user wanted metrics displayed
via the location setup/edit screen in twc_weather options.

The only trick left to implement would be to do something similar for
the weather narrative (forecasts)--which currently ONLY supports english
units.  So if the user selects metrics right now, atleast, the narrative
will still be display abeit in english units.

Stay tuned . . .

Revision 1.12  2002/12/16 22:28:52  jamuel


In my eternal quest for slickness (back when I implemented) Aliases the
locations are displayed by Location or by Alias in the location listing
(when you pull up the TWC Weather Options page).  The logic went--that if
you were using an Alias then I would display the Alias in the list as
opposed to the Location.  Well a rev or do back when I fixed the
inconsistencies of my usage of weather_code vs weather_place the
fact that the location list used weather_code instead of correctly
using weather_place went un-noticed in my testing--since I'm such a big fan
of Aliases.  Therefore after my code vs place fix, if a user only
used a Location and not an alias the listing would show the NOAA/NWS Location
ID (i.e. the weather_code!!!)  So the simple fix (with along with long winded
explanation) amounts to nothing more than swapping "place" for "code" at the
tail-end of options.php and bumping the beta rev in the README.

Revision 1.11  2002/12/13 00:38:16  jamuel


Got to fancy when adding back the chdir for 1.2.x support and just added
"cd" instead of chdir.  Still don't quite know why when I tested under
1.2.9 that it didn't fail.  :(  Beta testers are a good thing! ;)

Revision 1.10  2002/12/12 18:59:08  jamuel


Added SM version checking support.  Now correctly determines SM version by
parsing $version from SM's strings.php so that the correct foo is done to
the plug-in path's based on 1.2.x vs 1.3.x

Revision 1.9  2002/12/12 00:37:56  jamuel


Fixed major logic bomb that had weather_code and weather_place getting
mix/matched when setting prefs mostly in options.php.  Also added minor
tweak to weather.php that was compensating for options.php previously.

Issue boils down mainly that I had my notion of weather_code and weather_place
screwed up in my head since I was playing tricks with weather_code when
multiple hits were found when adding a new location (place).

Also definitively determined that rg=Off is NOT supported under 1.2.x since
(I think) database support is broken when retriving prefs (getPrefs)
via the MySQL hack.  Since I don't have a non-MySQL based user prefs
running to test SM with file-based prefs I can't say for certain as
to whether twc_weather will run under 1.2.x with rg = Off and file-base
user prefs turned on. twc_weather does, however, run with rg = On.  Finally,
under SM_1.3.x twc_weather does indeed support rg = Off (or On).

Revision 1.8  2002/11/24 21:56:30  jamuel

Weather.com updated the datafeed again.  Have rehacked the parser text to
properly capture the datafeed.  Enjoy!

Revision 1.7  2002/11/21 07:40:07  jamuel

Updated code for use with register_globals = Off in PHP.  Should now support
SM 1.3.x code base with rg=Off.

Revision 1.6  2002/11/19 21:47:25  jamuel

Added SM_PATH support to beginning of file (and removed chinky `chdir').
Also deleted some extraneous debug commands that were not removed from a
prior update session.  Plugin now works with SM 1.3.2 with
register_globals = ON *only* for now . . .

Revision 1.5  2002/07/22 22:39:42  jamuel

Added drop-down selector for user to choose the # of days worth of narrative
forecasts to display instead of the hardcoded three (3).

The trick is TWC splits the current and next day into at least two seperate
narratives per day so weather.php has to juggle what a "day" means when it
iterates thru the narrative text presented by twc.  Currently days = 1-->2
forecasts days = 2-->4 forecasts, days = 3-->5 forecasts, etc.  This gets
a little sloppy at the end of a day since there is only 1 forecast for the
current day so even though you select 2 days, for example, you get Tonight,
2 Tomorrows, and the next day--instead of just Tonight and Tomorrow.  When
I get the courage to smarten up the parser logic I'll implement a fix--until
then fagettaboutit.

Finally, I added some logic that if Forecasts are ON and the # of Days
are set to 0 then 3 forecasts will be displayed.

Revision 1.4  2002/07/19 18:28:00  jamuel

Fixed predicted bug in "Changes saved." feedback when submit generates a
"not found" or "multiple locations" error.  Also added a case when "delete"
is clicked.  Finally, added feature to display Alias as the location when
presenting locations to Edit, Delete, Hide. So if an Alias is something
other than a zero length string ("") it will be displayed, otherwise
the Location (Code) used for the search is displayed.

Revision 1.3  2002/07/19 17:16:33  jamuel

Added Display Option allowing for extended (narrative) forecast.  Standard
checkbox . . .  Also update Prefs as well.  Also added feedback to user
when Submit occurs to indicate "Changes saved".  Currently there is no
error checking other than a Location Not/Multiple Locations Found message.
Probably need to regression test this feature (look for another potential
commit).  Finally, found a tiny bug in how chunky.php was included-originally
had a hardwired path to plugin--now referenced as the current directory
of the weather plugin.


*******************************************************************************/

if(!defined('SM_PATH'))
{	
	define('SM_PATH','../../');
}
require_once (SM_PATH . 'functions/strings.php');
require_once ('twc_support.php');

/* SM Version Checking */

if (twc_weather_check_SM_version (1, 3, 2))
{
	require_once (SM_PATH . 'include/validate.php');
	require_once (SM_PATH . 'functions/page_header.php');
	require_once (SM_PATH . 'include/load_prefs.php');
	require_once (SM_PATH . 'plugins/twc_weather/config.php');
	require_once (SM_PATH . 'plugins/twc_weather/chunky.php');
}
else
{

        require_once ('config.php');
        require_once ('chunky.php');
	
	chdir ('..');
        require_once ('../src/validate.php');
        require_once ('../functions/page_header.php');
        require_once ('../src/load_prefs.php');

}
include_once(SM_PATH . 'functions/i18n.php');
/* Now tell gettext where the locale directory for your plugin is
 * this is in relation to the src/ directory
 */
bindtextdomain('twc_weather', SM_PATH . 'plugins/twc_weather/locale');
/* Switch to your plugin domain so your messages get translated */  
textdomain('twc_weather');

/* Fix for RG = off */
$multi_selected = FALSE;
$not_found = FALSE;
if (isset($_POST['weather_submit']))
{	
	$weather_submit = $_POST['weather_submit'];
	extract($_POST);
}
else
{	
	if (isset ($_GET['action']))
	{
		$action = $_GET['action'];
	}
	else
	{
		$action = '';
	} 
	if (isset($_GET['theid']))
	{
		$theid = $_GET['theid'];
	}
	else
	{
		$theid = '';
	}
	$weather_code = '';
	extract($_GET);
}

if (isset ($weather_submit))
{
	if (isset ($_POST['weather_code']))
		$weather_code = $_POST['weather_code'];
	else
		$weather_code = '';
		
	if (isset ($_POST['weather_place']))
		$weather_place = $_POST['weather_place'];
	
	if (isset ($_POST['weather_view_place']))
		$weather_view_place = $_POST['weather_view_place'];
	if (isset ($_POST['weather_view_temp']))
		$weather_view_temp = $_POST['weather_view_temp']; 
	if (isset ($_POST['weather_view_feels']))
		$weather_view_feels = $_POST['weather_view_feels'];
	if (isset ($_POST['$weather_view_conditions']))
		$weather_view_conditions = $_POST['weather_view_conditions']; 
	if (isset ($_POST['$weather_view_uv']))
		$weather_view_uv = $_POST['weather_view_uv'];
	if (isset ($_POST['weather_view_wind']))
		$weather_view_wind = $_POST['weather_view_wind']; 
	if (isset ($_POST['weather_view_dew']))
		$weather_view_dew = $_POST['weather_view_dew'];
	if (isset ($_POST['weather_view_humidity']))
		$weather_view_humidity = $_POST['weather_view_humidity']; 
	if (isset ($_POST['weather_view_visibility']))
		$weather_view_visibility = $_POST['weather_view_visibility'];
	if (isset ($_POST['weather_view_barometer']))
		$weather_view_barometer = $_POST['weather_view_barometer'];
	if (isset ($_POST['weather_view_alias']))
		$weather_view_alias = $_POST['weather_view_alias'];
	if (isset ($_POST['weather_view_icon']))
		$weather_view_icon = $_POST['weather_view_icon'];
	if (isset ($_POST['weather_view_narrative']))
		$weather_view_narrative = $_POST['weather_view_narrative']; 
	if (isset ($_POST['weather_view_narrative_days']))
		$weather_narrative_days = $_POST['weather_narrative_days'];
	if (isset ($_POST['weather_alias']))
		$weather_alias = $_POST['weather_alias'];
	if (isset ($_POST['weather_position']))
		$weather_position = $_POST['weather_position'];
	if (isset ($_POST['weather_cachetime']))
		$weather_cachetime = $_POST['weather_cachetime'];
	if (isset ($_POST['weather_viewable']))
		$weather_viewable = $_POST['weather_viewable'];
	if (isset ($_POST['weather_width']))
		$weather_width = $_POST['weather_width'];
        if (isset ($_POST['weather_margin_right']))
        	$weather_margin_right = $_POST['weather_margin_right'];
        if (isset ($_POST['weather_margin_left']))
        	$weather_margin_left = $_POST['weather_margin_left'];
        if (isset ($_POST['weather_margin_top']))
        	$weather_margin_top = $_POST['weather_margin_top'];
        if (isset ($_POST['weather_margin_bottom']))
        	$weather_margin_bottom = $_POST['weather_margin_bottom'];
        if (isset ($_POST['weather_color_background']))
        	$weather_color_background = $_POST['weather_color_background'];
        if (isset ($_POST['weather_color_foreground']))
        	$weather_color_foreground = $_POST['weather_color_foreground'];
        if (isset ($_POST['weather_color_label']))
        	$weather_color_label = $_POST['weather_color_label'];
        if (isset ($_POST['weather_color_value']))
        	$weather_color_value = $_POST['weather_color_value'];
        if (isset ($_POST['weather_view_place']))
        	$weather_view_place = $_POST['weather_view_place'];
	if (isset ($_POST['weather_use_metric']))
		$weather_use_metric = $_POST['weather_use_metric'];
	if (isset ($_POST['weather_forecast_narrow']))
		$weather_forecast_narrow = $_POST['weather_forecast_narrow'];
	if (isset ($_POST['weather_wind_units']))
		$weather_wind_units = $_POST['weather_wind_units'];
	if (isset ($_POST['weather_pressure_units']))
		$weather_pressure_units = $_POST['weather_pressure_units'];
	if (isset ($_POST['multi_flag']))
		$multi_flag = $_POST['multi_flag'];
	if (isset ($_POST['theid']))
		$theid = $_POST['theid'];
	if (isset ($_POST['action']))
		$action = $_POST['action'];
	if (isset ($_POST['weather_old_place']))
		$old_place = $_POST['weather_old_place'];
	else
		$old_place ='';
		
	if (isset ($multi_flag))
	{
		$multi_selected = TRUE;
	}
	if (!isset ($action))
		$action = '';
		
	if (!isset ($theid))
		$theid = 0;

	//$weather_code = ucwords (strtolower ($weather_code));

	if (!isset ($weather_view_place))
		$weather_view_place = 0;

	if (!isset ($weather_view_temp))
		$weather_view_temp = 0;

	if (!isset ($weather_view_feels))
		$weather_view_feels = 0;

	if (!isset ($weather_view_conditions))
		$weather_view_conditions = 0;

	if (!isset ($weather_view_uv))
		$weather_view_uv = 0;

	if (!isset ($weather_view_wind))
		$weather_view_wind = 0;

	if (!isset ($weather_view_dew))
		$weather_view_dew = 0;

	if (!isset ($weather_view_humidity))
		$weather_view_humidity = 0;

	if (!isset ($weather_view_visibility))
		$weather_view_visibility = 0;

	if (!isset ($weather_view_barometer))
		$weather_view_barometer = 0;

        if (!isset ($weather_view_alias))
                $weather_view_alias = 0;

        if (!isset ($weather_view_icon))
                $weather_view_icon = 0;

        if (!isset ($weather_view_narrative))
                $weather_view_narrative = 0;

        if (!isset ($weather_narrative_days))
                $weather_narrative_days = 0;

	if (!isset ($weather_use_metric))
		$weather_use_metric = 0;

	if (!isset ($weather_forecast_narrow))
		$weather_forecast_narrow = 0;
	if (!isset ($weather_wind_units))
		$weather_wind_units = 'km/h';
	if (!isset ($weather_pressure_units))
		$weather_pressure_units = 'hPa';
	if (!($multi_selected))
	{
		$fp = fopen ('/tmp/twc_options.log' , 'a');
		fwrite ($fp, "Place: $weather_place\n");
		fwrite ($fp, "Old Place: $old_place\n");
		fwrite ($fp, "Code: $weather_code\n\n");
		
		if ($weather_code == '' || $weather_place != $old_place)
		{ 
			$weather_code = $weather_place;
        	
        		$request  = "POST /search/search HTTP/1.1\r\n";	
        		$request .= "Host: www.weather.com\r\n";
			$request .= "Accept: */*\r\n";
			$request .= "Connection: close\r\n";
			$request .= "Content-Type: application/x-www-form-urlencoded\r\n";

			$req_len = strlen(urlencode ($weather_code) . "where=&what=WeatherCity&whatprefs=&GO=GO");

			$request .= "Content-Length: ". $req_len . "\r\n\r\n";
			$request .= "where=" . urlencode ($weather_code) . "&what=WeatherCity&whatprefs=&GO=GO";
			$request .= "\r\n\r\n";

			$httpsock = fsockopen ("www.weather.com", 80);
			fwrite ($httpsock, $request);
			$data = "";

			while (!feof ($httpsock))
			{
				$data .= fread ($httpsock, 1024);
			}
			$not_found = FALSE;
			if (!strlen(strstr($data, "HTTP/1.1 302 Moved Temporarily")) > 0) 
			{
				if (strpos($data, "We did not find a match") > 0)
				{	
					$not_found = TRUE;
				}
				elseif (strpos($data, "Search Results") > 0 && strpos($data, "Cities") > 0)
				{
					$multi_selected = TRUE;
				}
				else
				{
					$not_found = TRUE;
				}
				$action = "edit";
			}
			if (!($multi_selected))
			{
				$temp32 = strstr ($data, "Location:");
				$weather_place = strstr ($temp32, "local/");
        			if (strlen ($weather_place) > 0)
        			{
                			$weather_place = substr($weather_place, 6, strpos($weather_place, "?", 6) - 6);
					$temp_code = $weather_place;
					$weather_place = $weather_code;
					$weather_code = $temp_code;
        			}
			}
			else
			{
				$temp32 = strstr (Decode_Chunked_Message($data), "Cities");
				$multi_codes = array();
				while ( strlen(strstr ($temp32, "local/")) > 0)
				{
					$temp32 = strstr ($temp32, "<a href=\"");	/* Data is trimmed upto first City Code */
					$temp_code = substr (strstr ($temp32, "local/"), 6, strpos ($temp32, "?") - 24);
					$temp32 = strstr ($temp32, "whatprefs=");
					$temp_description = substr($temp32, 12, strpos ($temp32, "</a>") -12);
					$multi_codes[$temp_code] = $temp_description;
				}
				reset ($multi_codes);
				$weather_place = key($multi_codes);
			}
		}  
	}	
	if ($multi_selected && isset ($multi_flag))
	{
		$temp_place = $weather_code;
		
		$weather_place = ${$weather_code};
		$multi_selected = FALSE;
	}	
	if (!isset ($weather_icon))
		$weather_icon = '';
	if (!isset ($weather_narrative))
		$weather_narrative = '';
			
	if (!($not_found) && !($multi_selected))
	{
				
			setPref ($data_dir, $username, "twc_weather".$theid,
				$weather_code."\\".
				$weather_place."\\".
				$weather_position."\\".
				$weather_view_temp."\\".
				$weather_view_feels."\\".
				$weather_view_conditions."\\".
				$weather_view_uv."\\".
				$weather_view_wind."\\".
				$weather_view_dew."\\".
				$weather_view_humidity."\\".
				$weather_view_visibility."\\".
				$weather_view_barometer."\\".
				"0\\\\\\\\\\\\\\\\\\\\\\".
				$weather_cachetime."\\".
				$weather_viewable."\\".
				$weather_width."\\".
				$weather_margin_right."\\".
				$weather_margin_left."\\".
				$weather_margin_top."\\".
				$weather_margin_bottom."\\".
				$weather_color_background."\\".
				$weather_color_foreground."\\".
				$weather_color_label."\\".
				$weather_color_value."\\".
				$weather_view_place."\\".
				$weather_view_alias."\\".
				$weather_view_icon."\\".
				$weather_alias."\\".
				$weather_icon."\\".
				$weather_view_narrative."\\".
				$weather_narrative."\\".
				$weather_narrative_days."\\".
				$weather_use_metric."\\".
				$weather_forecast_narrow . "\\".
				$weather_wind_units . "\\".
				$weather_pressure_units);
	}
	$locations[$theid]['code'] = $weather_code;
	$locations[$theid]['place'] = $weather_place;
	$locations[$theid]['position'] = $weather_position;
	$locations[$theid]['view-temp'] = $weather_view_temp;
	$locations[$theid]['view-feels'] = $weather_view_feels;
	$locations[$theid]['view-conditions'] = $weather_view_conditions;
	$locations[$theid]['view-uv'] = $weather_view_uv;
	$locations[$theid]['view-wind'] = $weather_view_wind;
	$locations[$theid]['view-dew'] = $weather_view_dew;
	$locations[$theid]['view-humidity'] = $weather_view_humidity;
	$locations[$theid]['view-visibility'] = $weather_view_visibility;
	$locations[$theid]['view-barometer'] = $weather_view_barometer;
	$locations[$theid]['view-place'] = $weather_view_place;
	$locations[$theid]['viewable'] = $weather_viewable;
	$locations[$theid]['view-alias'] = $weather_view_alias;
	$locations[$theid]['view-icon'] = $weather_view_icon;
	$locations[$theid]['alias'] = $weather_alias;
	$locations[$theid]['icon'] = $weather_icon;
	$locations[$theid]['view-narrative'] = $weather_view_narrative;
	$locations[$theid]['narrative'] = $weather_narrative;
	$locations[$theid]['narrative-days'] = $weather_narrative_days;
	$locations[$theid]['use-metric'] = $weather_use_metric;
	$locations[$theid]['forecast-narrow'] = $weather_forecast_narrow;
	$locations[$theid]['wind-units'] = $weather_wind_units;
	$locations[$theid]['pressure-units'] = $weather_pressure_units;	
}
elseif ($action == 'delete')
{
	remove_location ($theid);
}
elseif ($action == 'visible' || $action == 'hidden')
{
	$locations = load_locations ();

	if ($action == 'visible')
	{
		$locations[$theid]['viewable'] = 1;
	}
	else
	{
		$locations[$theid]['viewable'] = 0;
	}
	setPref ($data_dir, $username, "twc_weather".$theid,
                $locations[$theid]['code']."\\".
                $locations[$theid]['place']."\\".
                $locations[$theid]['position']."\\".
                $locations[$theid]['view-temp']."\\".
                $locations[$theid]['view-feels']."\\".
                $locations[$theid]['view-conditions']."\\".
                $locations[$theid]['view-uv']."\\".
                $locations[$theid]['view-wind']."\\".
                $locations[$theid]['view-dew']."\\".
                $locations[$theid]['view-humidity']."\\".
                $locations[$theid]['view-visibility']."\\".
                $locations[$theid]['view-barometer']."\\".

		"0\\\\\\\\\\\\\\\\\\\\\\".
                $locations[$theid]['cachetime']."\\".

                $locations[$theid]['viewable']."\\".
                $locations[$theid]['width']."\\".
                $locations[$theid]['margin-right']."\\".
                $locations[$theid]['margin-left']."\\".
                $locations[$theid]['margin-top']."\\".
                $locations[$theid]['margin-bottom']."\\".
                $locations[$theid]['color-background']."\\".
                $locations[$theid]['color-foreground']."\\".
                $locations[$theid]['color-label']."\\".
                $locations[$theid]['color-value']."\\".

                $locations[$theid]['view-place']."\\".
		$locations[$theid]['view-alias']."\\".
        	$locations[$theid]['view-icon']."\\".
        	$locations[$theid]['alias']."\\".
        	$locations[$theid]['icon']."\\".
 		$locations[$theid]['view-narrative']."\\".
        	$locations[$theid]['narrative']."\\".
		$locations[$theid]['narrative-days']."\\".
		$locations[$theid]['use-metric']."\\".
		$locations[$theid]['forecast-narrow']."\\".
		$locations[$theid]['wind-units']."\\".
		$locations[$theid]['pressure-units']);
}
if (!isset ($weather_submit))
	$weather_submit = 0;

$locations = load_locations ();

bindtextdomain('squirrelmail', SM_PATH . 'locale');
textdomain('squirrelmail');

displayPageHeader($color, 'None');

bindtextdomain('twc_weather', SM_PATH . 'plugins/twc_weather/locale');
textdomain('twc_weather');

	echo	'<br>' .
		'<table width=95% align=center border=0 cellpadding=2 cellspacing=0>'.
		"<tr><td bgcolor=\"$color[0]\">\r\n";
// Only show New - Done  headers if not editing a location
if ($action == 'edit') {
		echo '<center><b>' . _("Options") . ' -  ' . _("TWC Weather") . 
		' - ' . _("Edit Location") . '</b></center>';
}
elseif ($action == 'add') {
	echo '<center><b>' . _("Options") . ' -  ' . _("TWC Weather") . 
	' - ' . _("Add Location") . '</b></center>';
}
else {
	echo '<center><b>' . _("Options") . ' -  ' . _("TWC Weather") . '</b></center>';
	echo
	"<table WIDTH=\"100%\" BORDER=\"0\" CELLPADDING=\"5\" CELLSPACING=\"0\" BGCOLOR=\"" . $color[4] . "\"><TR><td ALIGN=\"CENTER\">".
	'<br><center>[<a href="options.php?action=add">' . _("New") .
	'</a>] - [<a href="../../src/options.php">' . _("Done") . '</a>]</center><br>'.
	'</TD></TR></TABLE>';
}

if ($action == 'add' || $action == 'edit')
{
	if ( $theid == '' )
	{
		$theid = count ($locations);
		$new_addition = TRUE;

		// Set some defaults so that people don't get confused

		// We can optionally pull from the last location if this
		// user has > 1 location set up
		if ($theid > 0) {
			if (isset($location_def['nth-source']) && $location_def['nth-source'] == 'last') {
				// Pull from previous one
				foreach ($locations[$theid-1] as $key => $value) 
				{
					if ($key == "place" || $key == "alias" || $key == "code")
					{
						// Don't want to confuse things
						// by displaying the previous place/alias/code
						// just the previous options selected.

					 	$value = "";
					}
						$locations[$theid][$key] = $value;

				}
				$locations[$theid]['already_set'] = 1;
			}
		}
		// Look in config.php for the $location_def hash
		if (empty($locations[$theid]['already_set'])) {
			foreach ($location_def as $key => $value) {
				$locations[$theid][$key] = $value;
			}
		}
	}
	elseif ($not_found || $multi_selected)
	{
		$locations[$theid]['code'] = $weather_code;
        	$locations[$theid]['place'] = $weather_place;
        	$locations[$theid]['position'] = $weather_position;
        	$locations[$theid]['view-temp'] = $weather_view_temp;
        	$locations[$theid]['view-feels'] = $weather_view_feels;
        	$locations[$theid]['view-conditions'] = $weather_view_conditions;
        	$locations[$theid]['view-uv'] = $weather_view_uv;
        	$locations[$theid]['view-wind'] = $weather_view_wind;
        	$locations[$theid]['view-dew'] = $weather_view_dew;
        	$locations[$theid]['view-humidity'] = $weather_view_humidity;
        	$locations[$theid]['view-visibility'] = $weather_view_visibility;
        	$locations[$theid]['view-barometer'] = $weather_view_barometer;
        	$locations[$theid]['view-place'] = $weather_view_place;
		$locations[$theid]['viewable'] = $weather_viewable;
		$locations[$theid]['view-alias'] = $weather_view_alias;
        	$locations[$theid]['view-icon'] = $weather_view_icon;
        	$locations[$theid]['alias'] = $weather_alias;
        	$locations[$theid]['icon'] = $weather_icon;
		$locations[$theid]['view-narrative'] = $weather_view_narrative;
        	$locations[$theid]['narrative'] = $weather_narrative;
		$locations[$theid]['narrative-days'] = $weather_narrative_days;
		$locations[$theid]['use-metric'] = $weather_use_metric;
		$locations[$theid]['forecast-narrow'] = $weather_forecast_narrow;
		$locations[$theid]['wind-units'] = $weather_wind_units;
		$locations[$theid]['pressure-units'] = $weather_pressure_units;
	}

echo    "<table WIDTH=\"100%\" BORDER=\"0\" CELLPADDING=\"5\" CELLSPACING=\"0\" BGCOLOR=\"" . $color[4] . "\"><TR><td ALIGN=\"LEFT\" style=\"padding-left: 10px; padding-bottom: 10px;\">".
        _("For the location, you can enter a US Zip code, a city, state/country (or some combination to search). For example you could use either: \"94521\", \"San Francisco, CA\", \"New York\", \"Rome, Italy\", etc.") .
        '</TD></TR></TABLE>';

	echo	"<table cellpadding=2 cellspacing=0 border=0 WIDTH=\"100%\" BGCOLOR=\"" . $color[4] . "\">".
		'<tr>'.
		'<td align=left width="20%" style="padding-left: 20px;"><form action="options.php" method=post>'.
		_("Location:") .
		'</td>' .
		'<td width="6%">&nbsp;</td><td align=left width="74%">';

	if ($multi_selected)
	{
		echo  '<input type=hidden name="multi_flag" value=' . $multi_selected . '>' .
		      '<select name="weather_code">';
		foreach ($multi_codes as $temp_location => $temp_code)
		{ 
			echo '<option value="' . $temp_location. '">'. $temp_code;
		}
		echo '</select>  <font color=#ff0000>* choose one!</font>';

		foreach ($multi_codes as $temp_location => $temp_code)
		{
                             echo '<input type=hidden name="' . $temp_location . 
				  '" value="' . $temp_code . '">';
		}
	
	}
	else
	{
		if (isset ($locations[$theid]['code']))
			$code = $locations[$theid]['code'];
		else
			$code = '';
			
		echo '<input type=hidden name="weather_code" value="' . $code . '">';
		
		echo '<input type=text size=32 maxlen=32 name=weather_place value="';	
	    	if ($weather_submit)
                {
                        echo $weather_code . '">';
                }	
		elseif (isset ($locations[$theid]['place']))
		{
			if (strpos($locations[$theid]['place'], ", United States") > 0)
			{
				echo substr($locations[$theid]['place'], 0, 
					strlen($locations[$theid]['place']) - 15) . '">';
				echo '<input type=hidden name="weather_old_place" value="' ;
				echo substr($locations[$theid]['place'], 0, 
					strlen($locations[$theid]['place']) - 15) . '">';
				 
			}
			else 
			{
				echo $locations[$theid]['place'] . '">';
				echo '<input type=hidden name="weather_old_place" value="' ;
				echo $locations[$theid]['place'] . '">';
				
			}
		}else
			echo '">';
	}
	if ($not_found)
	{
		echo '<font color=#ff0000> * location not found, try again!</font>';
	}

	echo	'<br></td>'.
		'</tr>'.
		'<tr><td align=left width="20%" style="padding-left: 20px;">' .
                _("Alias:") .
                '</td>'.
                '<td width="6%">&nbsp;</td><td align=left width="74%">'.
                '<input type=text size=32 maxlen=32 name=weather_alias value="';
		if (isset ($locations[$theid]['alias']))
		{
                	echo $locations[$theid]["alias"];
		}
        echo    '"><br>'.
                '</td>'.
                '</tr>'.
		"\n<tr>".
                '<td align=left style="padding-left: 20px;">' . _("Display Position:") . '</td>'.
                '<td>&nbsp;</td><td>'.
                '<select name="weather_position">';
	if ($locations[$theid]['position'] == "before")
	{
		echo	'<option value=before selected>' . _("Above folder list").
			'<option value=after>' . _("Below folder list");
	}
	else
	{
		echo	'<option value=before>'. _("Above folder list") .
			'<option value=after selected>' . _("Below folder list");
			
	}
        echo	'</select>'.
		'<br></td>'.
		"</tr>\n".

                '<tr>'.
                '<td align=left width="20%" style="padding-left: 20px;">'.
                _("Cache Time:").
                '</td>'.
                '<td width="6%">&nbsp;</td><td align=left width="74%">'.
                '<input type=text size=10 maxlen=10 name=weather_cachetime value="';

        if (isset ($locations[$theid]['cachetime']))
        {
                echo $locations[$theid]["cachetime"];
        }
	elseif ($weather_cache_time_minimum <= 3600)
	{
		echo "3600";
	}
	else
	{
		echo $weather_cache_time_minimum;
	}

        echo    '">'.
                '</td>'.
                '</tr>'.

		'</table>'.

        "<table WIDTH=\"100%\" BORDER=\"0\" CELLPADDING=\"5\" " .
	"CELLSPACING=\"0\" BGCOLOR=\"" . 
	$color[4] . "\"><TR><td ALIGN=\"LEFT\" style=\"padding-left: 10px;\">".
        '<br>' . _("Select which of the following information you want displayed for this location:") .
        '</TD></TR></TABLE>'.

	"\n<table cellpadding=2 cellspacing=0 border=0 WIDTH=\"100%\" BGCOLOR=\"" . $color[4] . "\">".
		'<tr>'.
		'<td width="30%" align=left valign=middle style="padding-left: 20px;">'.
		_("Alias:").
		"</td>\n".
		'<td width="20%" align=left valign=middle>';
	

        if (isset ($locations[$theid]['view-alias']))
        {
        	if ($locations[$theid]['view-alias'] == 0)
        	{
                	echo    '<input type=checkbox name=weather_view_alias '. 
				'value=1>';
        	}
        	else
        	{
                	echo    '<input type=checkbox name=weather_view_alias value=1 '.
				' checked>';
        	}
        }
	else
        {
               	echo    '<input type=checkbox name=weather_view_alias value=1 '.
			' checked>';
        }
        echo    '</td>'.

                '<td align=left valign=middle width="30%">'.
                _("Weather Icon:").
                '</td>'.
                '<td align=left valign=middle width="20%">';

        if ($locations[$theid]['view-icon'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_icon value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_icon value=1 ' .
			'checked>';
        }

        echo    '</td>'.
                '</tr>'.

		'<tr>'.
                '<td width="30%" align=left valign=middle '.
		'style="padding-left: 20px;">'.
                _("Temperature:").
                '</td>'.
                '<td width="20%" align=left valign=middle>';

	if ($locations[$theid]['view-temp'] == 0)
	{
		echo	'<input type=checkbox name=weather_view_temp value=1>';
	}
	else
	{
		echo	'<input type=checkbox name=weather_view_temp value=1 '.
			'checked>';
	}

	echo	'</td>'.

		'<td align=left valign=middle width="30%">'.
		_("Feels Like:").
		'</td>'.
		'<td align=left valign=middle width="20%">';
	if ($locations[$theid]['view-feels'] == 0)
	{
		echo	'<input type=checkbox name=weather_view_feels '.
			'value=1>';
	}
	else
	{
		echo	'<input type=checkbox name=weather_view_feels value=1 '.
			'checked>';
	}

	echo	'</td>'.
		'</tr>'.
                '<tr>'.
                '<td align=left valign=middle style="padding-left: 20px;">'.
                _("Conditions:").
                '</td>'.
                '<td align=left valign=middle>';
        if ($locations[$theid]['view-conditions'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_conditions '.
			'value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_conditions '. 
			'value=1 checked>';
        }

        echo    '</td>'.

                '<td align=left valign=middle>'.
                _("UV Index:").
                '</td>'.
                '<td align=left valign=middle>';
        if ($locations[$theid]['view-uv'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_uv value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_uv value=1 ' .
			'checked>';
        }

        echo    '</td>'.
                '</tr>'.

                '<tr>'.
                '<td align=left valign=middle style="padding-left: 20px;">'.
                _("Wind:").
                '</td>'.
                '<td align=left valign=middle>';
        if ($locations[$theid]['view-wind'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_wind value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_wind value=1 '.
			'checked>';
        }

        echo    '</td>'.

                '<td align=left valign=middle>'.
                _("Dew Point:").
                '</td>'.
                '<td align=left valign=middle>';
        if ($locations[$theid]['view-dew'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_dew value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_dew value=1 '.
			'checked>';
        }

        echo    '</td>'.
                "</tr>\r\n".

                '<tr>'.
                '<td align=left valign=middle style="padding-left: 20px;">'.
                _("Humidity:").
                '</td>'.
                '<td align=left valign=middle>';
        if ($locations[$theid]['view-humidity'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_humidity ' .
			'value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_humidity '. 
			'value=1 checked>';
        }

        echo    '</td>'.

                '<td align=left valign=middle>'.
                _("Visibility:").
                '</td>'.
                '<td align=left valign=middle>';
        if ($locations[$theid]['view-visibility'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_visibility '. 
			'value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_visibility '.
			'value=1 checked>';
        }

        echo    '</td>'.
                '</tr>'.

                '<tr>'.
                '<td align=left valign=middle style="padding-left: 20px;">'.
                _("Barometer:").
                '</td>'.
                '<td align=left valign=middle>';
        if ($locations[$theid]['view-barometer'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_barometer ' . 
			'value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_barometer ' . 
			'value=1 checked>';
        }
        
	echo '<select name="weather_pressure_units">';
	
	echo '<option value="kPa"';
	if ($locations[$theid]['pressure-units'] == 'kPa')
		echo ' selected';
	echo '>kPa</option>';
	
	echo '<option value="hPa"';
	if ($locations[$theid]['pressure-units'] == 'hPa')
		echo ' selected';
	
	echo '>hPa</option>';
	echo '</select>';
        echo    '</td>'.

                '<td align=left valign=middle>'.
		
		 _("Forecast:").
                '</td>'.
                '<td align=left valign=middle>';
        if ($locations[$theid]['view-narrative'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_narrative value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_narrative '.
			'value=1 checked>';
        }

        echo    '</td>'.
                '</tr>'.
		'<tr>'.
                '<td align=left valign=middle style="padding-left: 20px;">'.
                _("Location:").
                '</td>'.
                '<td align=left valign=middle>';

        if ($locations[$theid]['view-place'] == 0)
        {
                echo    '<input type=checkbox name=weather_view_place value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_view_place value=1'.
			' checked>';
        }
        echo    '</td>';

/* Extended Forecast Days */

	echo 	'<td align=left valign=middle>'.
                _("Extended Forecast Days:").
                '</td>'.
                '<td align=left valign=middle>'.
		'<select name=weather_narrative_days>';
                for ($i = 0; $i <= 7; $i++ )
                {       
                        echo "<option value='$i'";
					if (
					$locations[$theid]['narrative-days'] == $i) {
							echo " selected ";
						}
						echo "> $i</option>\n";
                }       
	echo 	'</select>'.
        	'</td>'.
                '</tr>';

/* Metric Conversion */

        echo    '<tr>'.
		'<td align=left valign=middle style="padding-left: 20px;">'.
                _("Metric SI Units:").
                '</td>'.
                '<td align=left valign=middle>';

	if ($locations[$theid]['use-metric'] == 0)
	{
		echo '<input type=checkbox name=weather_use_metric value=1>';
	}
	else
	{
		echo '<input type=checkbox name=weather_use_metric value=1 checked>';
	}
	echo '<select name="weather_wind_units">';
	
	echo '<option value="km/h"';
	if ($locations[$theid]['wind-units'] == 'km/h')
		echo ' selected';
	echo '>km/h</option>';
	
	echo '<option value="m/s"';
	if ($locations[$theid]['wind-units'] == 'm/s')
		echo ' selected';
	
	echo '>m/s</option>';
	echo '</select>';
	echo    '</td>';
/*Place Holder */

	echo	'<td align=left valign=middle>'.
		_("&nbsp;").
		'</td>'.
		'<td align=left valign=middle>'.
		'&nbsp;</td>'.
		'</tr>'.
		'</table>';

/*		
		'</td></tr>'. 
Netscape fix
		'</table>'
*/
echo    "<table WIDTH=\"100%\" BORDER=\"0\" CELLPADDING=\"5\" " .
	"CELLSPACING=\"0\" BGCOLOR=\"" . $color[4] . "\">";
echo	"<TR>".
	"<td ALIGN=\"LEFT\" style=\"padding-left: 10px; padding-bottom: 10px;\"><BR>".
        _("The following options are to control the appearance of the display") .  
	_("box. If the field is left blank, the default values will be used. In ") .
	_("the case of the colors, the default values are based on the current ") . 
	_("theme.") .
        '</TD></TR></TABLE>';
        echo    "<table cellpadding=2 cellspacing=0 border=0 WIDTH=\"100%\" " .
		"BGCOLOR=\"" . $color[4] . "\">".
                '<tr>'.
                '<td align=left width=24% style="padding-left: 20px;">'.
                _("Show this location:").
                '</td>'.
                '<td width="26%" align=left>';
        if ($locations[$theid]['viewable'] == 0)
        {
                echo    '<input type=checkbox name=weather_viewable value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_viewable value=1 checked>';
        }

        echo    '</td></tr>'.
                
                '<tr><td align=left width="24%" style="padding-left: 20px;">'.
                _("Narrow Forecast:").
                '</td>'.
                '<td align=left width="26%">';

        if ($locations[$theid]['forecast-narrow'] == 0)
        {
                echo    '<input type=checkbox name=weather_forecast_narrow value=1>';
        }
        else
        {
                echo    '<input type=checkbox name=weather_forecast_narrow value=1 checked>';
        }


	echo	'</td></tr><tr></tr>';
include_once(SM_PATH . 'functions/i18n.php');
/* Now tell gettext where the locale directory for your plugin is
 * this is in relation to the src/ directory
 */
bindtextdomain('twc_weather', SM_PATH . 'plugins/twc_weather/locale');
/* Switch to your plugin domain so your messages get translated */  
textdomain('twc_weather');

        echo  	'<tr>'.
                '<td align=left style="padding-left: 20px;">'.
                _("Box Width:").
                '</td>'.
                '<td align=left valign=middle>'.
                '<input type=text size=7 maxlen=7 name=weather_width value="';

        if (isset ($locations[$theid]['width']))
        {
                echo $locations[$theid]["width"];
        }

        echo    '">';

        echo	'</tr><tr>'.
                '<td align=left width="26%" style="padding-left: 20px;">'.
                _("Margin - Right:").
                '</td>'.
                '<td align=left width="24%">'.
                '<input type=text size=7 maxlen=7 name=weather_margin_right value="';

        if (isset ($locations[$theid]['margin-right']))
        {
                echo $locations[$theid]["margin-right"];
        }

        echo    '">'.
                '</td>'.

                '<td align=left width="26%" style="padding-left: 10px;">'.
                _("Margin - Left:").
                '</td>'.
                '<td align=left width="24%">'.
                '<input type=text size=7 maxlen=7 name=weather_margin_left value="';

        if (isset ($locations[$theid]['margin-left']))
        {
                echo $locations[$theid]["margin-left"];
        }

        echo    '">'.
                '</td>'.
		'</tr>'.

                '<tr>'.
                '<td align=left" style="padding-left: 20px;">'.
                _("Margin - Top:").
                '</td>'.
                '<td align=left>'.
                '<input type=text size=7 maxlen=7 name=weather_margin_top value="';

        if (isset ($locations[$theid]['margin-top']))
        {
                echo $locations[$theid]["margin-top"];
        }

        echo    '">'.
                '</td>'.

                '<td align=left style="padding-left: 10px;">'.
                _("Margin - Bottom:").
                '</td>'.
                '<td align=left>'.
                '<input type=text size=7 maxlen=7 name=weather_margin_bottom value="';

        if (isset ($locations[$theid]['margin-bottom']))
        {
                echo $locations[$theid]["margin-bottom"];
        }

        echo    '">'.
                '</td>'.
                '</tr>'.

                '<tr>'.
                '<td align=left style="padding-left: 20px;">'.
                _("Color - Background:").
                '</td>'.
                '<td align=left>'.
                '<input type=text size=7 maxlen=7 name=weather_color_background value="';

        if (isset ($locations[$theid]['color-background']))
        {
                echo $locations[$theid]["color-background"];
        }

        echo    '">'.
                '</td>'.

                '<td align=left style="padding-left: 10px;">'.
                _("Color - Foreground:").
                '</td>'.
                '<td align=left>'.
                '<input type=text size=7 maxlen=7 name=weather_color_foreground value="';

        if (isset ($locations[$theid]['color-foreground']))
        {
                echo $locations[$theid]["color-foreground"];
        }

        echo    '">'.
                '</td>'.
                '</tr>'.

                '<tr>'.
                '<td align=left style="padding-left: 20px;">'.
                _("Color - Labels:").
                '</td>'.
                '<td align=left>'.
                '<input type=text size=7 maxlen=7 name=weather_color_label value="';

        if (isset ($locations[$theid]['color-label']))
        {
                echo $locations[$theid]["color-label"];
        }

        echo    '">'.
                '</td>'.

                '<td align=left style="padding-left: 10px;">'.
                _("Color - Values:").
                '</td>'.
                '<td align=left>'.
                '<input type=text size=7 maxlen=7 name=weather_color_value value="';

        if (isset ($locations[$theid]['color-value']))
        {
                echo $locations[$theid]["color-value"];
        }

        echo    '">'.
                '</td>'.
                '</tr>'.
		'</table>'.

		"<table cellpadding=2 cellspacing=0 border=0 WIDTH=\"100%\" ".
		"BGCOLOR=\"" . 
		$color[4] . "\"><tr><td align=center>".
		'<br><input type=submit name=weather_submit value=' . 
		_("Submit") . '>'.
		'&nbsp;<input type=submit name=ignore_me value=' . _("Cancel"). 
		'>'.
		"<input type=hidden name=theid value=$theid>" . 
		'</form></td></tr></table>';
}
if ( ($weather_submit && !$multi_selected && !$not_found) || $action == 'delete')
{
        echo    "<table align=center WIDTH=\"100%\" BORDER=\"0\" ".
		"CELLPADDING=\"5\" CELLSPACING=\"0\" BGCOLOR=\"" .

                $color[4] . "\"><TR><TD ALIGN=\"CENTER\">".
                "<center><B><H3>Changes saved.</H3><B></center><BR>".
                '</TD></TR></TABLE>';
}
echo	"<table border=0 cellpadding=3 cellspacing=0 align=center " .
	"WIDTH=\"100%\" BGCOLOR=\"" . $color[4] . "\">".
	'<tr><td><table border=0 cellpadding=3 cellspacing=0 align=center>';

if (($not_found) || ($multi_selected) ) 
{
	$locations_count = count ($locations) - 1;
}
else
{
	$locations_count = count ($locations);
}

// Hide list of other locations to edit if editing one right now
if ($action == '' || $action == 'delete' || $action == 'hidden' || 
	$action == 'visible') {

	$bgcolor = $color[0];
	if ($locations_count == 0)
	{
		echo "<tr bcolor='$bgcolor'><td><a href='".
		$_SERVER['PHP_SELF']."?action=add'>".
		_("Add a new location to get started")."</a></td></tr>\n";
	}
	for ($i = 0; $i < $locations_count; $i++)
	{
		$bgcolor = (($i % 2) ? $color[0] : $color[9]);

		echo	"<tr bgcolor=\"$bgcolor\"><td><small>".
			"[<a href=\"options.php?theid=$i&action=edit\">" . 
			_("Edit") . '</a>]'.
			'</small></td><td><small>'.
			"[<a href=\"options.php?theid=$i&action=delete\">" .
			 _("Delete") . '</a>]'.
			'</small></td><td><small>';

		if ($locations[$i]['viewable'])
		{
			echo "[<a href=\"options.php?theid=$i&action=hidden\">" . 
			_("Hide") . '</a>]';
		}
		else
		{
			echo "[<a href=\"options.php?theid=$i&action=visible\">" 
			. _("Show") . '</a>]';
		}

		echo	'</small></td>';

		echo	'<td>-</td><td>';
		if ($locations[$i]['alias'] != "" )
		{
			$temp_location = $locations[$i]['alias'];
		}
		else
		{
			$temp_location = $locations[$i]['place'];
		}
		printf ( _("Location: <b>%s</b>"), _($temp_location));
		echo '</td></tr>';
	}
} // not editing a location right now

echo	'</table></td></tr></table>'.
	"<table width=100% align=center border=0 cellpadding=2 cellspacing=0 " .
	"bgcolor=\"" . $color[4] . "\">".
	'<tr><td>&nbsp</td></tr>'.
	'</table></td></tr></table></td></tr></table>';

/* Switch back to the SquirrelMail domain */
bindtextdomain('squirrelmail', SM_PATH . 'locale');
textdomain('squirrelmail');

exit;

?>
