<?php

/***************************************************************************************************/
require_once ('twc_support.php');

/* SM Version Checking */

global $debug;

if (isset ($debug) && $debug===TRUE)
{
    $fp = fopen($weather_debug_dir ."twc_weather-debug.log", "w");
    fwrite ($fp, "SM Version: " . twc_weather_check_SM_version (1,3,2) . "\n\n");
    fclose($fp);
}

if (twc_weather_check_SM_version (1, 3, 2))
{       
	if(!defined('SM_PATH'))
	{
		define('SM_PATH','../../');
	}
        require_once (SM_PATH . 'plugins/twc_weather/weather.php');
	require_once (SM_PATH . 'plugins/twc_weather/config.php');
}
else
{
        require_once ('weather.php');
	require_once ('config.php');
}

function squirrelmail_plugin_init_twc_weather()
{
	global $squirrelmail_plugin_hooks;
	$squirrelmail_plugin_hooks['left_main_before']['twc_weather'] = 'twc_weather_show_before';
	$squirrelmail_plugin_hooks['left_main_after']['twc_weather'] = 'twc_weather_show_after';
	$squirrelmail_plugin_hooks['optpage_register_block']['twc_weather'] = 'twc_weather_optpage_register_block';

	return;
}

function twc_weather_show_before ()
{
	$locations = load_locations ();
	for ($i = 0; $i < count ($locations); $i++)
	{
		if ($locations[$i]['position'] == "before")
		{
			weather_display ($locations[$i], $i);
		}
	}

	return;
}


function twc_weather_show_after ()
{
	$locations = load_locations ();
	for ($i = 0; $i < count ($locations); $i++)
	{
		if ($locations[$i]['position'] == "after")
		{
			weather_display ($locations[$i], $i);
		}
	}

	return;
}

function twc_weather_optpage_register_block ()
{
	global $optpage_blocks;

	$optpage_blocks[] = array (
		'name' => _("TWC Weather"),
		'url'  => '../plugins/twc_weather/options.php',
		'desc' => _("Setup the weather displaying options. You can add all the cities you want to monitor as well as various options to display."),
		'js'   => false);

	return;
}

?>
