<?php

/*

***************************************************************************************************/
/*
 *  The purpose of this file is for the system administrator (or webmail
 *  administrator) to set limits on the options users can select.
 */


global $weather_debug_dir, $weather_proxy, $weather_proxy_icons, 
       $weather_cache_time_minimum, $weather_location_amount, 
       $weather_datafeed_timeout, $debug;

/*
 *  If $debug is TRUE then debug files for the plugin will appear here
 */

$weather_debug_dir = "/tmp";

/*
 *  Proxy - All users to contact the www.weather.com site via an http proxy.
 *  Both a server and a port must be specified, or the proxy won't work. The
 *  format is either: "http://www.proxy.com:80/" or "www.proxy.com:80". If it
 *  is left blank, then no proxy will be used.
 */

$weather_proxy = "";

/*
    Set this value to true and the SM server will go out and grab the weather
    icons for the clients rather than the traditional method of providing
    an IMG SRC URL to the icons source location (on weather.com).  In order
    to use this option PHP will need to have GD support (including GIF read
    and PNG write functions) enabled.  You probably need streams support
    as well.

    Since this is just beta code there are no formal checks for library
    support.  Caveat Emptor ;)

*/

$weather_proxy_icons = FALSE;

/*
 *  Cache Time - Set this for the minimum cache time a user may select. The
 *  weather information is only updated hourly on the weather.com site. There
 *  is no reason to refresh the weather information every time the folder menu
 *  is refreshed if the refresh rate is set low. Some users may not realize
 *  this, and may select to have their weather information cache be very low.
 *  This could definately irritate administrators of heavily used servers.
 *  Recommended value for this it 3600 (3600 secs = 1 hour).
 */

$weather_cache_time_minimum = 3600;


/*
 *  Location Amount - Some users may abuse the purpose of the weather plugin
 *  and add an ungodly amount of locations to monitor. This allows the admin
 *  to limit the amount of locations an individual user may have. There is no
 *  good recommended value, as it depends on the size of the server, as well
 *  as many other factors. I just initially set it to a liberal amount of 10.
 *  Note: this is just the amount of viewable ones. It will not limit the
 *  amount that are permitted to be added.
 */

$weather_location_amount = 10;

/*
    This is the amount of time the plugin will wait on the datafeed to complete
    the transfer in seconds.  Dialup users may need to modify this value to a 
    larger number.  Please note, this number if a timeout for *each* weather
    location--not all of the users locations.

*/

$weather_datafeed_timeout = 15;

if ($debug) 
{
	$fp = fopen ($weather_debug_dir ."/twc_weather-config.log", "w");
	fwrite ($fp, "Proxy: $weather_proxy\n\r");
	fwrite ($fp, "Cache: $weather_cache_time_minimum\n\r");
	fwrite ($fp, "Max Locations: $weather_location_amount\n\r");
	fwrite ($fp, "Timeout: $weather_datafeed_timeout\n\r");
	fclose ($fp);
}


/*
 * Default options when a new location is added
 *
 * Setting some defaults helps avoid the confusion of older versions of the
 * plugin where the newly added location didn't show up after adding it.
 * 
 * The settings below work for me, tweak as you see fit
 *
 * Values correspond to items in the locations array in the code,
 * if new options are added you can just add new values here.
 * Leave elements unset to use their default values
 */

global $location_def;

//
// When a user adds a 2nd or greater location, do we want to
// Pull their defaults from this configuration, or the last
// location they added? 
$location_def['nth-source'] = 'last'; // or 'def' to pull from here

// Probably don't ever want to set these
// Unless you are using on a intranet
// $location_def['code'] = 
// $location_def['place'] = 

// Display position  after|before
// $location_def['position'] = 

// Show the temp
$location_def['view-temp'] = 1;

// Show wind chill/heat index
$location_def['view-feels'] = 1;

// Show conditions
$location_def['view-conditions'] = 1;

// Show UV-Index
$location_def['view-uv'] = 0;

// Show wind speed
$location_def['view-wind'] = 1;

// Show dewpoint
$location_def['view-dew'] = 0;

// Show relative humidity
$location_def['view-humidity'] = 1;

// Show visibality
$location_def['view-visibility'] = 0;

// Show baramoter
$location_def['view-barometer'] = 1;


// Show place (the zip code or city, state)
$location_def['view-place'] = 0;

// Show the location in the left frame?
// You really want this one to be a 1
$location_def['viewable'] = 1;

// Show the aliase for the location 
$location_def['view-alias'] = 1;

// Show conditions icon 
$location_def['view-icon'] = 1;

// The default alias for the default location
// Probably leave unset unless you are setting a default
// location for use in an intranet
//$location_def['alias'] =

// Don't set (url to the icon)
// $location_def['icon'] =

// Show forecast narratave
$location_def['view-narrative'] = 1;

// Don't set (is the actual narrative text)
// $location_def['narrative'] = 

// How many days to show in the forecast
$location_def['narrative-days'] = 1;

// Show units in SI or English?
// $location_def['use-metric'] = 

// Set to 1, this uses the 'narrow' forecast
// that lines up with the right hand side values in the
// location box. Not set, the narritave uses up the full
// width of the location box (the default)
// $location_def['forecast-narrow'] = 


// These control the box size and placement
// In general only width needs to be set.
// If it is set < than the default left pane width
// you can hope to avoid a horiz-scrollbar on the left pane
$location_def['width'] = 135; // good for the 150 default left size

// $location_def['margin-left'] =
// $location_def['margin-right'] =
// $location_def['margin-top'] =
// $location_def['margin-bottom'] =

// Explicit colors to override the theme defaults
// $location_def['color-foreground'] =
// $location_def['color-background'] =
// $location_def['color-label'] =
// $location_def['color-value'] =
?>
