<?php

/*

***************************************************************************************************/
/*
 *  The purpose of this file is for the system administrator (or webmail
 *  administrator) to set limits on the options users can select.
 */


global $weather_debug_dir, $weather_proxy, $weather_cache_time_minimum,
       $weather_location_amount, $weather_datafeed_timeout, $debug;

/*
 *  If $debug is TRUE then debug files for the plugin will appear here
 */

$weather_debug_dir = "/tmp";

/*
 *  Proxy - All users to contact the www.weather.com site via an http proxy.
 *  Both a server and a port must be specified, or the proxy won't work. The
 *  format is either: "http://www.proxy.com:80/" or "www.proxy.com:80". If it
 *  is left blank, then no proxy will be used.
 */

$weather_proxy = "";


/*
 *  Cache Time - Set this for the minimum cache time a user may select. The
 *  weather information is only updated hourly on the weather.com site. There
 *  is no reason to refresh the weather information every time the folder menu
 *  is refreshed if the refresh rate is set low. Some users may not realize
 *  this, and may select to have their weather information cache be very low.
 *  This could definately irritate administrators of heavily used servers.
 *  Recommended value for this it 3600 (3600 secs = 1 hour).
 */

$weather_cache_time_minimum = 3600;


/*
 *  Location Amount - Some users may abuse the purpose of the weather plugin
 *  and add an ungodly amount of locations to monitor. This allows the admin
 *  to limit the amount of locations an individual user may have. There is no
 *  good recommended value, as it depends on the size of the server, as well
 *  as many other factors. I just initially set it to a liberal amount of 10.
 *  Note: this is just the amount of viewable ones. It will not limit the
 *  amount that are permitted to be added.
 */

$weather_location_amount = 10;

/*
    This is the amount of time the plugin will wait on the datafeed to complete
    the transfer in seconds.  Dialup users may need to modify this value to a 
    larger number.  Please note, this number if a timeout for *each* weather
    location--not all of the users locations.

*/

$weather_datafeed_timeout = 15;


if ($debug) 
{
	$fp = fopen ($weather_debug_dir ."/twc_weather-config.log", "w");
	fwrite ($fp, "Proxy: $weather_proxy\n\r");
	fwrite ($fp, "Cache: $weather_cache_time_minimum\n\r");
	fwrite ($fp, "Max Locations: $weather_location_amount\n\r");
	fwrite ($fp, "Timeout: $weather_datafeed_timeout\n\r");
	fclose ($fp);
}

?>
