<?php
  /**
   **  Timeout User (timeout_user) v1.1
   **
   **  By Ray Black III <allah@accessnode.net>
   **  Changes by Paul Lesneiwski <pdontthink@angrynerds.com>
   **  (c) 2001 (GNU GPL - see ../../COPYING)
   **
   **  This plugin monitors page changes in the right-hand frame.
   **  If the right-hand frame doesn't update within a set number
   **  of minutes, then the plugin logs the user out automatically.
   **  
   **  To change the timeout, see the file config.php.
   **/



   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');



// This is the text that appears on the options page
//
function timeout_user_show_options_do()
{

    global $timeout_in_minutes, $allow_user_timeout_config, $username, $data_dir, $javascript_on;

    if (compatibility_check_sm_version(1, 3))
       include_once (SM_PATH . 'plugins/timeout_user/config.php');
    else
       include_once ('../plugins/timeout_user/config.php');

    if (!$allow_user_timeout_config)
        return;

    $timeout_in_minutes = getPref($data_dir, $username, 'timeout_user', $timeout_in_minutes);

    echo "<TR><TD COLSPAN=\"2\">&nbsp;</TD></TR>\n"
       . "<tr><td align=right valign=top>\n".
         _("Automatic Logout Timer (in minutes)") . "</td>\n".
         "<td><input type='text' name='timeout_user_value' size='3' value='"
       . $timeout_in_minutes;
    if ($javascript_on)
       echo "' onChange='a=this.value; b=\"\"; for (i=0;i<a.length;i++) { if (a.charAt(i)>=\"0\" && a.charAt(i)<=\"9\") b += a.charAt(i); } this.value=b;";
    echo "'>\n</td></tr>\n";

}


// Here we save the user's timeout preferences
//
function timeout_user_save_options_do()
{

    global $timeout_user_value, $allow_user_timeout_config, $username, $data_dir;

    if (compatibility_check_sm_version(1, 3))
       include_once (SM_PATH . 'plugins/timeout_user/config.php');
    else
       include_once ('../plugins/timeout_user/config.php');

    if (!$allow_user_timeout_config)
        return;

    compatibility_sqextractGlobalVar('timeout_user_value');

    setPref($data_dir, $username, 'timeout_user', $timeout_user_value);

}


function timeout_user_metatag_do()
{

    global $timeout_in_minutes, $allow_user_timeout_config, $username, $data_dir;

    if (compatibility_check_sm_version(1, 3))
       include_once (SM_PATH . 'plugins/timeout_user/config.php');
    else
       include_once ('../plugins/timeout_user/config.php');

    // get global variables for versions of PHP < 4.1
    //
    if (!compatibility_check_php_version(4, 1)) {
        global $HTTP_SERVER_VARS;
        $_SERVER = $HTTP_SERVER_VARS;
    }


    if ($allow_user_timeout_config)
        $timeout_in_minutes = getPref($data_dir, $username, 'timeout_user', $timeout_in_minutes);

    $timeout = $timeout_in_minutes * 60; // we need this in seconds
    $js_timeout = ($timeout - 5) * 1000; // js needs milliseconds, and this should take precedence over meta

    preg_match('/(.*)\/.*\/.*/', $_SERVER['REQUEST_URI'], $matches);
    $url = $matches[1];

    if (strpos($url, 'plugins') === FALSE)
    {

?>

<META HTTP-EQUIV="REFRESH" CONTENT="<?php echo $timeout; ?>;URL=../src/signout.php?timeout">
<script language="javascript">
<!-- hide from stupid browsers
    var dir_path = window.location.pathname.substr(0,window.location.pathname.lastIndexOf('/'));
    setTimeout('parent.window.location = "" + dir_path + "/../src/signout.php?timeout";' , <?php echo $js_timeout; ?>);
//-->
</script>

<?php

    }
    else
    {
 
?>

<META HTTP-EQUIV="REFRESH" CONTENT="<?php echo $timeout; ?>;URL=../../src/signout.php?timeout">
<script language="javascript">
<!-- hide from stupid browsers
    var dir_path = window.location.pathname.substr(0,window.location.pathname.lastIndexOf('/'));
    setTimeout('parent.window.location = "" + dir_path + "/../../src/signout.php?timeout";' , <?php echo $js_timeout; ?>);
//-->
</script>

<?php

    }


} // end timeout_user_metatag_do()



// this function only applies in 1.1.2 and beyond
function timeout_user_explanation_do()
{  
     
    global $timeout_in_minutes, $allow_user_timeout_config, $username, $data_dir;

    if (compatibility_check_sm_version(1, 3))
       include_once (SM_PATH . 'plugins/timeout_user/config.php');
    else
       include_once ('../plugins/timeout_user/config.php');

 
    // get global variables for versions of PHP < 4.1
    //
    if (!compatibility_check_php_version(4, 1)) {
        global $HTTP_SERVER_VARS;
        $_SERVER = $HTTP_SERVER_VARS;
    }

    if ($allow_user_timeout_config)
        $timeout_in_minutes = getPref($data_dir, $username, 'timeout_user', $timeout_in_minutes);

    if ( isset($_SERVER['QUERY_STRING']) && stristr($_SERVER['QUERY_STRING'], 'timeout') )
    {
        global $color;
        if (compatibility_check_sm_version(1, 3))
            return '<tr bgcolor="' . $color[4] . '" width="100%"><td align="center"><b>' 
                . $timeout_in_minutes . '</b> ' . _("minutes idle. Logging out automatically.") 
                . "<br></td></tr>\n";
        else
            echo "<br><b>$timeout_in_minutes</b> " . _("minutes idle. Logging out automatically.") . "<br><br>\n";
    }
        
} // end timeout_user_explanation_do()


?>
