<?php

/* Templates Plugin
 * by Ryan Rubley (ryan@morpheussoftware.net)
 * (c) 2003 (GNU GPL - see ../../COPYING)
 *
 * Actual plugin functions are here
 */

include_once(SM_PATH . 'plugins/templates/common.php');

function plugin_templates_compose_button_row() {
	global $data_dir, $username;

      bindtextdomain('templates', SM_PATH . 'locale');
      textdomain('templates');

    if( !getPref($data_dir, $username, 'templates') || soupNazi() ) {
        return;
    }

    // inserting text into html_mail plugin works differently
    //
    $html_insert = FALSE;
    global $plugins, $editor_style;
    if (in_array('html_mail', $plugins)) {
          include_once(SM_PATH . 'plugins/html_mail/functions.php');
          if (html_area_is_on_and_is_supported_by_users_browser())
                $html_insert = TRUE;
    }

    $template_prepend = getPref($data_dir, $username, 'template_prepend');
    $template_preblank = getPref($data_dir, $username, 'template_preblank');
    $template_postblank = getPref($data_dir, $username, 'template_postblank');

?>
    <script type="text/javascript"><!--
        templatetext = new Array();
<?php
    //this is really hairy looking, but I think it works :)
    $js_strtr = array("'"=>"\'", '"'=>'\"', '\\'=>'\\\\', "\r"=>'\r', "\n"=>'\n', "\t"=>'\t');
    $html = '<select name="template">';
    $num = 1;
    while( LoadTemplate( $description, $templatetext, $num ) ) {
		echo "templatetext[$num] = '" . strtr( $templatetext, $js_strtr ) . "';\n";
        $html .= '<option value=' . $num . '>' . $description . "</option>\n";
		$num ++;
    }
?>
        function template_add() {
            var t = templatetext[document.compose.template.value];
			var b = document.compose.body.value, nl = b.indexOf('\r\n')<0?'\n':'\r\n';
<?php if( $template_preblank ) {
            echo 't = nl + t;';
      }
      if( $template_postblank ) {
            echo 't += nl;';
      }

      if( $template_prepend ) { 
            if ($html_insert) {
                  echo 't = t.replace(/\r\n/g, "<br />");'
                     . 'nl = nl.replace(/\r\n/g, "<br />");'
                     . 'b = b.replace(/\r\n/g, "<br />");'
                     . 't = t.replace(/\n/g, "<br />");'
                     . 'nl = nl.replace(/\n/g, "<br />");'
                     . 'b = b.replace(/\n/g, "<br />");'
                     . 't = t.replace(/\r/g, "<br />");'
                     . 'nl = nl.replace(/\r/g, "<br />");'
                     . 'b = b.replace(/\r/g, "<br />");';
                  if ($editor_style == 1)
                        echo 'var oEditor = FCKeditorAPI.GetInstance("body");'
                           . 'if (oEditor.EditMode == FCK_EDITMODE_WYSIWYG) {'
	                   . 'oEditor.InsertHtml(t + nl + b);'
	                   . '} else alert( "' . _("You must be on WYSIWYG mode!") . '");';
                  else if ($editor_style == 2)
                        echo 'editor.insertHTML(t + nl + b)';
            } else {
                  echo 'document.compose.body.value = t + nl + b;';
            }
      } else { 
            if ($html_insert) {
                  echo 'var ss = b.lastIndexOf(nl+'-'+'- '+nl);'
                     . 'if( ss <= 0 ) ss = 0;'
                     . 't = t.replace(/\r\n/g, "<br />");'
                     . 'nl = nl.replace(/\r\n/g, "<br />");'
                     . 'b = b.replace(/\r\n/g, "<br />");'
                     . 't = t.replace(/\n/g, "<br />");'
                     . 'nl = nl.replace(/\n/g, "<br />");'
                     . 'b = b.replace(/\n/g, "<br />");'
                     . 't = t.replace(/\r\n/g, "<br />");'
                     . 'nl = nl.replace(/\r\n/g, "<br />");'
                     . 'b = b.replace(/\r\n/g, "<br />");';
                  if ($editor_style == 1)
                        echo 'var oEditor = FCKeditorAPI.GetInstance("body");'
                           . 'if (oEditor.EditMode == FCK_EDITMODE_WYSIWYG) {'
	                   . 'oEditor.InsertHtml(b.substring(0,ss) + nl + t + b.substring(ss));'
	                   . '} else alert( "' . _("You must be on WYSIWYG mode!") . '");';
                  else if ($editor_style == 2)
                        echo 'editor.insertHTML(b.substring(0,ss) + nl + t + b.substring(ss))';
            } else {
                  echo 'var ss = b.lastIndexOf(nl+'-'+'- '+nl);'
                     . 'if( ss <= 0 ) ss = 0;'
                     . 'document.compose.body.value = b.substring(0,ss) + nl + t + b.substring(ss);';
            }
      } ?>
        }
	//--></script>
<?php

    $html .= "</select>\n" .
        '<input type="button" name="template_button" value="' . _("Add Template") . '" onclick="template_add()">';

    echo $html;

      bindtextdomain ('squirrelmail', SM_PATH . 'locale');
      textdomain ('squirrelmail');

}

function plugin_templates_optpage_register_block() {

      bindtextdomain('templates', SM_PATH . 'locale');
      textdomain('templates');

	global $optpage_blocks;
    $optpage_blocks[] = array(
        'name' => _("Templates"),
        'url' => '../plugins/templates/options.php',
        'desc' => _("Create/Edit/Delete chunks of text that can be quickly added to messages."),
        'js' => FALSE
    );

      bindtextdomain ('squirrelmail', SM_PATH . 'locale');
      textdomain ('squirrelmail');

}

?>
