<?php

/**
  * SquirrelMail SWEKEY Plugin
  * Copyright (c) 2008 Musbe, Inc. (info@musbe.com)
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage swekey
  *
  */


function swekey_init()
{
   if (!@include_once (SM_PATH . 'config/config_swekey.php'))
      if (!@include_once (SM_PATH . 'plugins/swekey/config.php'))
         if (!@include_once (SM_PATH . 'plugins/swekey/config_default.php'))
            return FALSE;
					
   return TRUE;

/* ----------  This is how to do the same thing using the Compatibility plugin
   return load_config('swekey',
                      array('../../config/config_swekey.php',
                            'config.php',
                            'config_default.php'),
                      TRUE, TRUE);
----------- */

}

/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function swekey_check_configuration_do()
{
	// make sure base config is available
	//
	if (! swekey_init())
	{
		do_err('SWEKEY plugin is missing its main configuration file', FALSE);
		return FALSE;
   	}

   // only need to do this pre-1.5.2, as 1.5.2 will make this
   // check for us automatically
   //
   if (!check_sm_version(1, 5, 2))
   {

      // 1.4.10+ gets a pass on Compatibility plugin
      //
      if (check_sm_version(1, 5, 0) || !check_sm_version(1, 4, 10))
      {

         // try to find Compatibility, and then that it is v2.0.7+
         //
         if (function_exists('check_plugin_version')
          && check_plugin_version('compatibility', 2, 0, 7, TRUE))
            return FALSE;

         // something went wrong
         //
         do_err('SWEKEY plugin requires the Compatibility plugin version 2.0.7+', FALSE);
         return TRUE;

      }

   }
}

/**
  * Validate that the correct swekey was plugged
  */
function swekey_validate_do()
{
	global $swekey_check_server, $swekey_status_server, $swekey_rndtoken_server, $swekey_allow_disabled;
	swekey_init();

  	global $login_username, $data_dir, $$login_username, $plugins;
	$user = $login_username;

   // if password_forget is loaded, use the obfuscated name
   if (in_array('password_forget',$plugins))
   {
      if (!isset($$login_username))
         sqGetGlobalVar($login_username, $$login_username, SQ_FORM);

      if ($$login_username != '')
         $user = $$login_username;
   }

	$required_id = getPref($data_dir, $user, 'swekey_id');
	if (strlen($required_id) == 32)
	{
 		global $gSwekeyStatusServer;
    	$gSwekeyStatusServer = $swekey_status_server;
   		include_once('authframeres.inc.php');
    	if (! IsSwekeyAuthenticated($required_id, $swekey_allow_disabled))
    	{
    		sq_change_text_domain('swekey');
    		$error_msg = _("Sorry, you need the swekey $required_id to log in.")
    		.($swekey_allow_disabled ? _("If you want to login without it, you can temporarily disable your swekey at http://managment.swekey.com") : "");
    		sq_change_text_domain('squirrelmail');
    		logout_error($error_msg);
    		exit;
    	}

        // for the autologin
        $ids_file = $data_dir.substr($required_id, 24, 4).'.swekeyids';
        if (file_exists($ids_file))
            $ids = unserialize(@file_get_contents($ids_file));
        else
            $ids = array();
        $ids[substr($required_id, 28, 4)] = $user;
        //file_put_contents($ids_file, serialize($ids));
        $file = fopen  ($ids_file , "w");
        if ($file != FALSE)
        {
        	@fwrite($file, serialize($ids)); 
        	@fclose($file);
        }
        
        // ok we are aurthenticated withy the swekey
        sqsession_register($required_id, 'swekey_used_id');
    }
}

/**
  * Add session id input in the login form
  * I must do it because sometimes the session id
  * changes during the login process
  */
function swekey_show_input_widgets_do()
{
	global $swekey_check_server, $swekey_status_server, $swekey_rndtoken_server, $swekey_allow_disabled;
	swekey_init();

    global $data_dir;
    
    $params = array();
    $params['promo'] = 'squirrelmail';
    $params['swekey_url'] = sqm_baseuri().'plugins/swekey/';

    $params['authframe_url'] = $params['swekey_url'].'authframe.php';
	$params['authframe_url'] .='?check_server='.urlencode($swekey_check_server);
	$params['authframe_url'] .= '&rndtoken_server='.urlencode($swekey_rndtoken_server);
    
    $params['user_logged'] = false;
    
  	global $username_form_name, $plugins;
    if (isset($username_form_name))
    {
		$params['loginname_path'] = '["'.$username_form_name.'"]';
		if (in_array('password_forget',$plugins))
		{
			if ($username_form_name == 'login_username')
			{
				unset($params['loginname_path']);
			}
		}
	}
	else
		$params['loginname_path'] = '["login_username"]';
		
	if (isset($params['loginname_path']))
	{	
	    $params['loginname_resolve_url'] = $params['swekey_url'].'ajax.php?action=resolve&swekey_id=$swekey_id&data_dir='.urlencode($data_dir);
	    $params['image_xoffset'] = '1px';
	    $params['image_yoffset'] = '-2px';
	    $params['loginname_width_offset'] = 16;
	
	    // localized strings
	    $params['str_unplugged'] = _("No swekey plugged");
	    $params['str_plugged'] = _("A swekey is plugged");
	
		include_once('swekey_integrate.inc.php');
	    $output = Swekey_GetIntegrationScript($params);
	}
	else
	{
		$output = '<b><center><br /><font color="red">';
		$output .= 'ERROR: "swekey" plugin must be loaded AFTER the "password_forget" plugin';
		$output .= '</font><h1><br /></center></b>';
	}
	
   // depending on SM version, either return or display output
   if (check_sm_version(1, 5, 2))
      return array('login_form' => $output);
   else if (check_sm_version(1, 5, 1))
      return $output;
   else
      echo $output;
}

/**
  * Script that must be present of all pages 
  */
function swekey_generic_script_do()
{
    global $javascript_on;
    if (!$javascript_on) 
        return;

    global $username, $data_dir,$squirrelmail_plugin_hooks;

    $params = array();
    $params['promo'] = 'squirrelmail';
    $params['swekey_url'] = sqm_baseuri().'plugins/swekey/';
    $params['user_logged'] = (sqGetGlobalVar('user_is_logged_in', $user_is_logged_in, SQ_SESSION) && $user_is_logged_in);
    if ($params['user_logged'])
    {
        $params['logout_url'] = sqm_baseuri().'src/signout.php';
        $params['user_swekey_id'] = getPref($data_dir, $username, 'swekey_id');
        $params['session_id'] = '9999999';
        $params['attach_url'] = $params['swekey_url'].'ajax.php?action=attach&swekey_id=$swekey_id';

        // localized strings
        $params['str_attach_ask'] = _("A swekey authentication key has been detected.\\nDo you want to associate it with your account ?");
        $params['str_attach_success'] = _("The plugged swekey is now attached to your account");
        $params['str_attach_failed'] = _("Failed to attach the plugged swekey to your account");
    }
    
    if (check_sm_version(1, 5, 2))
    {
        global $oTemplate;
        $oTemplate->assign('params', $params, FALSE);
        $oTemplate->display('plugins/swekey/generic_script.tpl');
    }
    else
    {
        include_once(SM_PATH . 'plugins/swekey/swekey_integrate.inc.php');
        echo Swekey_GetIntegrationScript($params);
    }
}


/**
  * Enable or Disable the swekey support for the account
  */
function swekey_optpage_register_block_do() 
{
	global $optpage_blocks;

	sq_change_text_domain('swekey');

    if (sqGetGlobalVar('swekey_used_id', $swekey_used_id, SQ_SESSION) && strlen($swekey_used_id) == 32)
	{
		$optpage_blocks[] = array(
			'name' => _("Disable Swekey Support"),
			'url'  => sqm_baseuri().'plugins/swekey/disable.php',
			'desc' => _("If you click on the above link, your swekey won't be required to login anymore"),
			'js'   => TRUE);
	}

	sq_change_text_domain('squirrelmail');
}

function swekey_optpage_no_op()
{
  return array('grps' => array(), 'vals' => array());
}

function swekey_options_submitted_do()
{
	global $optpage, $optpage_loader, $optpage_file, $optpage_save_error,
		$optpage_title, $optpage_name, $optpage_loadhook, $max_refresh;

	if ($optpage == 'swekey_disabled')
	{
		$optpage_file = SM_PATH . 'plugins/swekey/functions.php';
		$optpage_loader = 'swekey_optpage_no_op';
		sq_change_text_domain('swekey');
		$optpage_name = _("You no longer need a Swekey to log in");
		sq_change_text_domain('squirrelmail');
		$optpage_title = _("Options");
		$max_refresh = SMOPT_REFRESH_NONE;
		$optpage_loadhook = '';
	}
}
