<?php

/**
  * SquirrelMail SWEKEY Plugin
  * Copyright (c) 2008 Musbe, Inc. (info@musbe.com)
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage swekey
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_swekey() {

    global $squirrelmail_plugin_hooks;
    
    // Validate that the correct swekey was plugged
    $squirrelmail_plugin_hooks['login_before']['swekey'] = 'swekey_validate';
        
	$squirrelmail_plugin_hooks['configtest']['swekey'] = 'swekey_check_configuration';

	// Add a link in the option page to be able to detach the swekey from the user account 
    $squirrelmail_plugin_hooks['optpage_register_block']['swekey'] = 'swekey_optpage_register_block';

   // Add the key logo and the authenication frame in the login page
   // SM 1.4.x
   $squirrelmail_plugin_hooks['login_form']['swekey'] = 'swekey_show_input_widgets';
   // SM 1.5.x
   $squirrelmail_plugin_hooks['template_construct_login.tpl']['swekey']  = 'swekey_show_input_widgets';

    // From each page we perform the following:
    // 	- If a user is logged using a swekey and if the swekey is unplugged we logout the user
    // 	- If a user is not logged using a swekey and if a swekey is plugged we propose to accosiate the swekey with his account
	// SM 1.4.x
    $squirrelmail_plugin_hooks['menuline']['swekey'] = 'swekey_generic_script';
   // SM 1.5.x
    $squirrelmail_plugin_hooks['page_header_bottom']['swekey'] = 'swekey_generic_script';
    
    // Display the message in the option page
    $squirrelmail_plugin_hooks['optpage_set_loadinfo']['swekey'] = 'swekey_options_submitted';
}


/**
  * Returns info about this plugin
  *
  */
function swekey_info()
{

   return array(
                 'english_name' => 'Swekey Hardware Authentication',
                 'authors' => array(
                    'Musbe, Inc.' => array(
                       'email' => 'info@musbe.com',
                    ),
                 ),
                 'version' => '1.0.7',
                 'required_sm_version' => '1.2.9',
                 'requires_configuration' => 0,
                 'requires_source_patch' => 0,
                 'summary' => 'Perform Swekey hardware authentication.',
                 'details' => 'The swekey is an USB authentication key. If you use this plugin, swekey owners will be able to secure their squirrelmail access using hardware authentication.',
                 'per_version_requirements' => array(
                    '1.5.2' => array(
                       'required_plugins' => array()
                    ),
                    '1.5.0' => array(
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                    '1.4.10' => array(
                       'required_plugins' => array()
                    ),
                    '1.2.9' => array(
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                 ),
               );

}


/**
  * Returns version info about this plugin
  *
  */
function swekey_version()
{
   $info = swekey_info();
   return $info['version'];

}


/**
  * Show swekey inputs on login page
  *
  */
function swekey_show_input_widgets()
{
   include_once(SM_PATH . 'plugins/swekey/functions.php');
   return swekey_show_input_widgets_do();
}



/**
  * Validate that correct swekey was sent
  *
  */
function swekey_validate()
{
   include_once(SM_PATH . 'plugins/swekey/functions.php');
   swekey_validate_do();

}


/**
  * Add propose and logout handlers
  *
  */
function swekey_generic_script()
{
   include_once(SM_PATH . 'plugins/swekey/functions.php');
   swekey_generic_script_do();
}

/**
  * Validate that correct swekey was sent
  *
  */
function swekey_optpage_register_block()
{
   include_once(SM_PATH . 'plugins/swekey/functions.php');
   swekey_optpage_register_block_do();
}
 
/**
  * Validate that this plugin is configured correctly
  *
  */
function swekey_check_configuration()
{
   include_once(SM_PATH . 'plugins/swekey/functions.php');
   return swekey_check_configuration_do();
}


/**
  * dISPLAY THE VALIDATION DIALOG
  *
  */
function swekey_options_submitted()
{
   include_once(SM_PATH . 'plugins/swekey/functions.php');
   return swekey_options_submitted_do();
}




