<?php

/**
  * SquirrelMail Startup Folder Plugin
  * Copyright (C) 2003 Scott Heavner <sdh@po.cwru.edu>
  * Copyright (C) 2004 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


/**
  * Override Startup Location
  *
  * Called when setting up main frameset, this function 
  * detects if it should be redirecting the startup 
  * location, and if so, adjusts the target location of
  * the right frame
  *
  */
function startup_folder_override()
{

   global $data_dir, $username, $startup_location, $startup_folder,
          $startup_plugin, $startup_allow_user_config, $right_frame;
   include_once(SM_PATH . 'plugins/startup_folder/config.php');


   // can user change startup settings?
   //
   if ($startup_allow_user_config)
   {
      $startup_location = getPref($data_dir, $username, 'startup_location', $startup_location);
      $startup_folder = getPref($data_dir, $username, 'startup_folder_folder', $startup_folder);
      $startup_plugin = getPref($data_dir, $username, 'startup_plugin', $startup_plugin);
   }


   $target_location = '';


   // are we starting with a plugin?
   //
   if ($startup_location == 2 && !empty($startup_plugin))
   {

//LEFT OFF HERE == haven't tested yet!!!
      // plugin startup, forget mailboxes, just go to that plugin's location
      //
      $target_location = '../plugins/' . $startup_plugin;

   }


   // starting with a folder
   //
   else if ($startup_location == 1 && !empty($startup_folder))
   {

//LEFT OFF HERE == haven't tested yet!!!
      // get sort value, same as load_prefs.php
      //
      $sort = getPref($data_dir, $username, 'sort', 6 );


      // tell it what mailbox to go to
      //
      $target_location = "right_main.php?sort=$sort&startMessage=1&mailbox=$startup_folder";

   }


   // redirect to target, but only if right_frame is not already populated
   //
   if (!empty($target_location) && strpos($right_frame, $target_location) === FALSE)
   {

      $right_frame = $target_location;

   }

}



/*
 * Here come the few functions for preference handling.
 * - do some data manipulation to get it into the format required
 *   to use print_option_groups().  this way it should look like
 *   all the rest of the preferences.
 */

function startup_folder_options() {

   global $data_dir, $username, $startup_location, $startup_folder, 
          $startup_plugin, $startup_allow_user_config, $startup_plugin_list;
   include_once(SM_PATH . 'plugins/startup_folder/config.php');


   // can user change startup settings?
   //
   if (!$startup_allow_user_config)
      return;


   $startup_location = getPref($data_dir, $username, 'startup_location', $startup_location);
   $startup_folder = getPref($data_dir, $username, 'startup_folder_folder', $startup_folder);
   $startup_plugin = getPref($data_dir, $username, 'startup_plugin', $startup_plugin);


   // get folder list...
   //
   /* SquirrelMail required files. */
   include_once(SM_PATH . 'functions/imap.php');
   include_once(SM_PATH . 'functions/imap_general.php');

   global $username, $key, $imapServerAddress, $imapPort, $data_dir;

   /* Get some imap data we need later. */
   $imapConnection =
       sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
   $boxes = sqimap_mailbox_list($imapConnection);
   sqimap_logout($imapConnection);


   bindtextdomain('startup_folder', SM_PATH . 'plugins/startup_folder/locale');
   textdomain('startup_folder');


   global $optpage_data;
   $optpage_data['grps']['startup_folder'] = 'Startup Location';
   $optionValues = array();

   $optionValues[] = array(
      'name'          => 'startup_location',
      'caption'       => _("Startup Location"),
      'type'          => SMOPT_TYPE_STRLIST,
      'value'         => $startup_location,
      'refresh'       => SMOPT_REFRESH_NONE,
      'posvals'       => array(0 => _("Off"),
                               1 => _("Folder"),
                               2 => _("Other"))
   );
   $optionValues[] = array(
      'name'          => 'startup_folder_folder',
      'caption'       => _("Startup Folder"),
      'type'          => SMOPT_TYPE_FLDRLIST,
      'posvals'       =>  array('whatever' => $boxes),
      'initial_value' => $startup_folder,
      'refresh'       => SMOPT_REFRESH_NONE
   );
   $optionValues[] = array(
      'name'          => 'startup_plugin',
      'caption'       => _("Other Startup Locations"),
      'type'          => SMOPT_TYPE_STRLIST,
      'value'         => $startup_plugin,
      'refresh'       => SMOPT_REFRESH_NONE,
      'posvals'       => $startup_plugin_list
   );


   $optpage_data['vals']['startup_folder'] = $optionValues;


   bindtextdomain('squirrelmail', SM_PATH . 'locale');
   textdomain('squirrelmail');

}

?>
