<?php
/* startup_folder -- Version 1.0.2 -- functions.php
 * By Scott Heavner
 *
 */

/* SquirrelMail required files. */
include_once(SM_PATH . 'functions/imap.php');
include_once(SM_PATH . 'functions/imap_general.php');

/*
 * Function to add mailbox settings back to the form data if they were left off.
 */

function startup_folder_override() {

  sqgetGlobalVar('mailbox', $mailbox);
  if (isset($mailbox)) {
    return;  // Already set, don't override it
  }

  global $username, $data_dir;
  $override_folder = getPref($data_dir, $username, 'startup_folder_folder');

  if ( $override_folder && $override_folder != "") {

    /* Have to fake these like they came through a form submit */
    global $_POST;
    $_POST['mailbox'] = $override_folder;
    $_POST['startMessage'] = 1;

    /* Do the get's too?  Just in case anyone special requests them from there. */
    global $_GET;
    $_GET['mailbox'] = $override_folder;
    $_GET['startMessage'] = 1;

    /* This really isn't my idea!!!!!
     *
     * mailbox_display.php is BAD and tests PHP_SELF instead of looking in 
     * the GET/POST settings to see if it has a defined mailbox (and it
     * does that by just searcing for the substring 'maibox' which could
     * be anywhere in the url and totally ignores POST data).  So to keep
     * startup_folder a plugin and not a patch, we'll have to carefully update
     * PHP_SELF when we're displaying right_main.php -- then again, this code
     * probably won't be executed from anywhere but right_main.php at login.
     */
    global $PHP_SELF;
    if (!strpos($PHP_SELF,'mailbox') && strpos($PHP_SELF,'right_main.php') ) {
      if ( !strpos($PHP_SELF,'?') ) {
        $PHP_SELF .= '?';
      } else {
        $PHP_SELF .= '&';
      }
      $PHP_SELF .= 'mailbox=' . $override_folder . '&startMessage=1';
    }
  }
}

/*
 * Here come the few functions for preference handling.
 * - do some data manipulation to get it into the format required
 *   to use print_option_groups().  this way it should look like
 *   all the rest of the preferences.
 */

function startup_folder_options() {

  global $username, $key, $imapServerAddress, $imapPort, $data_dir;

  // Have to make this a global for print_option_groups()
  global $startup_folder_folder;
  $startup_folder_folder = getPref($data_dir, $username, 'startup_folder_folder');

  /* Get some imap data we need later. */
  $imapConnection =
      sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
  $boxes = sqimap_mailbox_list($imapConnection);
  sqimap_logout($imapConnection);

  /* Build a simple array into which we will build options. */
  $optgrps = array();
  $optvals = array();

  $optgrps[0] = _("Folder Displayed on Login");
  $optvals[0] = array();

  $optvals[0][] = array(
      'name'    => 'startup_folder_folder',
      'caption' => _("Startup Folder"),
      'type'    => SMOPT_TYPE_FLDRLIST,
      'refresh' => SMOPT_REFRESH_FOLDERLIST,
      'posvals' =>  array('whatever' => $boxes)
  );

  print_option_groups( create_option_groups($optgrps, $optvals) );
}

function startup_folder_save() {

  global $username, $data_dir, $startup_folder_folder;

  // print_option_groups sticks a new_ in front of our name
  sqgetGlobalVar('new_startup_folder_folder', $startup_folder_folder, SQ_FORM);
  setPref($data_dir, $username, "startup_folder_folder",
          $startup_folder_folder);
}

?>
