<?php

   /*
    *  squirrel_logger v1.2
    *  by Ron Chinn <ron@amalgasys.com>
    *  (c) 2001 GNU GPL
    *
    *  See the README file in the source distribution for instructions.
    *
   */


   global $sl_logfile, $sl_delimiter, $sl_dateformat, $sl_namelookups;

   // --------------------------------------------------------------------
   // ** Modify the following settings for your particular installation **
   // --------------------------------------------------------------------


   // The location of your log file.  Make sure the user your webserver runs as
   // can write to this file.
   //
   // example:  $sl_logfile = "../data/access_log";
   //

   $sl_logfile = "../data/access_log";


   // Specify the delimiter used in between the fields of the log entry
   //
   // example:  $sl_delimiter = "\t";  (use tabs)
   //

   $sl_delimiter= ",";

   // Specify what date format you want
   //
   // See the PHP manual for the date function for help
   // at http://www.php.net/manual/en/function.date.php
   //
   // examples:  
   //
   //    "m/d/y G:i:s"     ==  03/10/2001 05:16:08
   //    "F j, Y, g:i a"   ==  March 10, 2001, 5:16 am
   //    "D M j Y G:i:s T" ==  Sat Mar 10 2001 15:16:08 CDT
   //

   $sl_dateformat = "m/d/Y G:i:s";


   // Turn hostname lookups on or off
   // Valid options are TRUE and FALSE
   //
   // example:   $sl_namelookups = TRUE;

   $sl_namelookups = FALSE;



// -----------------------------------------------------------------------
// You don't need to modify anything below this line
// -----------------------------------------------------------------------

function squirrelmail_plugin_init_squirrel_logger()
{ 
  global $squirrelmail_plugin_hooks;
  $squirrelmail_plugin_hooks["login_verified"]["squirrel_logger"] = "squirrel_logger_login";
  $squirrelmail_plugin_hooks["logout"]["squirrel_logger"] = "squirrel_logger_logout";
  $squirrelmail_plugin_hooks["invalid_login"]["squirrel_logger"] = "squirrel_logger_invalid";
}


// -------------------------------------------------
// Log a successful login
// -------------------------------------------------

function squirrel_logger_login()
{
  global $sl_logfile, $sl_delimiter, $sl_dateformat, $login_username;
  global $sl_namelookups;
    
  $d = $sl_delimiter;

  $date_str = date($sl_dateformat);
  $ip_str = $_SERVER["REMOTE_ADDR"];
 
  // Do name lookup if feature is enabled
  if ($sl_namelookups == TRUE)
    $ip_str = gethostbyaddr($ip_str);

  $log_str = "LOGIN" . $d . $login_username . $d . $ip_str . $d . $date_str;

  $fp=fopen($sl_logfile,"a");
  fputs($fp,$log_str . "\n");
  fclose($fp);

//  `echo '$log_str' >> $sl_logfile`;
}




// -------------------------------------------------
// Log a successful logout
// -------------------------------------------------

function squirrel_logger_logout()
{
  global $sl_logfile, $sl_delimiter, $sl_dateformat, $username;
  global $sl_namelookups;
    
  $d = $sl_delimiter;

  $date_str = date($sl_dateformat);
  $ip_str = $_SERVER["REMOTE_ADDR"];

  // Do name lookup if feature is enabled
  if ($sl_namelookups == TRUE)
    $ip_str = gethostbyaddr($ip_str);

  if (strstr(getenv("REQUEST_URI"),"timeout") == TRUE)
    $event_str = "TIMEOUT";
  else
    $event_str = "LOGOUT";  

  $log_str = $event_str . $d . $username . $d . $ip_str . $d . $date_str;

  $fp=fopen($sl_logfile,"a");
  fputs($fp,$log_str . "\n");
  fclose($fp);

//  `echo '$log_str' >> $sl_logfile`;
}



// -------------------------------------------------
// Log an invalid login attempt
//
// This only works if the user adds a hook in
//  functions/imap_general.php
// -------------------------------------------------

function squirrel_logger_invalid()
{
  global $sl_logfile, $sl_delimiter, $sl_dateformat, $login_username;
  global $sl_namelookups;
    
  $d = $sl_delimiter;

  $date_str = date($sl_dateformat);
  $ip_str = $_SERVER["REMOTE_ADDR"];

  // Do name lookup if feature is enabled
  if ($sl_namelookups == TRUE)
    $ip_str = gethostbyaddr($ip_str);

  $log_str = "INVALID" . $d . $login_username . $d . $ip_str . $d . $date_str;

  $fp=fopen($sl_logfile,"a");
  fputs($fp,$log_str . "\n");
  fclose($fp);

//  `echo '$log_str' >> $sl_logfile`;
}


?>
