<?php

/**
  * SquirrelMail Squirrel Logger Plugin
  * Copyright (c) 2001-2008 Ron Chinn, Pat Winn, Paul Lesniewski
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage squirrel_logger
  *
  */


/**
  * Sends email alerts
  *
  * Currently, only text messages are supported; no multipart HTML
  * or attachments allowed.
  *
  * @param $message string Text of message to be sent
  * @param $subject string Short text for inclusion in email subject line
  * @param $send_to string Comma-separated list of destination TO: addresses
  * @param $send_to_cc string Comma-separated list of destination CC: addresses
  * @param $send_to_bcc string Comma-separated list of destination BCC: addresses
  *
  */
function sl_send_alert($message, $subject, $send_to, $send_to_cc, $send_to_bcc)
{

   // when logging in and user doesn't have a session yet, 
   // this include has not been done yet
   //
   include_once(SM_PATH . 'class/mime.class.php');


   global $username, $domain;


   // function found in SM core 1.5.2+ and Compatibility plugin 2.0.11+
   // (suppress include error, since file is only needed for 1.5.2+,
   // otherwise Compatibility has us covered)
   //
   @include_once(SM_PATH . 'functions/compose.php');
   $success = sq_send_mail($send_to, $subject, $message, 'noreply@' . $domain, $send_to_cc, $send_to_bcc);

}



