<?php

/**
  * SquirrelMail Squirrel Logger Plugin
  * Copyright (c) 2001-2005 Ron Chinn, Pat Winn, Paul Lesneiwski
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage squirrel_logger
  *
  */


/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../../');


/**
  * Load configuration file
  *
  */
function sl_get_config()
{

   // I don't think we should try to load the default/sample
   // file; this plugin has too many system-specific and/or
   // sensitive aspects to try to make a misconfigured plugin work.
   //
   if (!@include_once(SM_PATH . 'plugins/squirrel_logger/config.php'))
   {
      echo sprintf(_("ERROR (%s): can't load config file"), 'squirrel_logger');
      exit(1);
   }

}



/**
  * Get date formatted in local or GMT time
  *
  * @param string $format Date format string
  * @param int $timestamp Time to be formatted
  *
  */
function sldate($format, $timestamp)
{

   global $sl_use_GMT;
   sl_get_config();

   if ($sl_use_GMT)
      return gmdate($format, $timestamp);
   else
      return date($format, $timestamp);
}



/**
  * Log user logins
  *
  */
function sl_log_login_do() 
{

   global $login_username, $sl_log_events, 
          $domain, $only_log_domains, $skip_domains;
   sl_get_config();


   if (!in_array('LOGIN', $sl_log_events) 
    || (isset($only_log_domains['LOGIN']) && is_array($only_log_domains['LOGIN']) 
        && !empty($only_log_domains['LOGIN']) && !in_array($domain, $only_log_domains['LOGIN']))
    || (isset($skip_domains['LOGIN']) && is_array($skip_domains['LOGIN']) 
        && !empty($skip_domains['LOGIN']) && in_array($domain, $skip_domains['LOGIN'])))
      return;


//TODO: is $login_username correct when called before vlogin decyphers it?
//TODO: is $login_username correct when called before login_alias changes it?
//TODO: is $login_username correct when called before password_forget changes it?
//TODO: what about $domain??
//            these seem to work OK at least as long as this plugin 
//            comes after those... haven't yet tried the converse
   sl_logit('LOGIN', '', $login_username);
//$log_str = "Successful webmail login from " . $ip_str . " by " . $login_username . ".";

}



/**
  * Log user logouts
  *
  */
function sl_log_logout_do() 
{

   global $sl_log_events,
          $domain, $only_log_domains, $skip_domains;
   sl_get_config();


   // check for timeout_user plugin - did user time out?
   //
   $event = 'LOGOUT';
   if (sqgetGlobalVar('timeout', $timeout, SQ_FORM)
    || sqgetGlobalVar('timeout_immediate', $timeout_immediate, SQ_FORM))
      $event = 'TIMEOUT';


   if (!in_array($event, $sl_log_events)
    || (isset($only_log_domains[$event]) && is_array($only_log_domains[$event])
        && !empty($only_log_domains[$event]) && !in_array($domain, $only_log_domains[$event]))
    || (isset($skip_domains[$event]) && is_array($skip_domains[$event])
        && !empty($skip_domains[$event]) && in_array($domain, $skip_domains[$event])))
      return;


   sl_logit($event);
//$log_str = "Webmail session timed out for " . $username . " from " . $ip_str . ".";
//$log_str = "Webmail user " . $username . " from " . $ip_str . " logged out.";

}



/**
  * Log user login errors
  *
  */
function sl_log_login_error_do($args) 
{

   global $login_username, $sl_log_events,
          $domain, $only_log_domains, $skip_domains;
   sl_get_config();


   if (!in_array('LOGIN_ERROR', $sl_log_events)
    || (isset($only_log_domains['LOGIN_ERROR']) && is_array($only_log_domains['LOGIN_ERROR'])
        && !empty($only_log_domains['LOGIN_ERROR']) && !in_array($domain, $only_log_domains['LOGIN_ERROR']))
    || (isset($skip_domains['LOGIN_ERROR']) && is_array($skip_domains['LOGIN_ERROR'])
        && !empty($skip_domains['LOGIN_ERROR']) && in_array($domain, $skip_domains['LOGIN_ERROR'])))
      return;


//TODO: is $login_username correct here when using vlogin, login_alias, or pwd_forget??
//            these seem to work OK at least as long as this plugin 
//            comes after those... haven't yet tried the converse
   $message = $args[1];
   sl_logit('LOGIN_ERROR', $message, $login_username);
//$log_str = "Failed webmail login from " . $ip_str . " by " . $login_username . ".";

}



/**
  * Log user errors
  *
  */
function sl_log_error_do($args) 
{

   global $sl_log_events,
          $domain, $only_log_domains, $skip_domains;
   sl_get_config();


   if (!in_array('ERROR', $sl_log_events)
    || (isset($only_log_domains['ERROR']) && is_array($only_log_domains['ERROR'])
        && !empty($only_log_domains['ERROR']) && !in_array($domain, $only_log_domains['ERROR']))
    || (isset($skip_domains['ERROR']) && is_array($skip_domains['ERROR'])
        && !empty($skip_domains['ERROR']) && in_array($domain, $skip_domains['ERROR'])))
      return;


   $message = $args;
   sl_logit('ERROR', $message);
//$log_str = "Failed webmail login from " . $ip_str . " by " . $login_username . ".";

}



/**
  * Monitor mails being sent, watching for possible mass mailings (spam)
  *
  */
function sl_monitor_sent_msgs_do($args)
{

   $delimiter = '@';


   global $sl_send_alerts, $sl_mass_mail_limit, $domain, 
          $only_log_domains, $skip_domains;
   sl_get_config();


   if ((isset($only_log_domains['MASS_MAILING']) && is_array($only_log_domains['MASS_MAILING'])
        && !empty($only_log_domains['MASS_MAILING']) && !in_array($domain, $only_log_domains['MASS_MAILING']))
    || (isset($skip_domains['MASS_MAILING']) && is_array($skip_domains['MASS_MAILING'])
        && !empty($skip_domains['MASS_MAILING']) && in_array($domain, $skip_domains['MASS_MAILING'])))
      return;


   // grab TO, CC, and BCC fields from message
   //
   $message = $args[1];
   $toList = array();
   $ccList = array();
   $bccList = array();

   foreach ($message->rfc822_header->to as $recip)
      $toList[] = $recip->mailbox . $delimiter . $recip->host;
   foreach ($message->rfc822_header->cc as $recip)
      $ccList[] = $recip->mailbox . $delimiter . $recip->host;
   foreach ($message->rfc822_header->bcc as $recip)
      $bccList[] = $recip->mailbox . $delimiter . $recip->host;


   // too many recipients?  log it and possibly send alert
   //
   $total_recips = sizeof($toList) + sizeof($ccList) + sizeof($bccList);
   if ($total_recips >= $sl_mass_mail_limit)
   {

      global $username, $sl_log_mass_mailing_show_recipients, 
             $sl_log_mass_mailing_show_message_body, $body,
             $sl_dateformat, $sl_namelookups, $subject;
      $message = 'Total ' . $total_recips . ' recipients';


      if ($sl_log_mass_mailing_show_recipients)
      {
         $address_delim = ', ';

         $message .= ' (TO: ' . implode($address_delim, $toList) . ')';
         $message .= ' (CC: ' . implode($address_delim, $ccList) . ')';
         $message .= ' (BCC: ' . implode($address_delim, $bccList) . ')';
      }

      if ($sl_log_mass_mailing_show_message_body)
      {
         $message .= ' (SUBJECT: ' . $subject . ')';
         $message .= ' (BODY: ' . $body . ')';
      }


      sl_logit('MASS_MAILING', $message);

   }

}



/** 
  * Build log fields and send off to be logged
  *
  * Custom event types are acceptable as long as they are enabled
  * in the configuration file.
  *
  * @param string $event The event type
  * @param string $message The log message (optional; deafult = empty)
  * @param string $user Override for username (if not given,
  *                     will use the SquirrelMail user found
  *                     in SESSION.  (optional; default = empty)
  *
  */
function sl_logit($event, $message='', $user='')
{

   global $sl_namelookups, $sl_dateformat, $username, $domain;
   sl_get_config();


   // construct log fields
   //
   if (empty($user)) $user = $username;

   $timestamp = time();
   $date_str = sldate($sl_dateformat, $timestamp);

   if (!sqgetGlobalVar('REMOTE_ADDR', $user_address, SQ_SERVER))
      $user_address = '';

   if ($sl_namelookups)
      $user_address .= ' (' . gethostbyaddr($user_address) . ')';


   // send off to be logged
   //
   sl_send_to_log($event, $timestamp, $date_str, $user, $domain, $user_address, $message);

}



/** 
  * Dispatch fields to be logged to the registered log types
  *
  * Also sends alerts if needed.
  *
  * Custom event types are acceptable as long as they are enabled
  * in the configuration file.
  *
  * @param string $event The event type
  * @param int $timestamp The date and time of the event
  * @param string $date_str A formatted, humyn-readable version of 
  *                         the $timestamp
  * @param string $user The user that triggered the event (optional; 
  *                     default = empty)
  * @param string $dom The user's domain (optional; default = empty)
  * @param string $remote_addr The user's IP and/or hostname 
  *                            information (optional; default = empty)
  * @param string $message The log message (optional; deafult = empty)
  *
  */
function sl_send_to_log($event, $timestamp, $date_str, $user='', $dom='', $remote_addr='', $message='')
{

   global $sl_logs, $sl_send_alerts, $sl_alert_to, $sl_alert_cc, 
          $sl_alert_bcc, $sl_alert_subject_template;
   sl_get_config();



   // find empty parameters
   //
   if (empty($user)) $user = 'N/A';
   if (empty($dom)) $dom = 'N/A';
   if (empty($remote_addr)) $remote_addr = 'N/A';



   // send message to each log type that is enabled
   //
   foreach ($sl_logs as $log => $allowed_events)
   {
   
      // skip if the current event not logged for any log type
      //
      if (!in_array($event, array_keys($allowed_events))) continue;


      // construct full log message 
      //
      $full_message = str_replace(array('%1', '%2', '%3', '%4', '%5', '%6', '%7'), 
                                  array($event, $user, $dom, $remote_addr, 
                                        $timestamp, $date_str, $message), 
                                  $allowed_events[$event]);


      switch ($log)
      {

         case 'FILE':
            sl_log_to_file($full_message);
            break;

         case 'SQL':
            include_once(SM_PATH . 'plugins/squirrel_logger/database_functions.php');

            // note that in this case, $full_message will just be the revised event name
            sl_log_to_db($full_message, $user, $dom, $remote_addr, $timestamp, $message);

            break;

         case 'SYSTEM':

            sl_log_to_system_log($full_message);
            break;

      }

   }



   // send alerts if needed
   //
   if (in_array($event, array_keys($sl_send_alerts)))
   {

      // construct full log message 
      //
      $body = str_replace(array('%1', '%2', '%3', '%4', '%5', '%6', '%7'), 
                          array($event, $user, $dom, $remote_addr, 
                                $timestamp, $date_str, $message), 
                          $sl_send_alerts[$event]);


      include_once(SM_PATH . 'plugins/squirrel_logger/alert_functions.php');


      // collect recipients
      //
      if (!empty($sl_alert_to[$event]))
         $to = $sl_alert_to[$event];
      else
         $to = '';

      if (!empty($sl_alert_cc[$event]))
         $cc = $sl_alert_cc[$event];
      else
         $cc = '';

      if (!empty($sl_alert_bcc[$event]))
         $bcc = $sl_alert_bcc[$event];
      else
         $bcc = '';


      // build subject
      //
      $subject = str_replace(array('%1', '%2'), array($event, $user), 
                             $sl_alert_subject_template);


      // send it
      //
      sl_send_alert($body, $subject, $to, $cc, $bcc);

   }

}



/**
  * Log a message to a file
  *
  * @param string $message The log message
  *
  */
function sl_log_to_file($message)
{

   global $sl_logfile;
   sl_get_config();


   // write final message to file
   //
   if ($FILE = @fopen($sl_logfile, 'ab'))
   {
      @fwrite($FILE, $message);
//      @fwrite($FILE, $message, 8192);
      fclose($FILE);
   }

}



/**
  * Log a message to the system log
  *
  * @param string $message The message to be logged
  *
  */
function sl_log_to_system_log($message)
{

   global $sl_syslog_priority;
   sl_get_config();

   syslog($sl_syslog_priority, $message);

}



?>
