<?php

/**
  * SquirrelMail Squirrel Logger Plugin
  * Copyright (c) 2001-2005 Ron Chinn, Pat Winn, Paul Lesneiwski
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage squirrel_logger
  *
  */


/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../../');


/**
  * Sends email alerts
  *
  * Currently, only text messages are supported; no multipart HTML
  * or attachments allowed.
  *
  * @param $message string Text of message to be sent
  * @param $subject string Short text for inclusion in email subject line
  * @param $send_to string Comma-separated list of destination TO: addresses
  * @param $send_to_cc string Comma-separated list of destination CC: addresses
  * @param $send_to_bcc string Comma-separated list of destination BCC: addresses
  *
  */
function sl_send_alert($message, $subject, $send_to, $send_to_cc, $send_to_bcc)
{

   // when logging in and user doesn't have a session yet, 
   // this include has not been done yet
   //
   include_once(SM_PATH . 'class/mime.class.php');


   global $username, $domain;


   $report = new Message();
   $header  = new Rfc822Header();

   $report->setBody($message);
   $content_type = new ContentType('text/plain');
   global $special_encoding, $default_charset;
   if ($special_encoding)
      $rfc822_header->encoding = $special_encoding;
   else
      $rfc822_header->encoding = '8bit';
   if ($default_charset)
      $content_type->properties['charset']=$default_charset;
   $header->content_type = $content_type;

   $header->parseField('To', $send_to);
   $header->parseField('Cc', $send_to_cc);
   $header->parseField('Bcc', $send_to_bcc);
   $header->parseField('From', 'noreply');
   $header->parseField('Subject', $subject);
   $report->rfc822_header = $header;
//sm_print_r($report);exit;



   global $useSendmail;



   // ripped from compose.php (1.4.4)
   //
    if (!$useSendmail) {
        require_once(SM_PATH . 'class/deliver/Deliver_SMTP.class.php');
        $deliver = new Deliver_SMTP();
        global $smtpServerAddress, $smtpPort, $pop_before_smtp, $smtp_auth_mech;

        $authPop = (isset($pop_before_smtp) && $pop_before_smtp) ? true : false;

        if ($smtp_auth_mech == 'none' && !$authPop) {
                $user = '';
                $pass = '';
        } else {
                global $key, $onetimepad;
                $user = $username;
                $pass = OneTimePadDecrypt($key, $onetimepad);
        }

        $stream = $deliver->initStream($report,$domain,0,
                $smtpServerAddress, $smtpPort, $user, $pass, $authPop);
    } else {
        require_once(SM_PATH . 'class/deliver/Deliver_SendMail.class.php');
        global $sendmail_path;
        $deliver = new Deliver_SendMail();
        $stream = $deliver->initStream($report,$sendmail_path);
    }


    $succes = false;
    if ($stream) {
        $length = $deliver->mail($report, $stream);
        $succes = $deliver->finalizeStream($stream);
    }

}



?>
