<?php

/*
 * spamrule:  $Id: lib.php,v 1.3 2003/04/08 23:04:31 shaug Exp $
 * (c) 2002 O'Shaughnessy Evans <shaug-spamrule @ wumpus.org>
 */

/*
 * Table of Contents:
 * 
 * function sr_print_header($mesg, $columns)
 * function sr_print_footer($mesg, $columns)
 * function sr_select_group()
 * function sr_select_filters()
 * function sr_print_summary($group)
 * function sr_print_subscribed()
 * function sr_install_filters($group, $filters)
 * function sr_load_prefs()
 * function sr_maintain_list($list)
 * function sr_ftp_get($path)
 * function sr_ftp_put($path, $data)
 * function sr_syslog($message)
 * function sr_get_forward()
 * function sr_install_forward($install_forwared)
 */


/* sr_print_header($mesg, $columns)
 * 
 * Print out the beginning of a table, with $mesg in the first row.
 * 
 * Parameters:
 *   $mesg:     text to print out
 *   $columns:  how many columns will be in the table
 * 
 * Returns:
 *   nothing
 */
function sr_print_header($mesg, $columns)
{
    $title = _("Options") . ' - Spam Rules';

    echo <<<EOtable_top
<br>
<table bgcolor="{$GLOBALS['color'][0]}" border=0 width=95% cellspacing=0 cellpadding=2 align=center>
  <tr bgcolor="{$GLOBALS['color'][0]}">
    <th>{$title}</b></th>
  </tr>
  <tr><td>
    <table bgcolor="{$GLOBALS['color'][4]}" border=0 width=100%
           cellspacing=0 cellpadding=5 align=center valign=top>
      <tr align=center bgcolor="{$GLOBALS['color'][4]}">
        <td colspan=$columns>
EOtable_top;

    if (isset($mesg))
        echo "<p>{$mesg}</p>\n";

    echo "</td>\n</tr>\n\n";
}


/* sr_print_footer($mesg, $columns)
 * 
 * Print out the end of a table, with $mesg in the last row.
 * 
 * Parameters:
 *   $mesg:     text to print out
 *   $columns:  how many columns the table has
 * 
 * Returns:
 *   nothing
 */
function sr_print_footer($mesg, $columns)
{
    if (isset($mesg)) {
        echo <<<EOmesg

  <tr align=center bgcolor="{$GLOBALS['color'][4]}">
    <td colspan=$columns>
      <p>{$mesg}</p>
    </td>
  </tr>
EOmesg;
    }

    echo <<<EOfooter

    </table>
  </td></tr>
</table>

EOfooter;
}


/* sr_select_group()
 * 
 * Read the list of filters that a user has from their squirrelmail preferences,
 * then print out a form allowing them to change the filter group they're
 * using.
 * 
 * Parameters:
 *   none
 * 
 * Returns:
 *   nothing
 */
function sr_select_group()
{
    // load the saved filters
    list($group, $filters) = sr_load_prefs();
    if (isset($group) &&
     array_key_exists($group, $GLOBALS['SPAMRULE_GROUPS'])) {
        $GLOBALS['SPAMRULE_DEFGROUP'] = $group;

        if (isset($filters))
            $GLOBALS['SPAMRULE_GROUPS'][$group]['filters'] = $filters;
    }
    else {
        $group = $GLOBALS['SPAMRULE_DEFGROUP'];
    }

    // print out the start of the group selection form
    echo <<<EOheader
    <tr align=left bgcolor="{$GLOBALS['color'][12]}">
      <th align=left colspan=3>
        <form action="options.php" method="GET">
        You can choose one of these options:
      </th>
    </tr>
EOheader;

    // print each of the groups in its own table row
    $n = 1;
    foreach ($GLOBALS['SPAMRULE_GROUPS'] as $g => $settings) {
        $n++;
        $rowcolor = $n % 2 ? $GLOBALS['color'][12] : $GLOBALS['color'][4];
        echo "<tr valign=top align=left bgcolor=\"$rowcolor\">\n" .
             "<td><input type=radio name=newgroup value=\"$g\"" .
              ($g == $group ? ' checked' : '' ) . "></td>\n" .
             "<td><b>{$settings['title']}</b></td>\n" .
             "<td>{$settings['text']}</td>\n" .
             "</tr>\n";
    }
    $rowcolor = ($n+1) % 2 ? $GLOBALS['color'][12] : $GLOBALS['color'][4];

    // close out the form
    $update_links = '';
    if ($GLOBALS['javascript_on']) {
        $update_links .= ' <a href="javascript:void(0)" onclick="subwin'.
         '(\'options.php?action=editlist&list=allowed_recipients\','.
         ' \'sr_editlist\', 450, 450)">Aliases</a><br>';
        $update_links .= ' <a href="javascript:void(0)" onclick="subwin'.
         '(\'options.php?action=editlist&list=allowed_senders\','.
         ' \'sr_editlist\', 450, 450)">Allowed Senders</a><br>';
        $update_links .= ' <a href="javascript:void(0)" onclick="subwin'.
         '(\'options.php?action=editlist&list=blocked_senders\','.
         ' \'sr_editlist\', 450, 450)">Blocked Senders</a><br>';
        $update_links .= ' <a href="javascript:void(0)" onclick="subwin'.
         '(\'options.php?action=editlist&list=blocked_subjects\','.
         ' \'sr_editlist\', 450, 450)">Blocked Subjects</a><br>';
    }
    else {
        $update_links .= ' <a href="options.php?action=editlist&list='.
         'allowed_recipients" target="_blank">Aliases</a><br>';
        $update_links .= ' <a href="options.php?action=editlist&list='.
         'allowed_senders" target="_blank">Allowed senders</a><br>';
        $update_links .= ' <a href="options.php?action=editlist&list='.
         'blocked_senders" target="_blank">Blocked senders</a><br>';
        $update_links .= ' <a href="options.php?action=editlist&list='.
         'blocked_subjects" target="_blank">Blocked Subjects</a><br>';
    }
    echo <<<EOend
    <tr bgcolor="$rowcolor" align=left>
      <td>&nbsp;</td>
    </tr>
    <tr bgcolor="$rowcolor" align=left valign=top>
      <td colspan=2> 
        <input type=submit value="Next >"> &nbsp;
        <input type=reset> &nbsp;
      </td>
      <td>
        <table border=0 cols=3 rows=1 width=100%>
        <tr valign=top>
        <td align=left width=60%>
          <a href="options.php?action=subscribed">Show my current filters.</a>
          <input type=hidden name="action" value="groups">
          </form>
        </td>
        <td align=right><small>Update my:</small></td>
        <td><small>$update_links</small></td>
        </tr>
        </table>
      </td>
    </tr>
EOend;
}


/* sr_select_filtesr()
 * 
 * Load the individual filters that a user has saved in their preferences,
 * then allow them to customize the list.
 * 
 * Parameters:
 *   none
 * 
 * Returns:
 *   nothing
 */
function sr_select_filters()
{
    // load the saved filters
    list($group, $filters) = sr_load_prefs();
    if (!isset($filters)) {
        $filters = $GLOBALS['SPAMRULE_GROUPS']['CUSTOM']['filters'];
    }

    // print out the beginning of the form
    echo <<<EOheader
    <tr align=left valign=bottom bgcolor="{$GLOBALS['color'][4]}">
      <th><form action="options.php" method="POST"></th>
      <th><u>Name</u></th>
      <th><u>What Does It Do?</u></th>
    </tr>
EOheader;

    // print out each filter in its own table row, with a checkbox
    // to enable or disable it
    $n = 0;
    foreach ($GLOBALS['SPAMRULE_FILTERS'] as $filter => $settings) {
        $n++;
        $rowcolor = $n % 2 ? $GLOBALS['color'][12] : $GLOBALS['color'][4];
        echo "  <tr valign=top bgcolor=\"$rowcolor\">\n" .
             "    <td><input type=checkbox " .
              "name=\"SPAMRULE_GROUPS[CUSTOM][filters][]\" " .
              "value=\"$filter\"" .
               (in_array($filter, $filters) ? ' checked' : '' ) . "></td>\n" .
             "    <td>{$settings['title']}</td>\n" .
             "    <td>{$settings['text']}</td>\n" .
             "  </tr>\n";
    }

    // close out the form
    echo <<<EOF
    <tr>
      <td colspan=3> 
        <br>
        <input type=hidden name=newgroup value=CUSTOM>
        <input type=hidden name="action" value="groups">
        <input type=submit value="Finish"> &nbsp; <input type=reset>
      </td>
    </tr>
    </form>
EOF;
}


/* sr_print_summary($group)
 * 
 * Print out a summary of the named group
 * 
 * Parameters:
 *   $group:    (string) the filter group to be described
 * 
 * Returns:
 *   nothing
 */
function sr_print_summary($group)
{
    echo <<<EOheader
    <tr valign=top align=left bgcolor="{$GLOBALS['color'][12]}">
      <td>&nbsp;</td>
      <td><b><a href="options.php?action=subscribed">{$GLOBALS['SPAMRULE_GROUPS'][$group]['title']}</a></b>
          
          </td>
      <td>{$GLOBALS['SPAMRULE_GROUPS'][$group]['text']}</td>
    </tr>
EOheader;
}


/* sr_print_subscribed()
 * 
 * Load the group and filters to which the user is subscribed, then print
 * a summary of each individual filter.
 * 
 * Parameters:
 *   none
 * 
 * Returns:
 *   nothing
 */
function sr_print_subscribed()
{
    // load the saved filters
    $group = getPref($GLOBALS['data_dir'], $GLOBALS['username'],
     'spamrule_group');
    $filters = explode(',', getPref($GLOBALS['data_dir'], $GLOBALS['username'],
     'spamrule_filters'));
    $group_title = isset($GLOBALS['SPAMRULE_GROUPS'][$group]['title'])
     ? $GLOBALS['SPAMRULE_GROUPS'][$group]['title']
     : 'Custom';

    echo <<<EOheader
    <tr align=left bgcolor="{$GLOBALS['color'][4]}">
      <td colspan=3>You have selected <em>$group_title</em> filters:
      </td>
    </tr>

    <form action="options.php" method="POST">
    <tr align=left valign=bottom bgcolor="{$GLOBALS['color'][4]}">
      <th>&nbsp;</th>
      <th><u>Name</u></th>
      <th><u>What Does It Do?</u></th>
    </tr>
EOheader;

    $n = 0;
    foreach ($GLOBALS['SPAMRULE_FILTERS'] as $filter => $settings) {
        if (! in_array($filter, $filters))
            continue;
        $n++;
        $rowcolor = $n % 2 ? $GLOBALS['color'][12] : $GLOBALS['color'][4];
        echo <<<EOrow
        <tr valign=top bgcolor="$rowcolor">
           <td>&nbsp;</td>
           <td><b>{$settings['title']}</b></td>
           <td>{$settings['text']}</td>
        </tr>
EOrow;
    }
}


/* sr_install_filters($group, $filters)
 * 
 * Save the user's groups and filters to their squirrelmail prefs, then
 * FTP them to the user's account
 * 
 * Parameters:
 *   $group:    the group to save & install
 *   $filters:  the individual filters that are a part of that group
 * 
 * Returns:
 *   nothing
 */
function sr_install_filters($group, $filters)
{
    global $username, $data_dir, $SPAMRULE_FILTERS, $SPAMRULE_VERSION,
           $SPAMRULE_INSTALL;
    $cmd = '';            // for building up the special (un)install commands
    $last = '';           // will hold the last line of output from exec cmds
    $results[] = array(); // will hold the output of exec commands
    $status = 0;          // will hold the status of exec and ftp commands
    $forward_has_filter = TRUE; // will indicate whether or not to install
                          // the filtering command in the forward file

    // save the group and filters to the squirrelmail prefs
    setPref($data_dir, $username, 'spamrule_group', $group);
    setPref($data_dir, $username, 'spamrule_filters', implode(',', $filters));

    // Look through the list of filters we know about.  If the user is
    // installing one that has a unique 'install' setting, run it.
    // If it user didn't select the given filter and it has an 'uninstall'
    // setting, run that.
    foreach ($SPAMRULE_FILTERS as $filter => $settings) {
        // the filter was chosen by the user
        $key = array_search($filter, $filters);
        if ($key !== FALSE) {
            // the filter has a special 'install' command
            if (isset($settings['install'])) {
                // create the system command
                $cmd = escapeshellcmd($settings['install']);
                $cmd = $settings['install'];
                $last = exec("$cmd 2>&1 &", $results, $status);

                // remove the filter name from the list to add via the
                // general install command
                unset($filters[$key]);
            }
        }
        // the filter was not chosen by the user
        else {
            // the filter has a special 'uninstall' command
            if (isset($settings['uninstall'])) {
                $cmd = escapeshellcmd($settings['uninstall']);
                $last = exec("$cmd 2>&1 &", $results, $status);
                if ($status != 0)
                    sr_syslog('error installing filters for '. $username . 
                     ":  \"$cmd\" exited $status; output was \"".
                     implode(';', $results). '"');
            }
        }
    }

    // If the option $SPAMRULE_INSTALL['command'] is set, use that
    // to install the filters.  Otherwise, upload them via FTP.
    if (isset($SPAMRULE_INSTALL['command'])) {
        $cmd = sprintf($SPAMRULE_INSTALL['command'], implode(' ', $filters));
        $last = exec(escapeshellcmd($cmd). " 2>&1 &", $results, $status);
        if ($status != 0)
            sr_syslog("error installing filters for $username:  \"$cmd\" ".
             "exited $status; output was \"". implode(';', $results). '"');
    }
    else if ($filters) {
        // create a file with the individual filters
        $data = "# mail filter file for $username\n".
                "# created by the Spam Rules SquirrelMail plugin, version ".
                $SPAMRULE_VERSION . "\n".
                "# on ". date('D, F j, Y, g:i a T'). "\n";
        foreach ($filters as $f) {
            $data .= sprintf($SPAMRULE_INSTALL['filter_string'], $f);
        }
    }
    else {
      // There's no filter being installed, which means the user is removing
      // himself from all the filters.  So, we want to be sure to remove
      // (or at least not install) the mail forwarding command.
      $forward_has_filter = FALSE;
    }

    // upload the filter file via FTP
    list($status, $results) =
     sr_ftp_put($SPAMRULE_INSTALL['filter_file'], $data);
    if ($status != TRUE) {
        sr_syslog($results);
        echo <<<EOerror
  <p>
  <strong>Whoops!  There was trouble installing your filters.</strong><br>
  Here's the message:<br><font color=red><pre>$results</pre></font>
  </p>

EOerror;
        return;
    }

    // upload the forward file via FTP
    sr_syslog("forward_has_filter is $forward_has_filter");
    list($status, $results) = sr_install_forward($forward_has_filter);
    if ($status != TRUE) {
        sr_syslog($results);
        echo <<<EOerror
<p>
<strong>Whoops!  There was trouble installing your filters.</strong><br>
Here's the message:<br><font color=red><pre>$results</pre></font>
</p>

EOerror;
        return;
    }
}


function sr_load_prefs()
{
    $group = getPref($GLOBALS['data_dir'], $GLOBALS['username'],
     'spamrule_group');
    $filters = explode(',', getPref($GLOBALS['data_dir'], $GLOBALS['username'],
     'spamrule_filters'));

    return array($group, $filters);
}


function sr_maintain_list($list)
{
    global $color, $SPAMRULE_OPTS;

    // have any changes been made to the list of patterns we want to save?
    $change = FALSE;

    // get the list of current patterns, which will be modified as
    // appropriate by our lists of patterns to add and delete
    $patterns = sr_ftp_get($SPAMRULE_OPTS[$list]['file']);

    // get rid of duplicate patterns, make sure there are no empty ones,
    // then get rid of regex escapes and anchors we added when saving
    $patterns = array_unique($patterns);
    foreach ($patterns as $k => $v) {
        $v = trim($v);
        if (!$v) {
            unset($patterns[$k]);
            $change = TRUE;
        }
        else {
            // get rid of the anchors and regex character quoting we keep
            // in the pattern file
            $v = ereg_replace('^\^', '', $v);
            $v = ereg_replace('\$$', '', $v);
            $v = preg_replace('/\\\([.\\+*?\[\]^$(){}\!<>|:])/', '$1', $v);
	    // trim again
	    $v = trim($v);
	    if (!$v) {
		unset($patterns[$k]);
		$change = TRUE;
	    }
	    else {
		$patterns[$k] = $v;
	    }
        }
    }

    // get the requested changes
    $delpats  = isset($_POST['sr_del_patterns']) ? $_POST['sr_del_patterns']
                : $_GET['sr_del_patterns'];
    $newpat   = isset($_POST['sr_new_pattern']) ? $_POST['sr_new_pattern']
                : $_GET['sr_new_pattern'];

    // clean up the list of patterns to remove:  skip any that are
    // empty or just whitespace, then quote any regular expression
    // characters to disable regex pattern matching by our filter program
    // (since most users won't know anything about regexes, they'll just
    // add confusion) and add the regex anchors
    if (isset($delpats) && $delpats) {
        foreach ($delpats as $k => $v) {
            $v = trim($v);
            if (!$v) {
                unset($delpats[$k]);
                $change = TRUE;
            }
            else {
                $delpats[$k] = $v;
            }
        }
        $patterns = array_diff($patterns, $delpats);
        $change = TRUE;
    }

    // add the new pattern to our list
    if (isset($newpat) && $newpat) {
	$newpat = trim($newpat);
        array_push($patterns, $newpat);
        $change = TRUE;
    }

    // save the new file if it has changed
    if ($change) {
        $data = '';
        foreach ($patterns as $v) {
            // escape any regular expression patterns, because regexes
            // tend to be very confusing if you don't know about them
            $v = preg_quote($v);

            // anchor the pattern:  if it's complete, anchor to the
            // beginning and end; if it's just a username (user@)
            // or domain (@domain), then just anchor the appropriate side
            if ($SPAMRULE_OPTS[$list]['anchor'] && strpos($v, '@') !== FALSE) {
                if (! ereg('^@', $v)) {
                    $v = '^'. $v;
                }
                if (! ereg('@$', $v)) {
                    $v .= '$';
                }
            }
            $data .= $v. "\n";
        }
        list($status, $ftpmesg) =
         sr_ftp_put($SPAMRULE_OPTS[$list]['file'], $data);
        if ($status != TRUE) {
            sr_syslog($ftpmesg);
        }
    }

    // print out the rest of the form w/a table of the current patterns
    // and checkboxes to remove any of them
    echo "<form action=\"options.php?action=editlist&list=$list\" ".
         "method=POST>\n";
    if ($patterns) {
    echo <<<EOformtop

  <tr valign=top bgcolor="$color[4]">
    <td width=5%>&nbsp;</td>
    <td width=5%><u>Remove?</u></td>
    <td><u>Address</u></td>
  </tr>

EOformtop;
    }

    $n = 0;
    foreach ($patterns as $key => $val) {
        $n++;
        $rowcolor = $n % 2 ? $GLOBALS['color'][12] : $GLOBALS['color'][4];
        echo <<<EOrow

        <tr valign=middle align=left bgcolor="$rowcolor">
           <td>$n.</td>
           <td><input type=checkbox name="sr_del_patterns[]" value="$val"></td>
           <td><tt>$val</tt></td>
        </tr>
EOrow;
    }
    $n++;
    $rowcolor = $n % 2 ? $GLOBALS['color'][12] : $GLOBALS['color'][4]; 
    $default = $patterns ? '' : $SPAMRULE_OPTS[$list]['default'];
    echo <<<EOform
  <tr valign=top bgcolor="$rowcolor">
    <td colspan=3><br><p>Add a new entry:
      <input type=text name=sr_new_pattern size=50 value="$default"></input></p>
    </td>
  </tr>

  <tr>
    <td colspan=3> 
      <br>
      <input type=submit value="Update"> &nbsp; <input type=reset>
    </td>
  </tr>
  </form>
EOform;
}


/* sr_ftp_get($path)
 * 
 * Downloads the given list name from the user's account on
 * SPAMRULE_FTPHOST and returns the contents as an array.
 */
function sr_ftp_get($path)
{
    global $username, $key, $onetimepad;
    $ftphost = $GLOBALS['SPAMRULE_FTPHOST'];
    if (!$ftphost)
        return array();
        /*
        return array(FALSE, 'Sorry, but this plugin is not completely set '.
                            'up.  Please contact your System Administrator '.
                            'about configuring the Spam Rules plugin.');
        */
    if (!$path)
        return array();
        //return array(FALSE, 'no file was given to upload');

    // decrypt the user's password so we can pass it to the ftp site
    // (borrowed from the vacation plugin; thanks!)
    $password = OneTimePadDecrypt($key, $onetimepad);

    // upload the file to the user's home
    $ftp = ftp_connect($ftphost);
    $status = ftp_login($ftp, $username, $password);
    if (!$ftp or !$status) {
        return array(FALSE, "cannot connect to $ftphost: $php_errormsg");
    }

    if (! @ftp_chdir($ftp, dirname($path)))
        return array();

    $file = basename($path);
    if (! @ftp_size($ftp, $file))
        return array();

    // create a local temp file to store the rules
    $temp = tmpfile();
    $status = @ftp_fget($ftp, $temp, $file, FTP_ASCII);
    ftp_close($ftp);

    // put each line of the temp file into an array
    rewind($temp);
    $data = array();
    while (!feof($temp))
        array_push($data, trim(fgets($temp)));
    fclose($temp);
    return $data;

    // download the mailfilter file and return it in an array
    //$data = @file("ftp://$username:$password@$ftphost/$to_get");
    //echo "data is: <pre>"; print_r($data); echo "</pre>\n";
    //return isset($data) ? array_map('trim', $data) : array();
}


/* sr_ftp_put($path, $data)
 * 
 * Uploads the text in $data to $path in the user's account on 
 * SPAMRULE_FTPHOST.
 * 
 * Parameters:
 *   $path:  (string) the file to be modified
 *   $data:  (string) the data to be written to $path; if it's an empty
 *           string, $path will be removed
 * 
 * Returns:
 *   a 2-part array, with the first part indicating success (TRUE) or failure
 *   (FALSE) and the second part containing an error message in the case of
 *   failure
 */
function sr_ftp_put($path, $data)
{
    global $username, $key, $onetimepad;

    $ftphost = $GLOBALS['SPAMRULE_FTPHOST'];
    if (!$ftphost)
        return array(FALSE, 'Sorry, but this plugin is not completely set '.
                            'up.  Please contact your System Administrator '.
                            'about configuring the Spam Rules plugin.');
    if (!$path)
        return array(FALSE, 'no file was given to upload');

    // decrypt the user's password so we can pass it to the ftp site
    // (borrowed from the vacation plugin; thanks!)
    $password = OneTimePadDecrypt($key, $onetimepad);

    // upload the file to the user's home
    $ftp = ftp_connect($ftphost);
    $status = ftp_login($ftp, $username, $password);
    if (!$ftp or !$status) {
        return array(FALSE, "cannot connect to $ftphost: $php_errormsg");
    }
    // if there is data to upload, write it to a temporary file and upload
    // its contents
    if ($data) {
        // create a file w/the new rules
        $temp = tmpfile();
        fwrite($temp, $data);
        rewind($temp);

        // search the path to the file and create each parent dir if it
        // doesn't exist
        $dir = dirname($path);
        $dirs = preg_split('/[\\/\\\]+/', $dir, -1, PREG_SPLIT_NO_EMPTY);
        foreach ($dirs as $d) {
            if ($d == '.') continue;
            if ($d == '/') continue;
            if (! @ftp_chdir($ftp, $d)) {
                if (!(@ftp_mkdir($ftp, $d) && @ftp_site($ftp, "chmod 0700 $d")
                     && @ftp_chdir($ftp, $d))) {
                    @ftp_close($ftp);
                    return array(FALSE, "error creating $dir: $php_errormsg");
                }
            }
        }
        /*
        $cwd = ftp_pwd($ftp);
        if ($cwd != "/" and $cwd != $dir and $cwd != "/$dir") {
            return array(FALSE, "error creating $dir (could only get to ".
                            "$cwd): $php_errormsg");
        }
        */

        $file = basename($path);
        $status = ftp_fput($ftp, $file, $temp, FTP_ASCII);
        fclose($temp);
        @ftp_site($ftp, "chmod 0600 $file");
        if (!$status) {
            @ftp_close($ftp);
            return array(FALSE, "error changing $file: $php_errormsg");
        }
    }
    // otherwise delete the remote file (we don't want to leave an empty file)
    else {
        if (@ftp_size($ftp, $path) > 0) {
            $status = @ftp_delete($ftp, $path);
            if (!$status) {
                @ftp_close($ftp);
                return array(FALSE, "error removing $path: $php_errormsg");
            }
        }
    }

    @ftp_close($ftp);

    return array(TRUE);
}


/* sr_syslog($message)
 * 
 * Write a message to the syslog.
 * 
 * Parameters:
 *   $mesg:     text to send
 * 
 * Returns:
 *   nothing
 */
function sr_syslog($message)
{
    define_syslog_variables();
    openlog('spamrule', LOG_NDELAY, LOG_DAEMON);
    syslog(LOG_ERR, $message);
    closelog();
}


/* sr_install_forward($install_filter)
 * 
 * Install the filtering command into the user's forward file via FTP.
 * If the forward file already has a line matching
 * $SPAMRULE_INSTALL['forward_pattern'], then the file won't be changed.
 * If it has a line matching $SPAMRULE_INSTALL['inbox_pattern'], then that
 * will be replaced with $SPAMRULE_INSTALL['forward_string'].  If neither
 * is found, the file will be appended with a brief comment and the
 * 'forward_string'.
 * 
 * Parameters:
 *   $install_filter:  boolean value indicating whether the new forward file
 *                     should add the filter command or not
 * 
 *  Returns:
 *    The result from sr_ftp_put():
 *    a 2-part array, with the first part indicating success (TRUE) or failure
 *    (FALSE) and the second part containing an error message in the case of
 *    failure
 */
function sr_install_forward($install_filter)
{
    global $username, $SPAMRULE_VERSION, $SPAMRULE_INSTALL;

    $forward = '';
    $has_filter = FALSE;
    $changed = FALSE;
    $data = '';

    // download and the installed forward file
    $forward = sr_ftp_get($SPAMRULE_INSTALL['forward_file']);

    // search through the forward file and look for an entry matching
    // the filter string or explicit storage to the local inbox.
    reset($forward);
    while (list($i, $f) = each($forward)) {
        //$f = trim($f);
        // skip if the line is empty
        if (!$f)
            continue;

        // if the forward file has our filtering string pattern, we
        // won't need to add it.
        if (ereg($SPAMRULE_INSTALL['forward_pattern'], $f)) {
            $has_filter = TRUE;
	    // but if we don't want it there any more, we should remove it
            if (!$install_filter) {
		unset($forward[$i]);
                $changed = TRUE;
            }
        }
        // if the forward file saves to the local Incoming mailbox, we
        // want to change that to run through the filter instead.
        if ($install_filter && ereg($SPAMRULE_INSTALL['inbox_pattern'], $f)) {
            $forward[$i] = $SPAMRULE_INSTALL['forward_string'];
            $has_filter = TRUE;
            $changed = TRUE;
        }
    }

    // convert the forward file contents from an array into a string
    $data = $forward ? implode("\n", $forward) : '';

    // the filter wasn't found in the file,, so we need to append it
    if ($install_filter && !$has_filter) {
        $data .= $SPAMRULE_INSTALL['forward_string']. "\n";
        $changed = TRUE;
    }

    // save the new file if we must
    if ($changed)
        return sr_ftp_put($SPAMRULE_INSTALL['forward_file'], $data);
    else
        return array(TRUE);
}
