<?php /* 'php' Added by ri_once */

/* SpamAssassin Frontend function file Version 1.0b
   Written by jwarn@intac.com 26apr02 */

/* This file will contain functions for items that are used over and over again */

/* build_sf_list function reads in the config file into an array then splits it
   and sorts it by the type of entry it is. Adding other SA types should be fairly
   easy down the road. There are 3 current types which can have multiple entires per array:
  
   - score <TEST> <VALUE> (For changing score other than the default)
   - whitelist_from (Good users that you want to allow)
   - blacklist_from (Block them)

   There are 3 current types that only support single entries:
  
   - required_hits (What is your threhold)
   - subject_tag (If you want to flag it as spam and rewrite subject)
   - defang_mime (By default SA turns messages into text/plain, this will turn that off)

   Possible future additions will be:

   - rewrite_subject (For those who do not want to rewrite it)
   - ok_locales (For those who get mail in foreign lang)
   - report_header (SA's test results will go into the header instead)
   - use_terse_report (Shortens the result explainations)
   - check_mx_attempts (How many times it will check for mx lookups)
   - check_mx_delay (How long the timeout is default is 5 seconds)


  Still Left to do:

   - Create a backup/restore sequence in case of failure
   - If adding to bl/wl check other list and remove entry if found
   - Fix bugs!

*/

function build_sf_list($sf_user_file){

/* Setup some important stuff */

$sf_list = file("$sf_user_file");
$sf_ll = sizeof($sf_list);
$sf_score = array(); /* Will have ability of more than one */
$sf_wl = array(); /* Will have ability of more than one */
$sf_bl = array(); /* Will have ability of more than one */

/* Should not have to change anything below */


 for($sf = 0 ; $sf<$sf_ll; $sf++) {

   $sf_array = split("\t",$sf_list[$sf]);

	if($sf_array[0] == "#"){}

	if($sf_array[0] == "required_hits"){
	   $sf_rh = array($sf_list[$sf]);
					   }

	if($sf_array[0] == "subject_tag"){
	   $sf_st = array($sf_list[$sf]);
					 }

	if($sf_array[0] == "defang_mime"){
	   $sf_dm = array($sf_list[$sf]);
					 }

	if($sf_array[0] == "score"){
	   array_push($sf_score,$sf_list[$sf]);
				   }

	if($sf_array[0] == "whitelist_from"){
	   array_push($sf_wl,$sf_list[$sf]);
					    }

	if($sf_array[0] == "blacklist_from"){
	   array_push($sf_bl,$sf_list[$sf]);
					    }

					}
	$final_sf_array = array($sf_rh,$sf_st,$sf_dm,$sf_score,$sf_wl,$sf_bl);

	return $final_sf_array;
		}


/* Function for rewriting the <user>.spam file */
function  rewrite_sf_conf($sf_user_file,$ch_sf_type,$ch_sf_gen,$ch_sf_scores,$ch_sf_wl,$ch_sf_bl){
  

/* General settings change */
   if($ch_sf_type == "ch_sf_gen"){
	$write_sf_rh = $ch_sf_gen[0];
	$write_sf_st = stripslashes($ch_sf_gen[1]);
	$write_sf_dm = $ch_sf_gen[2];
	$write_sf_sc = $ch_sf_scores;
	$write_sf_wl = $ch_sf_wl;
	$write_sf_bl = $ch_sf_bl;

			      }

/* Add/Change/Delete Spam Scores */
   if($ch_sf_type == "rw_sf_score"){
	#Add New Score
	$write_sf_rh = $ch_sf_gen[0];
	$write_sf_st = $ch_sf_gen[1];
	$write_sf_dm = $ch_sf_gen[2];
	$write_sf_sc = $ch_sf_scores;
	$write_sf_wl = $ch_sf_wl;
	$write_sf_bl = $ch_sf_bl;
				    }

/* Add/Delete White List */
   if($ch_sf_type == "rw_sf_whitelist"){
	#Add new whitelist entry
	$write_sf_rh = $ch_sf_gen[0];
	$write_sf_st = $ch_sf_gen[1];
	$write_sf_dm = $ch_sf_gen[2];
	$write_sf_sc = $ch_sf_scores;
	$write_sf_wl = $ch_sf_wl;
	$write_sf_bl = $ch_sf_bl;
				 }


/* Add/Delete Black List */
   if($ch_sf_type == "rw_sf_blacklist"){
	#Add new blacklist entry
	$write_sf_rh = $ch_sf_gen[0];
	$write_sf_st = $ch_sf_gen[1];
	$write_sf_dm = $ch_sf_gen[2];
	$write_sf_sc = $ch_sf_scores;
	$write_sf_wl = $ch_sf_wl;
	$write_sf_bl = $ch_sf_bl;
				 }


/* Rewrite the file now */
/* we should either get the $user from a cookie/session or pass it via the function? */
$fp = @fopen("$sf_user_file", "w+");
flock($fp,6);
fputs($fp,"#If you edit manually be sure you know what you are doing\n");
fputs($fp,"#It is a 'tab' between the items, be sure to keep it that way\n\n");
fputs($fp,"\n#Required Hits\n");
fputs($fp,"required_hits\t$write_sf_rh");
fputs($fp,"\n\n#Subject Tag\n");
fputs($fp,"subject_tag\t$write_sf_st");
fputs($fp,"\n\n#Defang Mime\n");
fputs($fp,"defang_mime\t$write_sf_dm");
fputs($fp,"\n\n#Personalized Scores\n");
 foreach($write_sf_sc as $sf_){ fputs($fp, "$sf_"); }
fputs($fp,"\n\n#White List\n");
 foreach($write_sf_wl as $wl_){ fputs($fp, "$wl_"); }
fputs($fp, "\n\n#Black List\n");
 foreach($write_sf_bl as $bl_){ fputs($fp, "$bl_"); }
fputs($fp, "\n\n#End of Configuration\n");
fclose($fp);


	}


/* Uncomment when ready for testing

function check_sf_consist($my_sf_config){
	
	if(sizeof("configs/$my_sf_config") <= 0){
	    $sf_check = "0";
						}
	
	else{ $sf_check = "1"; }

	return $sf_check;
					}
		


*/


?>
