<?php

   /*
    *  S/MIME 0.6
    *  this release Wouter Teepe <wouter@teepe.com> and Antonio Vasconcelos
    *  (c) 2003 (GNU GPL - see ../../COPYING)
    *
    *  This plugin enables the viewing of s/mime signed messages of the
    *  mime "multipart/signed" format.
    *  It enables the user to verify the message, the sender's certificate, to
    *  view and to download the certificate.
    *
    *  Adjust the ./config.php file to your local setup!
    *
    *  Although the subject of the plugin is secirity, I offer no guarantee
    *  at all for fitness for any particular purpose.
    *
    *  This plugin requires openssl 0.9.6 to be installed, it does not use
    *  the openssl extensions of php (that is a *feature*, since they're buggy)
    *
    *  Some paths of executables are needed, they are stored in config.php
    *
    *  This plugin has been built with squirrelmail 1.2.0rc1 as testing
    *  platform, but should (I think) work happily from squirrelmail version
    *  1.1.1.
    *  Testing software environment was Linux 2.4.4, php 4.0.6 and openssl 0.9.6
    *
    *  The plugin has not yet been intentionally adjusted for platform portability
    *  Any suggestions on this subject are welcome.
    *
    *  If you need help with this, or see improvements that can be made, please
    *  email me directly at the address above.  I definately welcome suggestions
    *  and comments.  This plugin, as is the case with all SquirrelMail plugins,
    *  is not directly supported by the developers.  Please come to me off the
    *  mailing list if you have trouble with it.
    *
    *  [vasco@threatconn.com] - 2003.04.10
    *  modified to work with squirrelmail 1.2.11, PHP 4.3.1, openssl 0.9.7a in
    *  linux with kernel 2.4.18
    *
    */

   if (!defined('SM_PATH'))
      define('SM_PATH','../../');
   
   if (file_exists(SM_PATH . 'include/validate.php')) {
      include_once(SM_PATH . 'include/validate.php');
   } else {
      if (file_exists(SM_PATH . 'src/validate.php'))
         include_once(SM_PATH . 'src/validate.php');
   }

   include_once(SM_PATH . 'plugins/smime/functions.php');

   sqgetGlobalVar('cert', $cert, SQ_GET);
   sqgetGlobalVar('mailbox', $mailbox, SQ_GET);
   sqgetGlobalVar('passed_id', $passed_id, SQ_GET);
   sqgetGlobalVar('startMessage', $startMessage, SQ_GET);
   sqgetGlobalVar('show_more', $show_more, SQ_GET);


   function x509_match($a, $b) {
      $len = strlen($b);
      $a = trim($a);
      if (substr($a, 0, $len) == $b) {
         return trim(substr($a, $len));
      } else
         return "";
   }

   function x509_split($a, $b, $c) {
      $res = "";
      $lines = preg_split("/\/\w*=/", $a, -1, PREG_SPLIT_NO_EMPTY);
      for ($i = 0; $i < count($lines); $i++) {
         $res = $b . $lines[$i] . $c . $res;
      }
      return $res;
   }

   function x509_open($cert) {
      global $cert_in_dir, $openssl;
      $lines = array();
      $safe_cert = escapeshellarg("$cert_in_dir$cert");
      exec("$openssl x509 -in $safe_cert -subject -issuer -dates -serial -fingerprint -noout 2>/tmp/err",
         $lines);
      return array(
         x509_split(x509_match($lines[0], "subject="), "", "\n"),
         x509_split(x509_match($lines[1], "issuer="), "", "\n"),
         x509_match($lines[2], "notBefore="),
         x509_match($lines[3], "notAfter="),
         substr(ereg_replace("(..)", ":\\1", x509_match($lines[4], "serial=")),1),
         x509_match($lines[5], "MD5 Fingerprint=")
      );
   }

   function show_field($name, $cont) {
     global $color;
     echo "<TR><TD VALIGN=TOP ALIGN=RIGHT WIDTH=\"10%\" BGCOLOR=\"$color[4]\">";
     echo $name;
     echo "</TD><TD VALIGN=TOP WIDTH=\"90%\" BGCOLOR=\"$color[4]\"><B>";
     echo nl2br(htmlentities($cont));
     echo "</B></TD></TR>\n";
   }

   displayPageHeader($color, "None");

   echo "<BR><TABLE WIDTH=100% BORDER=0 CELLSPACING=0 CELLPADDING=2 ALIGN=CENTER>\n";
   echo "<TR><TD BGCOLOR=\"$color[0]\">";
   echo "<B><CENTER>";
   echo _("Viewing a S/MIME certificate") . " - ";
   if (isset($where) && isset($what)) {
      // from a search
      echo "<a href=\"../../src/read_body.php?mailbox=".urlencode($mailbox)."&passed_id=$passed_id&where=".urlencode($where)."&what=".urlencode($what)."\">". _("View message") . "</a>";
   } else {   
      echo "<a href=\"../../src/read_body.php?mailbox=".urlencode($mailbox)."&passed_id=$passed_id&startMessage=$startMessage&show_more=0\">". _("View message") . "</a>";
   }   

   $DownloadLink = "downloadcert.php?cert=" . $cert;

   echo "</b></td></tr>\n";
   echo "<tr><td align=center><A HREF=\"$DownloadLink\">";
   echo _("Download this as a file");
   echo "</A></TD></TR></TABLE>\n";
   echo "</A></TD></TR>\n";

   list ($ow, $is, $nb, $na, $sn, $fp) = x509_open($cert);

   echo "<TABLE WIDTH=\"100%\" BORDER=0 CELLSPACING=0 CELLPADDING=3>\n";
   show_field("Owner:", $ow);
   show_field("Issuer:", $is);
   show_field("Valid from:", $nb);
   show_field("Valid thru:", $na);
   show_field("Serial:", $sn);
   show_field("Fingerprint:", $fp);
   echo "</TABLE>\n";
   echo "</body></html>\n";

?>
