<?php

   /*
    *  S/MIME 0.4
    *  this release Wouter Teepe <wouter@teepe.com> and Antonio Vasconcelos
    *  (c) 2003 (GNU GPL - see ../../COPYING)
    *
    *  This plugin enables the viewing of s/mime signed messages of the
    *  mime "multipart/signed" format.
    *  It enables the user to verify the message, the sender's certificate, to
    *  view and to download the certificate.
    *
    *  Adjust the ./config.php file to your local setup!
    *
    *  Although the subject of the plugin is security, I offer no guarantee
    *  at all for fitness for any particular purpose.
    *
    *  This plugin requires openssl 0.9.6 to be installed, it does not use
    *  the openssl extensions of php (that is a *feature*, since they're buggy)
    *
    *  Some paths of executables are needed, they are stored in config.php
    *
    *  This plugin has been built with squirrelmail 1.2.0rc1 as testing
    *  platform, but should (I think) work happily from squirrelmail version
    *  1.1.1.
    *  Testing software environment was Linux 2.4.4, php 4.0.6 and openssl 0.9.6
    *
    *  The plugin has not yet been intentionally adjusted for platform portability
    *  Any suggestions on this subject are welcome.
    *
    *  If you need help with this, or see improvements that can be made, please
    *  email me directly at the address above.  I definately welcome suggestions
    *  and comments.  This plugin, as is the case with all SquirrelMail plugins,
    *  is not directly supported by the developers.  Please come to me off the
    *  mailing list if you have trouble with it.
    *
    *  [vasco@threatconn.com] - 2003.04.10
    *  modified to work with squirrelmail 1.2.11, PHP 4.3.1, openssl 0.9.7a in
    *  linux with kernel 2.4.18
    */

//   include("../config/config.php");
   include_once("../plugins/smime/config.php");

   /* Initialize the s/mime plugin */
   function squirrelmail_plugin_init_smime() {
      global $squirrelmail_plugin_hooks;

      $squirrelmail_plugin_hooks['read_body_header']['smime'] = "smime_header_verify";
   }

   function verify_smime($message_in) {
      global $openssl, $echo, $cadir, $message, $cert_in_dir;
      $subjectmessage = escapeshellarg($message_in);
      $tmpcert = tempnam($cert_in_dir, "sm-smime-cert-");
      touch($tmpcert);
      chmod($tmpcert,0600);
      exec("$echo $subjectmessage | $openssl smime -verify -signer $tmpcert -noverify 2>/dev/null",
           $message_out, $retval);
      if ($retval == 0) {
         passthru("$echo $subjectmessage | $openssl smime -verify -CApath $cadir 2> /dev/null >/dev/null",
          $retval);
         if ($retval == 4) { $retval = 6; }
         exec("$openssl x509 -in $tmpcert -subject -hash -noout", $lines);


# [vasco]
# I had to change this, openssl is outputing /emailAddress instead of /Email
# have this been changed from 0.9.6 to 0.9.7 ??? or it's just with me because
# I'm using a private CA ?
# Maybe it's wiser to do an OR here...


###         preg_match("/\/CN=(.*)\/Email=(.*)(\/)?/", $lines[0], $res);
###         preg_match("/\/CN=(.*)\/emailAddress=(.*)(\/)?/", $lines[0], $res);

# [wouter]
# This is something of an OR ...

         preg_match("/\/CN=(.*)\/(emailAddress|Email)=(.*)(\/)?/", $lines[0], $res);

         $name = htmlentities($res[1] . " <" . $res[3] . ">");
         $longcert = $cert_in_dir . $lines[1] . '.O';
         if (file_exists($longcert)) {
            if (filesize($longcert) == filesize($tmpcert)) {
               $fa = fopen($longcert, "r"); $fb = fopen($tmpcert, "r");
               while (!feof ($fa)) {
                  $ba = fgets($fa, 4096);
                  $bb = fgets($fb, 4096);
                  if ($ba != $bb) { $unequal = 1; break; }
               }
               fclose($fa); fclose($fb);
            } else { $unequal = 1; }
            if (isset($unequal)) {
               $longcert = tempnam($cert_in_dir, $lines[1] . '.O');
            } else {
               $dontmove = 1;
               unlink($tmpcert);
            }
         }
         if (!isset($dontmove))
	{
# [vasco] 2003.04.10
# if /tmp is in a different filesystem rename will not work
# is there a better solution ?

		copy($tmpcert, $longcert);
		unlink($tmpcert);
#		rename($tmpcert, $longcert);
	}
         $tmpcert = $longcert;
      } else {
         unlink($tmpcert);
      }
      $message_out = implode("\r\n", $message_out);
      preg_match("/.*\/(.*)/", $tmpcert, $res);
      $cert = $res[1];
      return array($retval, $message_out, $name, $cert);
   }

   function show_verify($retval) {
      switch ($retval) {
         case 0: $str = "verified"; break;
         case 1: $str = "error 1; please send bug report"; break;
         case 2: $str = "error 2; please send bug report"; break;
         case 3: $str = "message format error"; break;
         case 4: $str = "message has been altered"; break;
         case 5: $str = "message has not been altered, but could not verify due to wrong system setup"; break;
         case 6: $str = "not verified"; break;
      }
      return $str;
   }

   function mime_fetch_full_body ($imap_stream, $id) {
      fputs ($imap_stream, "a010 FETCH $id BODY[]\r\n");
      $data = sqimap_read_data ($imap_stream, 'a010', true, $response, $message);
      $topline = array_shift($data);
      while (! ereg('\\* [0-9]+ FETCH ', $topline) && $data)
          $topline = array_shift($data);
      $wholemessage = implode('', $data);
      if (ereg('\\{([^\\}]*)\\}', $topline, $regs)) {
         return substr($wholemessage, 0, $regs[1]);
      }
      else if (ereg('"([^"]*)"', $topline, $regs)) {
         return $regs[1];
      }
      $str = "Body retrival error.  Please report this bug!\n";
      $str .= "Response:  $response\n";
      $str .= "Message:  $message\n";
      $str .= "FETCH line:  $topline";
      $str .= "---------------\n$wholemessage";
      foreach ($data as $d)
      {
          $str .= htmlspecialchars($d) . "\n";
      }
      return $str;
      return "Body retrival error, please report this bug!\n\nTop line is \"$topline\"\n";
   }

   function signed_parts($body) {
      if(preg_match("/(^.*^Content-Type:.*)\r\n\r\n/smUi", $body, $regs)) {
         if (preg_match("/^Content-Type: *multipart\/mixed/mi", $regs[1])) {
            $red = "Body: \r\nAttachments: \r\n" . $regs[1];
         } else {
            $red = "Body: \r\n" . $regs[1];
         }
         $red = preg_replace("/^Content-.*$/mi", "", $red);
         preg_match_all("/^(.*):/mU", $red, $matches);
         return implode(', ', $matches[1]);
      } else {
         return "Body";
      }
   }


   function smime_header_verify() {
      global $imapConnection, $passed_id, $color, $message,
         $mailbox, $where, $what, $startMessage;

      if ($message->header->type0 == "multipart" and $message->header->type1 == "signed") {
         fputs($imapConnection, "a001 FETCH $passed_id BODY.PEEK[HEADER.FIELDS (Content-Type)]\r\n");
         $read = sqimap_read_data($imapConnection, "a001", true, $response, $mess);
         if (eregi('protocol=(")?application/(x-)?pkcs7-signature(")?',
                 $read[1].$read[2].$read[3].$read[4], $regs)) {
            // we have a detatched s/mime message

            array_pop($message->entities);
            if (!isset($message->entities[1])) {
               $message->header->type0     = $message->entities[0]->header->type0;
               $message->header->type1     = $message->entities[0]->header->type1;
               $message->header->charset   = $message->entities[0]->header->charset;
               $message->header->encoding  = $message->entities[0]->header->encoding;
               $message->header->size      = $message->entities[0]->header->size;
               $message->header->filename  = $message->entities[0]->header->filename;
               $message->header->entity_id = $message->entities[0]->header->entity_id;
               $message->entities          = $message->entities[0]->entities;
            }

            $body = mime_fetch_full_body ($imapConnection, $passed_id);
            list ($retval, $lines, $name, $cert) = verify_smime($body);
            $ct = show_verify($retval);

            if ($retval == 0) { $colortag1=""; $colortag2=""; }
            else { $colortag1="<FONT COLOR=\"$color[2]\">"; $colortag2="</FONT>"; }
            $tworows = ($retval == 0 or $retval == 6);

            echo "      <TR>\n";
            echo "         <TH BGCOLOR=\"$color[9]\" ALIGN=\"LEFT\" VALIGN=TOP COLSPAN=3>\n";
            echo "           This message has been S/MIME signed\n";
            echo "         </TH>\n";
            echo "      </TR>\n";


            echo "      <TR>\n";
            echo "         <TD BGCOLOR=\"$color[0]\" WIDTH=15% ALIGN=RIGHT VALIGN=TOP>\n";
            echo "Signer:";
            echo "         </TD><TD BGCOLOR=\"$color[0]\" WIDTH=85% VALIGN=TOP>\n";
            echo "            <B>$colortag1 $name, $ct$colortag2</B>\n";
            echo "         </TD>\n";

            if ($tworows) { $rows=2; } else { $rows=1; }
            echo '         <TD ROWSPAN="'.$rows.'" width=10% BGCOLOR="'.$color[0].'" ALIGN=right VALIGN=top NOWRAP><small>' . "\n";

            if ($where && $what) {
              // from a search
              echo "<a href=\"../plugins/smime/viewcert.php?mailbox=".urlencode($mailbox)."&passed_id=$passed_id&where=".urlencode($where)."&what=".urlencode($what)."&cert=".$cert."\">". _("View certificate") . "</a><BR>";
      } else {
              echo "<a href=\"../plugins/smime/viewcert.php?mailbox=".urlencode($mailbox)."&passed_id=$passed_id&startMessage=$startMessage&show_more=0&cert=".$cert."\">". _("View certificate") . "</a><BR>";
      }   
            echo ' <A HREF="../plugins/smime/downloadcert.php?cert='.$cert.'">Download certificate</A><BR>'."\n";
            echo "         </small></TD>\n";

            echo "      </TR>\n";

            if ($tworows) {
               $sp = signed_parts($lines);

               echo "      <TR>\n";
               echo "         <TD BGCOLOR=\"$color[0]\" WIDTH=15% ALIGN=RIGHT VALIGN=TOP>\n";
               echo "Signed parts:"; 
               echo "         </TD><TD BGCOLOR=\"$color[0]\" WIDTH=85% VALIGN=TOP>\n";
               echo "            <B>$sp</B>\n";
               echo "         </TD>\n";
               echo "      </TR>\n";
            }
         }
      }
   }

?>
